/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkBasePathValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkVersionValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SdkTreeComposite
extends Composite {
    private TreeViewer treeViewer;
    private IValidator<String> nameValidator = new SdkNameValidator();
    private IValidator<String> versionValidator = new SdkVersionValidator();
    private IValidator<String> basePathValidator = new SdkBasePathValidator();

    public SdkTreeComposite(Composite parent) {
        super(parent, 0);
        this.setLayoutData(GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        this.treeViewer = new TreeViewer((Composite)this, 67584);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)SdkTreeComposite.getContentProvider());
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.treeViewer, 0);
        nameColumn.getColumn().setText(Messages.SdkTableViewerHolder_name_column_text);
        nameColumn.setLabelProvider(SdkTreeComposite.getCellLabelProvider("name"));
        TreeViewerColumn versionColumn = new TreeViewerColumn(this.treeViewer, 0);
        versionColumn.getColumn().setText(Messages.SdkTableViewerHolder_version_column_text);
        versionColumn.setLabelProvider(SdkTreeComposite.getCellLabelProvider("version"));
        TreeViewerColumn descriptionColumn = new TreeViewerColumn(this.treeViewer, 0);
        descriptionColumn.getColumn().setText(Messages.SdkTableViewerHolder_description_column_text);
        descriptionColumn.setLabelProvider(SdkTreeComposite.getCellLabelProvider("description"));
        TreeColumnLayout tableLayout = new TreeColumnLayout();
        this.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(250));
        tableLayout.setColumnData((Widget)versionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        tableLayout.setColumnData((Widget)descriptionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(200));
    }

    public void addSelectionChangeListener(Consumer<IStatus> consumer) {
        this.treeViewer.addSelectionChangedListener(event -> {
            IStructuredSelection ss = (IStructuredSelection)event.getSelection();
            Object selectedElement = ss.getFirstElement();
            if (selectedElement instanceof SdkWrapper) {
                consumer.accept(((SdkWrapper)selectedElement).getValidationStatus());
            }
        });
    }

    public void setInput(Map<String, Collection<SdkDescriptor>> input) {
        Map<String, Collection> inputMap = input.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Collection)e.getValue()).stream().map(sdkDescriptor -> new SdkWrapper((SdkDescriptor)sdkDescriptor)).collect(Collectors.toList())));
        this.treeViewer.setInput(inputMap);
        this.treeViewer.expandAll();
    }

    public Map<String, Collection<SdkDescriptor>> getSelectedItems(String directory) {
        return ((Map)this.treeViewer.getInput()).entrySet().stream().filter(entry -> ((Collection)entry.getValue()).stream().noneMatch(sdkWrapper -> !sdkWrapper.getValidationStatus().isOK())).collect(Collectors.toMap(e -> Paths.get(directory, (String)e.getKey()).toString(), e -> ((Collection)e.getValue()).stream().map(SdkWrapper::access$0).collect(Collectors.toList())));
    }

    private static ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof Map.Entry) {
                    return ((Collection)((Map.Entry)element).getValue()).toArray(new SdkWrapper[0]);
                }
                return new Object[0];
            }

            public Object[] getElements(Object element) {
                if (element instanceof Map) {
                    return ((Map)element).entrySet().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object arg0) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Map.Entry) {
                    return !((Collection)((Map.Entry)element).getValue()).isEmpty();
                }
                return false;
            }
        };
    }

    private static CellLabelProvider getCellLabelProvider(final String attributeId) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(this.getText(cell.getElement()));
                cell.setImage(this.getImage(cell.getElement()));
            }

            public String getText(Object element) {
                if (element instanceof Map.Entry && "name".equals(attributeId)) {
                    return (String)((Map.Entry)element).getKey();
                }
                if (element instanceof SdkWrapper) {
                    return ((SdkWrapper)element).getAttribute(attributeId);
                }
                return null;
            }

            public Image getImage(Object element) {
                if ("name".equals(attributeId) && (element instanceof Map.Entry ? ((Collection)((Map.Entry)element).getValue()).stream().anyMatch(sdk -> !sdk.getValidationStatus().isOK()) : element instanceof SdkWrapper && !((SdkWrapper)element).getValidationStatus().isOK())) {
                    return SdkUiActivator.getInstance().getImage("SDK_COMMON_ERROR_ICON");
                }
                return null;
            }
        };
    }

    private class SdkWrapper {
        private IStatus validationStatus;
        private SdkDescriptor sdk;

        private SdkWrapper(SdkDescriptor sdk) {
            this.sdk = sdk;
            this.validate();
        }

        private SdkDescriptor getSdk() {
            return this.sdk;
        }

        private IStatus getValidationStatus() {
            return this.validationStatus;
        }

        private String getAttribute(String attributeId) {
            switch (attributeId) {
                case "name": {
                    return this.sdk.getName();
                }
                case "version": {
                    return this.sdk.getVersion();
                }
                case "description": {
                    return this.sdk.getDescription();
                }
            }
            return "";
        }

        private void validate() {
            this.validationStatus = SdkTreeComposite.this.nameValidator.validate((Object)this.sdk.getName());
            if (this.validationStatus.isOK()) {
                this.validationStatus = SdkTreeComposite.this.versionValidator.validate((Object)this.sdk.getVersion());
            }
            if (this.validationStatus.isOK() && SdkManagementUtils.isSdkExists((String)this.sdk.getName(), (String)this.sdk.getVersion())) {
                this.validationStatus = SdkUiActivator.getInstance().createError(Messages.ImportSdkRenameDialog_error_sdk_with_same_name_version_exists);
            }
            if (this.validationStatus.isOK()) {
                this.validationStatus = SdkTreeComposite.this.basePathValidator.validate((Object)this.sdk.getBasePath());
            }
        }

        static /* synthetic */ SdkDescriptor access$0(SdkWrapper sdkWrapper) {
            return sdkWrapper.getSdk();
        }
    }
}

