/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkVersion;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkPageContentProvider;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkPageLabelProvider;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class SdkTableViewerHolder {
    private static final int CONFIGURATION_COLUMN_MIN_SIZE = 50;
    private static final int TABLE_VIEWER_STYLE = 67586;
    private static final String NAME_COLUMN_ID = "NAME";
    private static final String VERSION_COLUMN_ID = "VERSION";
    private static final String DEVICE_COLUMN_ID = "DEVICE";
    private static final String DEVICE_CORE_COLUMN_ID = "DEVICE_CORE";
    private static final String CORE_COLUMN_ID = "CORE";
    private static final String TYPE_COLUMN_ID = "TYPE";
    private static final String DESCRIPTION_COLUMN_ID = "DESCRIPTION";
    private static Map<String, Integer> standardColumns = new LinkedHashMap<String, Integer>();
    private final SDKSorter sorter = new SDKSorter();
    private final TableViewer tableViewer;
    private TableViewerColumn[] columns;
    private TableColumnLayout layout;

    static {
        standardColumns.put(NAME_COLUMN_ID, 240);
        standardColumns.put(VERSION_COLUMN_ID, 80);
        standardColumns.put(DEVICE_COLUMN_ID, 100);
        standardColumns.put(DEVICE_CORE_COLUMN_ID, 100);
        standardColumns.put(CORE_COLUMN_ID, 100);
        standardColumns.put(TYPE_COLUMN_ID, 100);
        standardColumns.put(DESCRIPTION_COLUMN_ID, 150);
    }

    public static SdkTableViewerHolder newCheckList(Composite composite) {
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67586);
        viewer.setContentProvider((IContentProvider)SdkPageContentProvider.getStructuredContentProvider());
        return new SdkTableViewerHolder((TableViewer)viewer, null, null);
    }

    public static SdkTableViewerHolder newSelList(Composite composite, IProject prj, Map<String, List<IStatus>> data) {
        TableViewer viewer = new TableViewer(composite, 268503042);
        viewer.setContentProvider((IContentProvider)SdkPageContentProvider.getLazyContentProvider(viewer));
        viewer.setUseHashlookup(true);
        return new SdkTableViewerHolder(viewer, prj, data);
    }

    public static SdkTableViewerHolder newList(Composite composite) {
        TableViewer viewer = new TableViewer(composite, 268503042);
        viewer.setContentProvider((IContentProvider)SdkPageContentProvider.getLazyContentProvider(viewer));
        viewer.setUseHashlookup(true);
        return new SdkTableViewerHolder(viewer, null, null);
    }

    public static SdkTableViewerHolder newSdkList(Composite composite) {
        TableViewer viewer = new TableViewer(composite, 67586);
        viewer.setContentProvider((IContentProvider)SdkPageContentProvider.getStructuredContentProvider());
        return new SdkTableViewerHolder(viewer, null, null);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public CheckboxTableViewer getCheckboxTableViewer() {
        return (CheckboxTableViewer)this.tableViewer;
    }

    private SdkTableViewerHolder(TableViewer tableViewer, IProject project, Map<String, List<IStatus>> data) {
        this.tableViewer = tableViewer;
        this.setup(project, data);
    }

    private int[] getDefaultColumnMinimumWidth() {
        IntStream.Builder intStreamBuilder = IntStream.builder().add(standardColumns.get(NAME_COLUMN_ID)).add(standardColumns.get(VERSION_COLUMN_ID));
        int configurationColumnsCount = this.columns.length - standardColumns.size();
        IntStream.generate(() -> 50).limit(configurationColumnsCount).forEach(intStreamBuilder::add);
        intStreamBuilder.add(standardColumns.get(DEVICE_COLUMN_ID)).add(standardColumns.get(DEVICE_CORE_COLUMN_ID)).add(standardColumns.get(CORE_COLUMN_ID)).add(standardColumns.get(TYPE_COLUMN_ID)).add(standardColumns.get(DESCRIPTION_COLUMN_ID));
        return intStreamBuilder.build().toArray();
    }

    private int[] getColumnWeight(int[] minimumWidths) {
        int totalWidth = Arrays.stream(minimumWidths).sum();
        double onePercent = (double)totalWidth / 100.0;
        int[] weights = new int[minimumWidths.length];
        int totalWeight = 0;
        int i = 0;
        while (i < this.columns.length - 1) {
            weights[i] = (int)((double)minimumWidths[i] / onePercent);
            ++i;
        }
        weights[this.columns.length - 1] = 100 - totalWeight;
        return weights;
    }

    private void setup(IProject prj, Map<String, List<IStatus>> data) {
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.layout = new TableColumnLayout();
        table.getParent().setLayout((Layout)this.layout);
        this.columns = this.createColumns(prj, data);
        this.setDefaultColumnLayout();
    }

    private void setDefaultColumnLayout() {
        int[] minimumWidths = this.getDefaultColumnMinimumWidth();
        int[] weights = this.getColumnWeight(minimumWidths);
        int i = 0;
        while (i < this.columns.length) {
            this.layout.setColumnData((Widget)this.columns[i].getColumn(), (ColumnLayoutData)new ColumnWeightData(weights[i], minimumWidths[i]));
            ++i;
        }
    }

    private TableViewerColumn[] createColumns(IProject project, Map<String, List<IStatus>> data) {
        SelectionListener selectionListener = this.createSelectionListener();
        ArrayList<TableViewerColumn> tableColumns = new ArrayList<TableViewerColumn>();
        this.createColumn(Messages.SdkTableViewerHolder_name_column_text, SdkPageLabelProvider.getNameLabelProvider(), selectionListener, tableColumns, NAME_COLUMN_ID, null);
        this.createColumn(Messages.SdkTableViewerHolder_version_column_text, SdkPageLabelProvider.getVersionLabelProvider(), selectionListener, tableColumns, VERSION_COLUMN_ID, null);
        if (project != null && project.isAccessible()) {
            List projectConfigurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
            int i = 0;
            while (i < projectConfigurations.size()) {
                String configName = ((IConfiguration)projectConfigurations.get(i)).getName();
                this.createColumn(configName, new SdkPageLabelProvider.CfgCellLabelProvider(i, data), null, tableColumns, "", configName);
                ++i;
            }
        }
        this.createColumn(Messages.SdkTableViewerHolder_devices_column_text, SdkPageLabelProvider.getHardwareLabelProvider("com.nxp.s32ds.cle.runtime.hardware.registry.device.id"), selectionListener, tableColumns, DEVICE_COLUMN_ID, null);
        this.createColumn(Messages.SdkTableViewerHolder_device_cores_column_text, SdkPageLabelProvider.getHardwareLabelProvider("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id"), selectionListener, tableColumns, DEVICE_CORE_COLUMN_ID, null);
        this.createColumn(Messages.SdkTableViewerHolder_cores_column_text, SdkPageLabelProvider.getHardwareLabelProvider("com.nxp.s32ds.cle.runtime.hardware.registry.core.id"), selectionListener, tableColumns, CORE_COLUMN_ID, null);
        this.createColumn(Messages.SdkTableViewerHolder_status_column_text, SdkPageLabelProvider.getStatusLabelProvider(data), selectionListener, tableColumns, TYPE_COLUMN_ID, null);
        this.createColumn(Messages.SdkTableViewerHolder_description_column_text, SdkPageLabelProvider.getDescriptionLabelProvider(), selectionListener, tableColumns, DESCRIPTION_COLUMN_ID, null);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        return tableColumns.toArray(new TableViewerColumn[tableColumns.size()]);
    }

    private SelectionListener createSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String columnDataId = (String)event.widget.getData();
                SdkTableViewerHolder.this.sorter.setSortParams(columnDataId);
                Table table = SdkTableViewerHolder.this.tableViewer.getTable();
                Optional<TableColumn> optional = Arrays.stream(table.getColumns()).filter(tableColumn -> columnDataId.equals(tableColumn.getData())).findFirst();
                if (optional.isPresent()) {
                    table.setSortColumn(optional.get());
                    table.setSortDirection(SdkTableViewerHolder.this.sorter.direction == 1 ? 1024 : 128);
                }
                List sdks = (List)SdkTableViewerHolder.this.tableViewer.getInput();
                sdks.sort(SdkTableViewerHolder.this.sorter);
                SdkTableViewerHolder.this.tableViewer.setInput((Object)sdks);
                SdkTableViewerHolder.this.tableViewer.refresh();
            }
        };
    }

    private void createColumn(String label, CellLabelProvider cellLabelProvider, SelectionListener selectionListener, List<TableViewerColumn> tableColumns, String dataId, String toolTipText) {
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setText(label);
        column.setLabelProvider(cellLabelProvider);
        if (selectionListener != null) {
            column.getColumn().addSelectionListener(selectionListener);
        }
        if (!dataId.isEmpty()) {
            column.getColumn().setData((Object)dataId);
        }
        if (toolTipText != null) {
            column.getColumn().setToolTipText(toolTipText);
        } else {
            column.getColumn().setToolTipText(label);
        }
        tableColumns.add(column);
    }

    public void resetTableLayout() {
        if (this.tableViewer == null) {
            return;
        }
        Table table = this.tableViewer.getTable();
        int size = table.getColumnCount();
        int[] order = new int[size];
        int i = 0;
        while (i < size) {
            order[i] = i;
            ++i;
        }
        table.setColumnOrder(order);
        this.setDefaultColumnLayout();
        this.tableViewer.getTable().getParent().layout(true);
    }

    private static class SDKSorter
    implements Comparator<SdkDescriptor>,
    Serializable {
        private static final long serialVersionUID = 7408581696211457651L;
        private String column;
        private int direction;

        private SDKSorter() {
        }

        private void setSortParams(String column) {
            if (column.equals(this.column)) {
                this.direction = 1 - this.direction;
            } else {
                this.column = column;
                this.direction = 0;
            }
        }

        @Override
        public int compare(SdkDescriptor sdk1, SdkDescriptor sdk2) {
            int result = 0;
            switch (this.column) {
                case "NAME": {
                    result = sdk1.getName().toLowerCase().compareTo(sdk2.getName().toLowerCase());
                    break;
                }
                case "VERSION": {
                    result = SdkVersion.createVersion((String)sdk1.getVersion()).compareTo(SdkVersion.createVersion((String)sdk2.getVersion()));
                    break;
                }
                case "DEVICE": {
                    result = this.compareHardwareIds(sdk1.getId(), sdk2.getId(), "com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
                    break;
                }
                case "DEVICE_CORE": {
                    result = this.compareHardwareIds(sdk1.getId(), sdk2.getId(), "com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
                    break;
                }
                case "CORE": {
                    result = this.compareHardwareIds(sdk1.getId(), sdk2.getId(), "com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
                    break;
                }
                case "TYPE": {
                    result = sdk1.getType().getName().compareTo(sdk2.getType().getName());
                    break;
                }
                case "DESCRIPTION": {
                    result = sdk1.getDescription().toLowerCase().compareTo(sdk2.getDescription().toLowerCase());
                }
            }
            return this.direction == 0 ? result : -result;
        }

        private String getHardwareId(String sdkId, String hardwareParameter) {
            Set hardwareIds = SdkManagementUtils.getSdkHardwareIds((String)sdkId, (String)hardwareParameter);
            return !hardwareIds.isEmpty() ? (String)hardwareIds.iterator().next() : "";
        }

        private int compareHardwareIds(String sdk1Id, String sdk2Id, String hardwareParameter) {
            String hardwareId1 = this.getHardwareId(sdk1Id, hardwareParameter);
            String hardwareId2 = this.getHardwareId(sdk2Id, hardwareParameter);
            return hardwareId1.compareTo(hardwareId2);
        }
    }
}

