/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.utils.register;

import com.nxp.s32ds.cle.ide.internal.sdk.core.ProjectSdkDescriptorImplementation;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkActionsRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkBuildStepsRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkConditionsRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkHardwareRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkModulesRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkResourcesRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkSymbolsRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkToolChainsRegistrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.environment.EnvironmentSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.lang.LangSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.lang.LangSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SdkRegistrationHelper {
    private SdkRegistrationHelper() {
    }

    static void registerSdk(Element sdkElement, SdkType sdkType, String projectName) {
        SdkRegistrationHelper.registerSdk(sdkElement, sdkType, projectName, (IProgressMonitor)new NullProgressMonitor());
    }

    static void registerSdk(Element sdkElement, SdkType sdkType, String projectName, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)110);
        SdkDescriptorImplementation sdkDescriptor = new SdkDescriptorImplementation(sdkElement, sdkType);
        subMonitor.worked(10);
        SdkDescriptors.addSdkDescriptor((SdkDescriptor)sdkDescriptor);
        subMonitor.worked(10);
        String sdkId = sdkDescriptor.getId();
        SdkRegistrationHelper.removeOldPaths((SdkDescriptor)sdkDescriptor, sdkElement);
        subMonitor.worked(10);
        SdkRegistrationHelper.registerLang(sdkElement, sdkId);
        subMonitor.worked(10);
        SdkHardwareRegistrationHelper.registerHardware(sdkElement, sdkId);
        subMonitor.worked(10);
        SdkRegistrationHelper.registerEnvironment(sdkElement, sdkId);
        subMonitor.worked(10);
        SdkToolChainsRegistrationHelper.registerToolChains(sdkElement, sdkId);
        subMonitor.worked(10);
        SdkRegistrationHelper.registerPlatform(sdkElement, sdkId);
        subMonitor.worked(10);
        SdkModulesRegistrationHelper.registerModules(sdkElement, sdkId);
        subMonitor.worked(10);
        SdkBuildStepsRegistrationHelper.registerBuildSteps(sdkElement, sdkId);
        subMonitor.worked(10);
        if (projectName != null) {
            ProjectSdkDescriptors.addProjectSdkDescriptor(new ProjectSdkDescriptorImplementation(sdkElement, projectName));
        }
        subMonitor.worked(10);
    }

    static void unregisterSdk(String sdkId) {
        if (SdkDescriptors.getSdkDescriptor((String)sdkId) != null) {
            SdkDescriptors.removeSdkDescriptor((String)sdkId);
        }
        if (!LangSdkDescriptors.getLangSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            LangSdkDescriptors.removeLangSdkDescriptors((String)sdkId);
        }
        SdkHardwareRegistrationHelper.unregisterHardware(sdkId);
        SdkResourcesRegistrationHelper.unregisterResources(sdkId);
        SdkToolChainsRegistrationHelper.unregisterToolChains(sdkId);
        if (!EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            EnvironmentSdkDescriptors.removeEnvironmentSdkDescriptors((String)sdkId);
        }
        SdkSymbolsRegistrationHelper.unregisterSymbols(sdkId);
        PlatformSdkDescriptors.removePlatformSdkDescriptors((String)sdkId);
        SdkActionsRegistrationHelper.unregisterActions(sdkId);
        SdkConditionsRegistrationHelper.unregisterConditions(sdkId);
        SdkBuildStepsRegistrationHelper.unregisterBuildSteps(sdkId);
        SdkModulesRegistrationHelper.unregisterModules(sdkId);
        if (!ProjectSdkDescriptors.getProjectSdkDescriptorsBySdkId(sdkId).isEmpty()) {
            ProjectSdkDescriptors.removeProjectSdkDescriptors(sdkId);
        }
    }

    private static void registerLang(Element sdkElement, String sdkId) {
        if (sdkElement.getAttribute("id").isEmpty() && !Objects.toString(sdkId, "").isEmpty()) {
            sdkElement.setAttribute("id", sdkId);
        }
        if (!sdkElement.getAttribute("id").isEmpty()) {
            LangSdkDescriptors.addLangSdkDescriptor((LangSdkDescriptor)new LangSdkDescriptorImplementation(sdkElement));
        }
    }

    private static void registerEnvironment(Element sdkElement, String sdkId) {
        List<Element> environmentElements = SdkDescriptorsRegitsrationHelper.getElements("env", sdkElement);
        if (!environmentElements.isEmpty()) {
            EnvironmentSdkDescriptors.addEnvironmentSdkDescriptor((EnvironmentSdkDescriptor)new EnvironmentSdkDescriptorImplementation(environmentElements.get(0), sdkId));
        }
    }

    private static void registerPlatform(Element sdkElement, String sdkId) {
        SdkDescriptorsRegitsrationHelper.getElements("platform", sdkElement).forEach(element -> PlatformSdkDescriptors.addPlatformSdkDescriptors((Element)element, (String)sdkId));
    }

    private static void removeOldPaths(SdkDescriptor sdkDescriptor, Element sdkElement) {
        String newPath = SdkRegistrationHelper.getNewPath(sdkDescriptor);
        for (ResourceSdkKind kind : ResourceSdkKind.validValues()) {
            NodeList nl = sdkElement.getElementsByTagName(kind.getXmlElementName());
            int j = 0;
            while (j < nl.getLength()) {
                Element resourceElement = (Element)nl.item(j);
                Path resourcePath = Paths.get(resourceElement.getAttribute("path").trim(), new String[0]);
                if (resourcePath.isAbsolute() && !resourcePath.toString().contains(newPath) && sdkDescriptor.getType() != SdkType.EXTERNAL) {
                    resourceElement.removeAttribute("path");
                }
                ++j;
            }
        }
    }

    private static String getNewPath(SdkDescriptor sdkDescriptor) {
        try {
            return String.valueOf(new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkDescriptor.getBasePath())).getCanonicalPath()) + File.separator;
        }
        catch (IOException | CoreException throwable) {
            return sdkDescriptor.getBasePath();
        }
    }
}

