/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.internal.sdk.core.Messages;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkRegistry;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ProjectSdkDescriptors {
    private ProjectSdkDescriptors() {
    }

    public static ProjectSdkRegistry getProjectSdkRegistry() {
        return IdeSdkCoreActivator.getInstance().getProjectSdkRegistry();
    }

    public static List<ProjectSdkDescriptor> getProjectSdkDescriptors() {
        return ProjectSdkDescriptors.getProjectSdkRegistry().getProjectSdkDescriptors();
    }

    public static List<ProjectSdkDescriptor> getProjectSdkDescriptorsByProjectName(String projectName) {
        return ProjectSdkDescriptors.getProjectSdkRegistry().getProjectSdkDescriptorsByProjectName(projectName);
    }

    public static List<ProjectSdkDescriptor> getProjectSdkDescriptorsBySdkId(String sdkId) {
        return ProjectSdkDescriptors.getProjectSdkRegistry().getProjectSdkDescriptorsBySdkId(sdkId);
    }

    public static ProjectSdkDescriptor getProjectSdkDescriptorBySdkId(String sdkId) {
        return ProjectSdkDescriptors.getProjectSdkRegistry().getProjectSdkDescriptorsBySdkId(sdkId).stream().findFirst().orElse(null);
    }

    public static ProjectSdkDescriptor getProjectSdkDescriptorBySdkIdAndProjectName(String sdkId, String projectName) {
        return ProjectSdkDescriptors.getProjectSdkRegistry().getProjectSdkDescriptorsBySdkId(sdkId).stream().filter(projectSdkDescriptor -> projectName.equals(projectSdkDescriptor.getProjectName())).findFirst().orElse(null);
    }

    public static void addProjectSdkDescriptor(ProjectSdkDescriptor descriptor) {
        ProjectSdkDescriptors.getProjectSdkRegistry().addProjectSdkDescriptor(descriptor);
        IdeSdkCoreActivator.getInstance().logInfo(NLS.bind((String)Messages.ProjectSdkDescriptors_register_descriptor_message, (Object)descriptor.getProjectName(), (Object)descriptor.getSdkId()));
    }

    public static void removeProjectSdkDescriptor(ProjectSdkDescriptor descriptor) {
        ProjectSdkDescriptors.getProjectSdkRegistry().removeProjectSdkDescriptor(descriptor);
        IdeSdkCoreActivator.getInstance().logInfo(NLS.bind((String)Messages.ProjectSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getProjectName(), (Object)descriptor.getSdkId()));
    }

    public static void removeProjectSdkDescriptors(String sdkId) {
        ProjectSdkDescriptors.getProjectSdkRegistry().removeProjectSdkDescriptorsBySdkId(sdkId);
        IdeSdkCoreActivator.getInstance().logInfo(NLS.bind((String)Messages.ProjectSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }
}

