/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.ImageLengthSetting;
import com.nxp.swtools.bootimage.settings.ImageSegment;
import com.nxp.swtools.bootimage.settings.ImageTagSetting;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.settings.VersionSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="header", strict=false)
public class ImageHeader
extends ABaseComponentSetting {
    private static final Logger LOGGER = LogManager.getLogger(ImageHeader.class);
    @Attribute(name="offset", required=true)
    private String offset;
    @Attribute(name="size", required=true)
    private String size;
    @Element(name="tag", required=false)
    private ImageTagSetting tag;
    @Element(name="img_length", required=false)
    @Nullable
    private @Element(name="img_length", required=false) @Nullable ImageLengthSetting imageLength;
    @Element(name="version", required=false)
    private VersionSetting version;
    @Attribute(name="byte_order", required=false)
    private String byteOrder = "be";
    @Attribute(name="image_length", required=false)
    @Nullable
    private @Attribute(name="image_length", required=false) @Nullable String imageLengthValue;
    private ImageSegment imageSegment;

    public ImageHeader(String id, String label, @Nullable Description description, String offset, String size, ImageTagSetting tag, @Nullable ImageLengthSetting imageLength, VersionSetting version, String value, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, value, options, messages, -1L, "");
        this.offset = offset;
        this.size = size;
        this.tag = tag;
        this.imageLength = imageLength;
        this.version = version;
        this.imageSegment = new ImageSegment(this.getId(), this.getOffsetValue(), this.getSizeValueInBytes(), ByteBuffer.wrap(this.getBufferToWrite()));
    }

    public ImageHeader() {
        this.size = "";
        this.offset = "";
        this.tag = new ImageTagSetting();
        this.imageLength = null;
        this.version = new VersionSetting();
        this.imageSegment = new ImageSegment(this.getId(), 0, 0, ByteBuffer.allocate(8));
    }

    public ImageHeader(String id, String label, @Nullable Description description, String offset, String size, ImageTagSetting tag, ImageLengthSetting imageLength, VersionSetting version, String value, String byteOrder, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, value, options, messages, -1L, "");
        this.offset = offset;
        this.size = size;
        this.tag = tag;
        this.imageLength = imageLength;
        this.version = version;
        this.imageSegment = new ImageSegment(this.getId(), 0, 0, ByteBuffer.allocate(8));
        this.byteOrder = byteOrder;
    }

    public String getOffset() {
        return this.offset;
    }

    public String getSize() {
        return this.size;
    }

    public ImageTagSetting getTag() {
        return this.tag;
    }

    public @Nullable ImageLengthSetting getImageLength() {
        return this.imageLength;
    }

    public VersionSetting getVersion() {
        return this.version;
    }

    public int getOffsetValue() {
        int offsetVal = 0;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.offset)) {
            offsetVal = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.offset);
        } else if (NumberFormatValidator.isValidDecimal((String)this.offset)) {
            offsetVal = NumberFormatValidator.getIntFromStringDecimal((String)this.offset);
        }
        return offsetVal;
    }

    public int getSizeValueInBytes() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.size);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                sizeVal = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                return sizeVal;
            }
        }
        return sizeVal;
    }

    public long getTagValue() {
        return this.getTag().getTagValue();
    }

    public List<Long> getPossibleTagValues() {
        return this.getTag().getPossibleTagValues();
    }

    public long getVersionValue() {
        return this.getVersion().getVersionValue();
    }

    public int getImageLengthValue() {
        if (this.imageLength != null) {
            return this.imageLength.getImageLengthValue();
        }
        if (this.imageLengthValue != null) {
            if (NumberFormatValidator.isValidXmlHexFormat((String)this.imageLengthValue)) {
                return NumberFormatValidator.getDecimalIntegerFromXmlHex((String)UtilsText.safeString((String)this.imageLengthValue));
            }
            if (NumberFormatValidator.isValidDecimal((String)this.getInitValue())) {
                return NumberFormatValidator.getIntFromStringDecimal((String)UtilsText.safeString((String)this.imageLengthValue));
            }
        }
        return 0;
    }

    public long getHeaderValue() {
        long headerValue = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.getInitValue())) {
            headerValue = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.getInitValue());
        } else if (NumberFormatValidator.isValidDecimal((String)this.getInitValue())) {
            headerValue = NumberFormatValidator.getLongFromStringDecimal((String)this.getInitValue());
        }
        return headerValue;
    }

    public ImageSegment getImageSegment() {
        return this.imageSegment;
    }

    public void setImageSegment(ImageSegment imageSegment) {
        this.imageSegment = imageSegment;
    }

    public byte[] getBufferToWrite() {
        int sizeInBytes = this.getSizeValueInBytes();
        ByteBuffer bufferToWrite = ByteBuffer.allocate(sizeInBytes);
        if (!this.getInitValue().equals("")) {
            bufferToWrite.put(NumberFormatter.getValueBytes((BigInteger)BigInteger.valueOf(this.getHeaderValue()), (int)sizeInBytes));
        } else {
            byte[] tagBuffer = this.tag.getBufferToWrite();
            int i = 0;
            while (i < this.tag.getSizeValue()) {
                bufferToWrite.put(this.tag.getOffsetValue() + i, tagBuffer[i]);
                ++i;
            }
            if (this.imageLength != null) {
                byte[] imageLenBuffer = this.imageLength.getBufferToWrite();
                assert (this.imageLength != null);
                int imageLengthSize = this.imageLength.getSizeValue();
                int i2 = 0;
                while (i2 < imageLengthSize) {
                    assert (this.imageLength != null);
                    int imageLengthOffset = this.imageLength.getOffsetValue();
                    bufferToWrite.put(imageLengthOffset + i2, imageLenBuffer[i2]);
                    ++i2;
                }
            }
            byte[] versionBuffer = this.version.getBufferToWrite();
            int i3 = 0;
            while (i3 < this.version.getSizeValue()) {
                bufferToWrite.put(this.version.getOffsetValue() + i3, versionBuffer[i3]);
                ++i3;
            }
        }
        return NumberFormatter.convertEndianness((byte[])Objects.requireNonNull(bufferToWrite.array()), (int)sizeInBytes, (String)this.byteOrder);
    }

    public String getByteOrder() {
        return this.byteOrder;
    }
}

