/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.undo;

import org.eclipse.nebula.visualization.internal.xygraph.undo.AnnotationMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.AxisMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.TraceMemento;
import org.eclipse.nebula.visualization.internal.xygraph.undo.XYGraphMemento;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;

public class XYGraphMementoUtil {
    public static XYGraphMemento createEmptyMemento(IXYGraph xyGraph) {
        XYGraphMemento XYGraphMem = new XYGraphMemento();
        int i = 0;
        while (i < xyGraph.getPlotArea().getAnnotationList().size()) {
            XYGraphMem.addAnnotationMemento(new AnnotationMemento());
            ++i;
        }
        i = 0;
        while (i < xyGraph.getAxisList().size()) {
            XYGraphMem.addAxisMemento(new AxisMemento());
            ++i;
        }
        i = 0;
        while (i < xyGraph.getPlotArea().getTraceList().size()) {
            XYGraphMem.addTraceMemento(new TraceMemento());
            ++i;
        }
        return XYGraphMem;
    }

    public static XYGraphMemento createMemento(IXYGraph xyGraph) {
        XYGraphMemento XYGraphMem = XYGraphMementoUtil.createEmptyMemento(xyGraph);
        XYGraphMementoUtil.saveXYGraphPropsToMemento(xyGraph, XYGraphMem);
        return XYGraphMem;
    }

    public static void saveXYGraphPropsToMemento(IXYGraph xyGraph, XYGraphMemento memento) {
        memento.setTitle(xyGraph.getTitle());
        memento.setTitleFont(xyGraph.getTitleFont());
        memento.setTitleColor(xyGraph.getTitleColor());
        memento.setPlotAreaBackColor(xyGraph.getPlotArea().getBackgroundColor());
        memento.setShowTitle(xyGraph.isShowTitle());
        memento.setShowLegend(xyGraph.isShowLegend());
        memento.setShowPlotAreaBorder(xyGraph.getPlotArea().isShowBorder());
        memento.setTransparent(xyGraph.isTransparent());
        int i = 0;
        for (Annotation sourceAnno : xyGraph.getPlotArea().getAnnotationList()) {
            XYGraphMementoUtil.saveAnnotationPropsToMemento(sourceAnno, memento.getAnnotationMementoList().get(i++));
        }
        i = 0;
        for (Axis axis : xyGraph.getAxisList()) {
            XYGraphMementoUtil.saveAxisPropsToMemento(axis, memento.getAxisMementoList().get(i++));
        }
        i = 0;
        for (Trace trace : xyGraph.getPlotArea().getTraceList()) {
            XYGraphMementoUtil.saveTracePropsToMemento(trace, memento.getTraceMementoList().get(i++));
        }
    }

    public static void restoreXYGraphPropsFromMemento(IXYGraph xyGraph, XYGraphMemento memento) {
        if (memento.getTitle() != null) {
            xyGraph.setTitle(memento.getTitle());
        }
        xyGraph.setTitleFont(memento.getTitleFont());
        xyGraph.setTitleColor(memento.getTitleColor());
        if (memento.getPlotAreaBackColor() != null) {
            xyGraph.getPlotArea().setBackgroundColor(memento.getPlotAreaBackColor());
        }
        xyGraph.setShowTitle(memento.isShowTitle());
        xyGraph.setShowLegend(memento.isShowLegend());
        xyGraph.getPlotArea().setShowBorder(memento.isShowPlotAreaBorder());
        xyGraph.setTransparent(memento.isTransparent());
        int i = 0;
        for (AnnotationMemento annotationMemento : memento.getAnnotationMementoList()) {
            XYGraphMementoUtil.restoreAnnotationPropsFromMemento(xyGraph.getPlotArea().getAnnotationList().get(i++), annotationMemento);
        }
        i = 0;
        for (AxisMemento axisMemento : memento.getAxisMementoList()) {
            XYGraphMementoUtil.restoreAxisPropsFromMemento(xyGraph.getAxisList().get(i++), axisMemento);
        }
        i = 0;
        for (TraceMemento traceMemento : memento.getTraceMementoList()) {
            XYGraphMementoUtil.restoreTracePropsFromMemento(xyGraph.getPlotArea().getTraceList().get(i++), traceMemento);
        }
    }

    private static void saveAnnotationPropsToMemento(Annotation annotation, AnnotationMemento memento) {
        memento.setName(annotation.getName());
        if (annotation.isFree()) {
            memento.setFree(true);
            memento.setXAxis(annotation.getXAxis());
            memento.setYAxis(annotation.getYAxis());
        } else {
            memento.setFree(false);
            memento.setTrace(annotation.getTrace());
        }
        memento.setAnnotationColor(annotation.getAnnotationColor());
        memento.setFont(annotation.getFont());
        memento.setCursorLineStyle(annotation.getCursorLineStyle());
        memento.setShowName(annotation.isShowName());
        memento.setShowSampleInfo(annotation.isShowSampleInfo());
        memento.setShowPosition(annotation.isShowPosition());
    }

    private static void restoreAnnotationPropsFromMemento(Annotation annotation, AnnotationMemento memento) {
        annotation.setName(memento.getName());
        if (memento.isFree()) {
            annotation.setFree(memento.getXAxis(), memento.getYAxis());
        } else {
            annotation.setTrace(memento.getTrace());
        }
        annotation.setAnnotationColor(memento.getAnnotationColor());
        annotation.setFont(memento.getFont());
        annotation.setCursorLineStyle(memento.getCursorLineStyle());
        annotation.setShowName(memento.isShowName());
        annotation.setShowSampleInfo(memento.isShowSampleInfo());
        annotation.setShowPosition(memento.isShowPosition());
    }

    private static void saveAxisPropsToMemento(Axis axis, AxisMemento memento) {
        memento.setTitle(axis.getTitle());
        memento.setTitleFont(axis.getTitleFont());
        memento.setForegroundColor(axis.getForegroundColor());
        memento.setPrimarySide(axis.isOnPrimarySide());
        memento.setLogScale(axis.isLogScaleEnabled());
        memento.setAutoScale(axis.isAutoScale());
        memento.setAutoScaleThreshold(axis.getAutoScaleThreshold());
        memento.setRange(axis.getRange());
        memento.setDateEnabled(axis.isDateEnabled());
        memento.setAutoFormat(axis.isAutoFormat());
        memento.setFormatPattern(axis.getFormatPattern());
        memento.setShowMajorGrid(axis.isShowMajorGrid());
        memento.setDashGridLine(axis.isDashGridLine());
        memento.setMajorGridColor(axis.getMajorGridColor());
    }

    private static void restoreAxisPropsFromMemento(Axis axis, AxisMemento memento) {
        axis.setTitle(memento.getTitle());
        axis.setTitleFont(memento.getTitleFont());
        if (memento.getForegroundColor() != null) {
            axis.setForegroundColor(memento.getForegroundColor());
        }
        axis.setPrimarySide(memento.isOnPrimarySide());
        axis.setLogScale(memento.isLogScaleEnabled());
        axis.setAutoScale(memento.isAutoScale());
        axis.setAutoScaleThreshold(memento.getAutoScaleThreshold());
        axis.setRange(memento.getRange());
        axis.setDateEnabled(memento.isDateEnabled());
        axis.setAutoFormat(memento.isAutoFormat());
        axis.setFormatPattern(memento.getFormatPattern());
        axis.setShowMajorGrid(memento.isShowMajorGrid());
        axis.setDashGridLine(memento.isDashGridLine());
        axis.setMajorGridColor(memento.getMajorGridColor());
    }

    private static void saveTracePropsToMemento(Trace trace, TraceMemento memento) {
        memento.setName(trace.getName());
        memento.setXAxis(trace.getXAxis());
        memento.setYAxis(trace.getYAxis());
        memento.setTraceColor(trace.getTraceColor());
        memento.setTraceType(trace.getTraceType());
        memento.setLineWidth(trace.getLineWidth());
        memento.setPointStyle(trace.getPointStyle());
        memento.setPointSize(trace.getPointSize());
        memento.setBaseLine(trace.getBaseLine());
        memento.setAreaAlpha(trace.getAreaAlpha());
        memento.setAntiAliasing(trace.isAntiAliasing());
        memento.setErrorBarEnabled(trace.isErrorBarEnabled());
        memento.setXErrorBarType(trace.getXErrorBarType());
        memento.setYErrorBarType(trace.getYErrorBarType());
        memento.setErrorBarColor(trace.getErrorBarColor());
        memento.setErrorBarCapWidth(trace.getErrorBarCapWidth());
        memento.setDrawYErrorInArea(trace.isDrawYErrorInArea());
    }

    private static void restoreTracePropsFromMemento(Trace trace, TraceMemento memento) {
        trace.setName(memento.getName());
        trace.setXAxis(memento.getXAxis());
        trace.setYAxis(memento.getYAxis());
        trace.setTraceColor(memento.getTraceColor());
        trace.setTraceType(memento.getTraceType());
        trace.setLineWidth(memento.getLineWidth());
        trace.setPointStyle(memento.getPointStyle());
        trace.setPointSize(memento.getPointSize());
        trace.setBaseLine(memento.getBaseLine());
        trace.setAreaAlpha(memento.getAreaAlpha());
        trace.setAntiAliasing(memento.isAntiAliasing());
        trace.setErrorBarEnabled(memento.isErrorBarEnabled());
        trace.setXErrorBarType(memento.getXErrorBarType());
        trace.setYErrorBarType(memento.getYErrorBarType());
        trace.setErrorBarColor(memento.getErrorBarColor());
        trace.setErrorBarCapWidth(memento.getErrorBarCapWidth());
        trace.setDrawYErrorInArea(memento.isDrawYErrorInArea());
    }
}

