/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.version.VersionRevision;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.IDependenciesConfiguration;
import com.nxp.swtools.provider.configuration.storage.INamedTool;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.StorageProjectConfig;
import com.nxp.swtools.provider.configuration.storage.sdkproject.StorageToolchainProjectTool;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Version;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="SWComponent", features={"exists", "enabled", "version", "revision", "versionRevision"})})
public class ToolchainProjectQuery
implements IDependencyQuery {
    private static final String MISSING_SDK_COMPONENTS_XML_MESSAGE = "sdk_components.xml not found for the processor: {0}";
    private static final String VERSION_OF_UNSUPPORTED_SDK_COMPONENT_MESSAGE = "Tool asks version of unsupported SDK component (such component not found in sdk_components.xml)";
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ToolchainProjectQuery.class);

    private static @Nullable SdkComponentsTable getSdkComponentsTable(@NonNull ISharedConfiguration configuration) {
        ICommonConfig commonConfig;
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo prcsorInfo = derivatives.getProcessorMasterToolInfo((commonConfig = configuration.getCommonConfig()).getMcu(), commonConfig.getSdkVersion());
        return prcsorInfo == null ? null : derivatives.getSdkComponentsTable(prcsorInfo);
    }

    public @NonNull Collection<@NonNull IDependencyQueryResult> query(@NonNull ISharedConfiguration configuration, @NonNull String resourceType, @NonNull String resourceId, @NonNull String featureName) {
        Object resultValue;
        SdkComponentsTable supportedSdkComps;
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        if (!resourceType.equals("SWComponent")) {
            LOGGER.severe("Unsupported resource-type: " + resourceType);
            return result;
        }
        IToolchainProjectWithSdk toolchainProject = configuration.getToolchainProject();
        ISdkComponentInProject resComp = toolchainProject != null ? toolchainProject.getSdkComponent(resourceId) : null;
        String msgForesultNullValueErrorMsg = null;
        if (featureName.equals("exists")) {
            resultValue = resComp != null ? Boolean.TRUE : ((supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration)) == null ? Boolean.FALSE : Boolean.valueOf(supportedSdkComps.findById(resourceId).findAny().isPresent()));
        } else if (featureName.equals("version")) {
            if (resComp != null) {
                resultValue = resComp.getVersion();
            } else {
                resultValue = null;
                supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration);
                if (supportedSdkComps == null) {
                    msgForesultNullValueErrorMsg = MessageFormat.format(MISSING_SDK_COMPONENTS_XML_MESSAGE, configuration.getCommonConfig().getMcu());
                } else if (!supportedSdkComps.findById(resourceId).findAny().isPresent()) {
                    msgForesultNullValueErrorMsg = VERSION_OF_UNSUPPORTED_SDK_COMPONENT_MESSAGE;
                }
            }
        } else if (featureName.equals("versionRevision")) {
            Version version = null;
            String revision = null;
            if (resComp != null) {
                version = resComp.getVersion();
                revision = resComp.getRevision();
                resultValue = version == null ? null : new VersionRevision(version, revision);
            } else {
                resultValue = null;
                SdkComponentsTable supportedSdkComps2 = ToolchainProjectQuery.getSdkComponentsTable(configuration);
                if (supportedSdkComps2 == null) {
                    msgForesultNullValueErrorMsg = MessageFormat.format(MISSING_SDK_COMPONENTS_XML_MESSAGE, configuration.getCommonConfig().getMcu());
                } else if (!supportedSdkComps2.findById(resourceId).findAny().isPresent()) {
                    msgForesultNullValueErrorMsg = VERSION_OF_UNSUPPORTED_SDK_COMPONENT_MESSAGE;
                }
            }
        } else if (featureName.equals("revision")) {
            if (resComp != null) {
                resultValue = resComp.getRevision();
            } else {
                resultValue = null;
                supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration);
                if (supportedSdkComps == null) {
                    msgForesultNullValueErrorMsg = MessageFormat.format(MISSING_SDK_COMPONENTS_XML_MESSAGE, configuration.getCommonConfig().getMcu());
                } else if (!supportedSdkComps.findById(resourceId).findAny().isPresent()) {
                    msgForesultNullValueErrorMsg = VERSION_OF_UNSUPPORTED_SDK_COMPONENT_MESSAGE;
                }
            }
        } else if (featureName.equals("enabled")) {
            if (Rap.isActive()) {
                resultValue = null;
            } else if (resComp != null) {
                resultValue = Boolean.TRUE;
            } else {
                if (toolchainProject == null) {
                    LOGGER.warning("Null toolchain project for the configuration");
                    return result;
                }
                if (!toolchainProject.wasProjectDetected()) {
                    resultValue = null;
                } else {
                    resultValue = Boolean.FALSE;
                    supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration);
                    if (supportedSdkComps == null) {
                        LOGGER.log(Level.SEVERE, MISSING_SDK_COMPONENTS_XML_MESSAGE, configuration.getCommonConfig().getMcu());
                    } else if (!supportedSdkComps.findById(resourceId).findAny().isPresent()) {
                        LOGGER.log(Level.SEVERE, "Tool requires unsupported SDK component: {0} (such component not found in sdk_components.xml)", resourceId);
                    }
                }
            }
        } else {
            return result;
        }
        ProcessorCore selCore = configuration.getCommonConfig().getSelectedCore();
        StorageProjectConfig cfg = new StorageProjectConfig(selCore != null ? selCore.getID() : "");
        result.add((IDependencyQueryResult)new DependencyQueryResult(resultValue, (INamedTool)StorageToolchainProjectTool.STORAGE_TOOLCHAIN_PROJECT_TOOL, (IDependenciesConfiguration)cfg, msgForesultNullValueErrorMsg));
        return result;
    }
}

