/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.connections.actions.SerialGdbPyRunAction;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessDestroyer;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessOutputHandler;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessWaitHandler;
import com.nxp.swtools.mem.validation.utils.LoggingUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PythonProcessUtilities {
    protected static final Logger LOGGER = LogManager.getLogger(PythonProcessUtilities.class);
    protected static String osEnv = OSDetect.isWindows() ? "cmd.exe" : "bash";
    @Nullable
    protected static Process process;
    @Nullable
    protected static ProcessOutputHandler outHandler;
    @Nullable
    protected static ProcessWaitHandler waitHandler;
    @Nullable
    protected static Thread outHandlerThread;
    @Nullable
    protected static Thread waitHandlerThread;
    @Nullable
    protected static Path logFilePath;
    private static final long TIMEOUT = 5000L;
    private static final String FAILED = "FAILED\n";
    public static final String EXEC = "exec ";
    public static final String PYTHON = "python ";

    private PythonProcessUtilities() {
        throw new IllegalStateException("Utility class");
    }

    public static @Nullable Process getProcess() {
        return process;
    }

    public static @Nullable ProcessWaitHandler getWaitHandler() {
        return waitHandler;
    }

    public static @Nullable ProcessOutputHandler getOutHandler() {
        return outHandler;
    }

    public static StringBuilder getExecForProcess() {
        StringBuilder execName = new StringBuilder();
        String pythonPath = SerialGdbPyRunAction.getPythonBinPath(null);
        if (pythonPath.equals("")) {
            execName.append(PYTHON);
        } else {
            execName.append(pythonPath).append(" ");
        }
        return execName;
    }

    public static void startProcess() throws IOException {
        Map<String, String> pythonEnv = SerialGdbPyRunAction.getPythonEnv(null);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(true);
        pb.command(osEnv);
        Map<String, String> procEnv = pb.environment();
        for (Map.Entry<String, String> envParam : pythonEnv.entrySet()) {
            procEnv.put(envParam.getKey(), envParam.getValue());
        }
        process = pb.start();
    }

    public static void createLogFile(String logPathString) {
        logFilePath = Paths.get(logPathString, new String[0]);
        try {
            File logFile = logFilePath.toFile();
            if (logFile.exists()) {
                Files.delete(logFilePath);
            }
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, () -> "[TOOL] " + e);
        }
    }

    public static void addProcessHandlers() {
        outHandler = new ProcessOutputHandler(process);
        outHandlerThread = new Thread(outHandler);
        outHandlerThread.start();
        waitHandler = new ProcessWaitHandler(Objects.requireNonNull(outHandlerThread), 5000L);
        waitHandlerThread = new Thread(waitHandler);
        waitHandlerThread.start();
    }

    public static void cleanHandlers() {
        block7: {
            try {
                if (waitHandler != null) {
                    waitHandler.cancel();
                }
                if (waitHandlerThread != null) {
                    waitHandlerThread.join();
                }
                if (outHandler != null) {
                    outHandler.cancel();
                }
                if (outHandlerThread != null) {
                    outHandlerThread.join();
                }
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.WARNING, () -> "[TOOL] " + ie.getLocalizedMessage());
                if (waitHandlerThread != null) {
                    waitHandlerThread.interrupt();
                }
                if (outHandlerThread == null) break block7;
                outHandlerThread.interrupt();
            }
        }
    }

    public static void cleanUpVariables() {
        process = null;
        outHandler = null;
        waitHandler = null;
        outHandlerThread = null;
        waitHandlerThread = null;
        logFilePath = null;
    }

    public static void terminate() {
        PythonProcessUtilities.cleanHandlers();
        PythonProcessUtilities.terminateProcess();
        PythonProcessUtilities.cleanUpVariables();
    }

    public static void logError(String error) {
        PythonProcessUtilities.logMessage(error);
        PythonProcessUtilities.logMessage(FAILED);
        LOGGER.log(Level.SEVERE, () -> "[TOOL] " + error);
    }

    public static void logMessage(String message) {
        if (logFilePath != null) {
            try {
                Files.writeString(logFilePath, (CharSequence)(String.valueOf(message) + "\n"), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, () -> "[TOOL] " + e);
            }
        }
    }

    public static void terminateProcess() {
        if (process != null) {
            ProcessDestroyer.destroy(osEnv, process, new String[]{String.valueOf(process.pid())});
        }
    }

    public static void executePhyInitProcess() {
        try {
            PythonProcessUtilities.startProcess();
            Process processLoc = PythonProcessUtilities.getProcess();
            PythonProcessUtilities.addProcessHandlers();
            ProcessOutputHandler outHandlerLoc = PythonProcessUtilities.getOutHandler();
            ProcessWaitHandler waitHandlerLoc = PythonProcessUtilities.getWaitHandler();
            StringBuilder execName = PythonProcessUtilities.getExecForProcess();
            String mainScriptPath = String.valueOf(Activator.getDefault().getConfigManager().getScriptsFolder()) + File.separator + "s.py" + " ";
            execName.append(mainScriptPath);
            execName.append(" \"" + Activator.getDefault().getConfigManager().getLogsFolder() + File.separator + "phy.json" + "\"");
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Objects.requireNonNull(processLoc).getOutputStream(), StandardCharsets.UTF_8));){
                PythonProcessUtilities.sendCommands(writer, execName.toString());
                if (outHandlerLoc != null && waitHandlerLoc != null) {
                    PythonProcessUtilities.dealWithProcessExecution(outHandlerLoc, waitHandlerLoc);
                }
                PythonProcessUtilities.sendCommands(writer, "exit");
                PythonProcessUtilities.logMessage("****DONE****");
                PythonProcessUtilities.terminate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException error) {
            String errorMessage = error.getMessage();
            LOGGER.log(Level.SEVERE, () -> "[TOOL] " + errorMessage);
            PythonProcessUtilities.logError(errorMessage != null ? errorMessage : "");
            PythonProcessUtilities.terminate();
        }
    }

    protected static void dealWithProcessExecution(ProcessOutputHandler outHandlerProc, ProcessWaitHandler waitHandlerProc) {
        StringBuilder processOutput = new StringBuilder();
        boolean isPyException = false;
        boolean isPhyInitError = false;
        boolean isPhyInitLibWarning = false;
        while (waitHandlerProc.getState() == RunAction.ExecStatus.RUNNING) {
            String out = outHandlerProc.getOutput();
            processOutput.append(out);
            String procOut = processOutput.toString();
            isPyException = LoggingUtils.isPyException(procOut);
            isPhyInitError = LoggingUtils.isPhyinitError(out);
            isPhyInitLibWarning = LoggingUtils.isPhyinitWarning(out);
            if (isPyException) {
                waitHandlerProc.cancel();
                PythonProcessUtilities.logError(procOut);
                continue;
            }
            if (isPhyInitError) {
                waitHandlerProc.cancel();
                PythonProcessUtilities.logError(out);
                continue;
            }
            if (isPhyInitLibWarning) {
                PythonProcessUtilities.logMessage(out);
                continue;
            }
            if (!out.contains("****DONE****")) continue;
            waitHandlerProc.cancel();
        }
    }

    protected static boolean checkProcAlive() {
        ProcessWaitHandler waitHandlerProc = waitHandler;
        if (waitHandlerProc == null) {
            return false;
        }
        boolean retVal = true;
        if (waitHandlerProc.getState() == RunAction.ExecStatus.TIMED_OUT) {
            PythonProcessUtilities.logError(Messages.TimeoutMessage);
        } else if (waitHandlerProc.getState() == RunAction.ExecStatus.INTERNAL_ERROR) {
            PythonProcessUtilities.logError(Messages.InternalErrorMessage);
            retVal = false;
        } else if (waitHandlerProc.getState() == RunAction.ExecStatus.TERMINATED) {
            PythonProcessUtilities.logError(Messages.TerminatedMessage);
            retVal = false;
        }
        return retVal;
    }

    public static boolean sendCommands(@Nullable BufferedWriter outLoc, String ... commands) throws IOException {
        if (PythonProcessUtilities.checkProcAlive()) {
            if (outLoc != null) {
                String[] stringArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    String command = stringArray[n2];
                    outLoc.write(command);
                    outLoc.newLine();
                    ++n2;
                }
                outLoc.flush();
            }
            return true;
        }
        return false;
    }
}

