/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.IDiagsProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.VTableFigure;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.DiagsView;
import com.nxp.swtools.mem.validation.ui.IChartView;
import com.nxp.swtools.mem.validation.ui.ImageEyeView;
import com.nxp.swtools.mem.validation.ui.SerDesJitterDataEyeView;
import com.nxp.swtools.mem.validation.ui.UIResourceManager;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.util.Objects;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class VScenarioView
extends Composite
implements DisposeListener {
    public static final int LEGEND_IMAGE_SIZE = 10;
    private static final int DIAGS_TAB_POS = 1;
    public static final String LANE_STRING = "Lane";
    @Nullable
    private SashForm resultsSashForm;
    @Nullable
    private ScrolledComposite canvasPanel;
    @Nullable
    private Canvas canvas;
    @Nullable
    private ScrolledComposite tableOptionsPanel;
    @Nullable
    private CTabFolder scenTabFolder;
    @Nullable
    private CTabItem resultsTab = null;
    @Nullable
    private CTabItem diagsTab = null;
    @Nullable
    private CTabItem testOptionsTab = null;
    @Nullable
    private ToolBar toolBar;
    @Nullable
    private ToolItem selectAllCellsToolItem;
    @Nullable
    private ToolItem selectCellsToolItem;
    @Nullable
    private ToolItem invertSelectionToolItem;
    @Nullable
    private ToolItem revertToDefaultToolItem;
    @Nullable
    private ToolItem autoReportToolItem;
    @Nullable
    private ToolItem reportToolItem;
    @Nullable
    private ToolItem cellErrorColoringToolItem;
    @Nullable
    private CellResultsMainView cellResultsView;
    @Nullable
    private VScenarioOptionsView tableOptionsView;
    @Nullable
    private Composite legendComposite;
    @Nullable
    private Label legendTestFailedCellLabel;
    @Nullable
    private Label legendConfigurationErrorCellLabel;
    @Nullable
    private Label legendTargetErrorCellLabel;
    @Nullable
    private Image legendQueuedCellImage;
    @Nullable
    private Image legendNotQueuedCellImage;
    @Nullable
    private Image legendTestFailedCellImage;
    @Nullable
    private Image legendConfigurationErrorCellImage;
    @Nullable
    private Image legendTargetErrorCellImage;
    @Nullable
    private Image legendUserSelectedCellImage;
    @Nullable
    private Image legendStableCellImage;
    @Nullable
    private Image legendOptimalCellImage;
    @Nullable
    private ToolItem toolItem3;
    @Nullable
    private ToolItem toolItem2;
    @Nullable
    private ToolItem toolItem;
    @Nullable
    private Canvas graphCanvas;
    @Nullable
    private VStagePresentation selectedStage;
    @Nullable
    private IChartView diagChart;
    @Nullable
    private PaintListener paintListener;
    @Nullable
    private IDiagsProvider diagsProvider = ValidationContext.getInstance().getDiagsProvider();

    private static Image createLegendImage(Color bgColor, boolean discarded) {
        Image image = new Image((Device)PlatformUI.getWorkbench().getDisplay(), 10, 10);
        GC gc = new GC((Drawable)image);
        VTableFigure.CellBox box = new VTableFigure.CellBox();
        box.setPos(new Point(0, 0));
        box.setSize(new Point(9, 9));
        box.setExtraContent(true);
        Color fgColor = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_FG");
        box.setFgColor(fgColor);
        box.setBgColor(bgColor);
        if (discarded) {
            box.setDiscarded(discarded);
            box.precomputeDiscardedLineSegments(5.0f);
        }
        box.draw(gc);
        gc.dispose();
        return image;
    }

    public VScenarioView(Composite parentView) {
        super(parentView, 0);
        this.createUI();
        this.addDisposeListener(this);
    }

    protected void checkSubclass() {
    }

    private void createActionsToolbar() {
        CTabFolder scenTabFolderLoc;
        VScenarioPresentation scenData;
        this.toolBar = new ToolBar((Composite)this.scenTabFolder, 8520000);
        ToolItem reportToolItemLoc = this.reportToolItem = new ToolItem(this.toolBar, 8);
        reportToolItemLoc.setImage(Activator.getDefault().getImage("report.png"));
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            reportToolItemLoc.setToolTipText(configController.getReportLabel());
        } else {
            reportToolItemLoc.setToolTipText(Messages.REPORT_TOOLTIP);
        }
        reportToolItemLoc.setEnabled(false);
        this.setToolItem(new ToolItem(this.toolBar, 2));
        if (this.selectedStage != null && (scenData = this.selectedStage.getSelectedScenario()) != null && scenData.getModel().isShmooedTest()) {
            ToolItem selectAllCellsToolItemLoc = this.selectAllCellsToolItem = new ToolItem(this.toolBar, 8);
            selectAllCellsToolItemLoc.setImage(Activator.getDefault().getImage("24p_select_all.png"));
            selectAllCellsToolItemLoc.setToolTipText(Messages.SELECT_ALL_CELLS_TOOLTIP);
            ToolItem selectCellsToolItemLoc = this.selectCellsToolItem = new ToolItem(this.toolBar, 8);
            selectCellsToolItemLoc.setImage(Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/incomplete_tsk.png"));
            ToolItem invertSelectionToolItemLoc = this.invertSelectionToolItem = new ToolItem(this.toolBar, 8);
            invertSelectionToolItemLoc.setImage(Activator.getDefault().getImage("24p_select_invert.png"));
            invertSelectionToolItemLoc.setToolTipText(Messages.INVERT_SELECTION_TOOLTIP);
            this.setToolItem3(new ToolItem(this.toolBar, 2));
            ToolItem cellErrorColoringToolItemLoc = this.cellErrorColoringToolItem = new ToolItem(this.toolBar, 32);
            cellErrorColoringToolItemLoc.setImage(Activator.getDefault().getImage("24p_error_coloring.png"));
            cellErrorColoringToolItemLoc.setToolTipText(Messages.CELL_ERROR_COLORING_TOOLTIP);
        }
        if ((scenTabFolderLoc = this.scenTabFolder) != null) {
            scenTabFolderLoc.setTopRight((Control)this.toolBar);
            if (this.toolBar != null) {
                scenTabFolderLoc.setTabHeight(Math.max(this.toolBar.computeSize((int)-1, (int)-1).y, scenTabFolderLoc.getTabHeight()));
            }
        }
    }

    private void createLegendsToolbar(Composite parent) {
        this.legendComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(9, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        if (this.legendComposite != null) {
            this.legendComposite.setLayout((Layout)layout);
        }
        Label label = new Label(this.legendComposite, 0);
        GridData gd = new GridData(16384, 0x1000000, false, false, 1, 1);
        label.setLayoutData((Object)gd);
        label.setText(Messages.LEGEND_LABEL);
        label.setToolTipText(Messages.LEGEND_TOOLTIP);
        this.legendTestFailedCellLabel = new Label(this.legendComposite, 0);
        gd = new GridData(16384, 0x1000000, false, false, 1, 1);
        Label legendTestFailedCellLabelLoc = this.legendTestFailedCellLabel;
        if (legendTestFailedCellLabelLoc != null) {
            legendTestFailedCellLabelLoc.setLayoutData((Object)gd);
            this.legendTestFailedCellImage = VScenarioView.createLegendImage(Objects.requireNonNull(Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_TEST_FAILED)), false);
            legendTestFailedCellLabelLoc.setImage(this.legendTestFailedCellImage);
            legendTestFailedCellLabelLoc.setToolTipText(Messages.LEGEND_TEST_FAILED_CELL_TOOLTIP);
        }
        this.legendConfigurationErrorCellLabel = new Label(this.legendComposite, 0);
        gd = new GridData(16384, 0x1000000, false, false, 1, 1);
        Label legendConfigurationErrorCellLabelLoc = this.legendConfigurationErrorCellLabel;
        if (legendConfigurationErrorCellLabelLoc != null) {
            legendConfigurationErrorCellLabelLoc.setLayoutData((Object)gd);
            this.legendConfigurationErrorCellImage = VScenarioView.createLegendImage(Objects.requireNonNull(Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_CONFIGURATION_ERROR)), false);
            legendConfigurationErrorCellLabelLoc.setImage(this.legendConfigurationErrorCellImage);
            legendConfigurationErrorCellLabelLoc.setToolTipText(Messages.LEGEND_CONFIGURATION_ERROR_CELL_TOOLTIP);
        }
        this.legendTargetErrorCellLabel = new Label(this.legendComposite, 0);
        gd = new GridData(16384, 0x1000000, false, false, 1, 1);
        Label legendTargetErrorCellLabelLoc = this.legendTargetErrorCellLabel;
        if (legendTargetErrorCellLabelLoc != null) {
            legendTargetErrorCellLabelLoc.setLayoutData((Object)gd);
            this.legendTargetErrorCellImage = VScenarioView.createLegendImage(Objects.requireNonNull(Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_TARGET_ERROR)), false);
            legendTargetErrorCellLabelLoc.setImage(this.legendTargetErrorCellImage);
            legendTargetErrorCellLabelLoc.setToolTipText(Messages.LEGEND_TARGET_ERROR_CELL_TOOLTIP);
        }
        Label legendStableCellLabel = new Label(this.legendComposite, 0);
        gd = new GridData(16384, 0x1000000, false, false, 1, 1);
        legendStableCellLabel.setLayoutData((Object)gd);
        this.legendStableCellImage = VScenarioView.createLegendImage(Objects.requireNonNull(Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_STABLE)), false);
        legendStableCellLabel.setImage(this.legendStableCellImage);
        legendStableCellLabel.setToolTipText(Messages.LEGEND_STABLE_CELL_TOOLTIP);
    }

    private void createOptionsTab() {
        if (this.testOptionsTab == null || this.testOptionsTab != null && this.testOptionsTab.isDisposed()) {
            CTabItem testOptionsTabLoc = this.testOptionsTab = new CTabItem(Objects.requireNonNull(this.scenTabFolder), 0);
            testOptionsTabLoc.setText(Messages.TEST_OPTIONS_TAB_NAME);
            testOptionsTabLoc.setControl((Control)this.tableOptionsPanel);
        }
    }

    private void createResultsTab() {
        if (this.resultsTab == null || this.resultsTab != null && this.resultsTab.isDisposed()) {
            CTabItem resultsTabLoc = this.resultsTab = new CTabItem(Objects.requireNonNull(this.scenTabFolder), 0);
            resultsTabLoc.setText(Messages.RESULTS_TAB_NAME);
            resultsTabLoc.setControl((Control)this.resultsSashForm);
            resultsTabLoc.setData("qcs.ddrv.vscenario.results.canvas", (Object)this.canvas);
        }
    }

    private void createDiagsTab() {
        if (this.diagsTab == null || this.diagsTab != null && this.diagsTab.isDisposed()) {
            CTabItem diagsTabLoc = this.diagsTab = new CTabItem(Objects.requireNonNull(this.scenTabFolder), 0, 1);
            diagsTabLoc.setText(Messages.VScenarioView_diagsTabName);
            diagsTabLoc.setData("qcs.ddrv.vscenario.results.canvas", (Object)this.graphCanvas);
        }
        if (this.diagsProvider != null) {
            this.diagsProvider.createOverlappedChartsTab(this.scenTabFolder);
        }
    }

    private void createTabs() {
        this.createResultsTab();
        this.createOptionsTab();
    }

    private void createUI() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true, 1, 4));
        CTabFolder scenTabFolderLoc = this.scenTabFolder = new CTabFolder((Composite)this, 2048);
        scenTabFolderLoc.setSimple(false);
        scenTabFolderLoc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        SashForm resultsSashFormLoc = this.resultsSashForm = new SashForm((Composite)this.scenTabFolder, 0);
        resultsSashFormLoc.setOrientation(512);
        resultsSashFormLoc.setSashWidth(4);
        resultsSashFormLoc.setLayout((Layout)new GridLayout(1, false));
        if (this.resultsSashForm != null) {
            Composite upperSashPanel = new Composite((Composite)this.resultsSashForm, 0);
            upperSashPanel.setLayout((Layout)new GridLayout(1, true));
            this.canvasPanel = new ScrolledComposite(upperSashPanel, 2816);
            GridData gdScrolledComposite = new GridData(4, 4, true, true, 1, 1);
            gdScrolledComposite.minimumHeight = 30;
            gdScrolledComposite.heightHint = 250;
            ScrolledComposite canvasPanelLoc = this.canvasPanel;
            if (canvasPanelLoc != null) {
                canvasPanelLoc.setLayoutData((Object)gdScrolledComposite);
                canvasPanelLoc.setExpandHorizontal(true);
                canvasPanelLoc.setExpandVertical(true);
                Canvas canvasLoc = this.canvas = new Canvas((Composite)this.canvasPanel, 0x20000000);
                canvasLoc.setData((Object)Messages.RESULTS_TAB_NAME);
                Menu contextMenu = new Menu((Control)this.canvas);
                MenuItem item = new MenuItem(contextMenu, 64);
                item.setText(Messages.ApplyCurrentConfig);
                canvasLoc.setMenu(contextMenu);
                canvasPanelLoc.setContent((Control)canvasLoc);
                canvasPanelLoc.setMinSize(canvasLoc.computeSize(-1, -1));
                canvasPanelLoc.getVerticalBar().setIncrement(canvasPanelLoc.getVerticalBar().getIncrement() * 6);
            }
            this.cellResultsView = new CellResultsMainView((Composite)resultsSashFormLoc);
            ScrolledComposite tableOptionsPanelLoc = this.tableOptionsPanel = new ScrolledComposite((Composite)this.scenTabFolder, 2816);
            tableOptionsPanelLoc.setExpandHorizontal(true);
            tableOptionsPanelLoc.setExpandVertical(true);
            VScenarioOptionsView tableOptionsViewLoc = this.tableOptionsView = new VScenarioOptionsView(tableOptionsPanelLoc);
            tableOptionsPanelLoc.setContent((Control)tableOptionsViewLoc);
            tableOptionsPanelLoc.setMinSize(tableOptionsViewLoc.computeSize(-1, -1));
            this.createTabs();
            this.createActionsToolbar();
            this.createLegendsToolbar(upperSashPanel);
        }
    }

    private void destroyOptionsTab() {
        if (this.testOptionsTab != null) {
            this.testOptionsTab.dispose();
            this.testOptionsTab = null;
        }
    }

    public @Nullable Canvas getCanvas() {
        if (this.selectedStage != null) {
            VScenarioPresentation scenData = this.selectedStage.getSelectedScenario();
            CTabFolder scenTabFolderLoc = this.scenTabFolder;
            if (scenTabFolderLoc != null && scenData != null) {
                int selectionIndex = scenTabFolderLoc.getSelectionIndex();
                if (selectionIndex == 1 && (scenData.getModel().isDiagsEye() || scenData.getModel().isCAEye() || scenData.getModel().getName().contains(LANE_STRING))) {
                    return this.graphCanvas;
                }
                if (selectionIndex == 2 && scenData.getModel().isDiagsEye() && this.diagsProvider != null) {
                    return this.diagsProvider.getOverlapGraphCanvas();
                }
            }
        }
        return this.canvas;
    }

    public @Nullable ScrolledComposite getCanvasPanel() {
        return this.canvasPanel;
    }

    public @Nullable CellResultsMainView getCellResultsMainView() {
        return this.cellResultsView;
    }

    public @Nullable CTabItem getResultsTab() {
        if (this.resultsTab != null && !this.resultsTab.isDisposed()) {
            return this.resultsTab;
        }
        return null;
    }

    public @Nullable VScenarioOptionsView getScenarioOptionsView() {
        return this.tableOptionsView;
    }

    public @Nullable ToolItem getToolItem() {
        return this.toolItem;
    }

    public @Nullable ToolItem getToolItem2() {
        return this.toolItem2;
    }

    public @Nullable ToolItem getToolItem3() {
        return this.toolItem3;
    }

    public @Nullable IDiagsProvider getDiagsProvider() {
        return this.diagsProvider;
    }

    public void resetOverlayGeneratedFlag() {
        VScenarioPresentation selScenPres;
        if (this.diagsProvider != null && this.selectedStage != null && (selScenPres = this.selectedStage.getSelectedScenario()) != null && this.diagsProvider != null) {
            this.diagsProvider.resetOverlayGeneratedFlag(selScenPres.getModel().getId());
        }
    }

    public void redrawScenarioFigure() {
        if (this.canvas != null) {
            this.canvas.redraw();
        }
    }

    public void setAutoReportSelectionListener(SelectionListener listener) {
        if (this.autoReportToolItem != null) {
            this.autoReportToolItem.addSelectionListener(listener);
        }
    }

    public void setInput(VStagePresentation selectedStage, boolean selectResultsView) {
        if (this.isDisposed()) {
            return;
        }
        CTabFolder scenTabFolderLoc = this.scenTabFolder;
        if (scenTabFolderLoc != null) {
            if (!selectedStage.isVisible()) {
                scenTabFolderLoc.setVisible(false);
            } else {
                ValidationPresentationModel validation = selectedStage.getParent();
                VScenarioPresentation scenData = selectedStage.getSelectedScenario();
                if (scenData == null) {
                    scenTabFolderLoc.setVisible(false);
                } else {
                    Canvas canvasLoc;
                    if (scenData.getModel().testOptionsEnabled()) {
                        this.createOptionsTab();
                    } else {
                        this.destroyOptionsTab();
                    }
                    if (this.cellErrorColoringToolItem != null) {
                        this.cellErrorColoringToolItem.setSelection(validation.isCellErrorColoringEnabled());
                    }
                    if ((canvasLoc = this.canvas) != null) {
                        canvasLoc.redraw();
                    }
                    scenTabFolderLoc.setVisible(true);
                    this.updateTabs(selectedStage);
                    this.selectedStage = selectedStage;
                    this.updatesDiagsChart(scenData, scenTabFolderLoc);
                    if (selectResultsView) {
                        scenTabFolderLoc.setSelection(0);
                    } else {
                        CTabItem selection = scenTabFolderLoc.getSelection();
                        if (selection == null) {
                            scenTabFolderLoc.setSelection(0);
                        }
                    }
                }
            }
        }
    }

    private void updatesDiagsChart(VScenarioPresentation scenData, CTabFolder scenTabFolderLoc) {
        VScenario scenDataModel = scenData.getModel();
        if (scenDataModel.isDiagsEye()) {
            String useImageEyeOption;
            VModel vModel;
            boolean useImageEye = false;
            if (this.selectedStage != null && (vModel = this.selectedStage.getParent().getParent().getModel()) != null && (useImageEyeOption = vModel.getCustomOption("useImageEye")) != null) {
                useImageEye = Boolean.parseBoolean(useImageEyeOption);
            }
            IChartView iChartView = this.diagChart = useImageEye ? new ImageEyeView() : new DiagsView();
            if (this.paintListener != null) {
                this.diagChart.setScenarioPaintListener(this.paintListener);
            }
            if (this.diagChart != null) {
                this.graphCanvas = this.diagChart.createEmptyView(scenTabFolderLoc, this.diagsTab);
            }
            if (!useImageEye && this.diagsProvider != null) {
                this.diagsProvider.updateOverlappedCharts(scenTabFolderLoc, this.selectedStage);
            }
        } else if (scenDataModel.isCAEye()) {
            this.diagChart = new ImageEyeView();
            if (this.paintListener != null) {
                this.diagChart.setScenarioPaintListener(this.paintListener);
            }
            if (this.diagChart != null) {
                this.graphCanvas = this.diagChart.createEmptyView(scenTabFolderLoc, this.diagsTab);
            }
        } else if (scenDataModel.getName().contains(LANE_STRING)) {
            this.diagChart = new SerDesJitterDataEyeView();
            if (this.paintListener != null) {
                this.diagChart.setScenarioPaintListener(this.paintListener);
            }
            if (this.diagChart != null) {
                this.graphCanvas = this.diagChart.createEmptyView(scenTabFolderLoc, this.diagsTab);
            }
        } else {
            this.selectedStage = null;
            this.diagChart = null;
        }
        if (this.diagChart != null && this.diagsTab != null && this.selectedStage != null) {
            this.graphCanvas = this.diagChart.setInput(this.selectedStage, scenTabFolderLoc, this.diagsTab);
        }
    }

    public boolean isImageEyeViewVisible() {
        return this.diagChart instanceof ImageEyeView;
    }

    public boolean isOverlayDiagsVisible() {
        if (this.scenTabFolder != null) {
            return this.scenTabFolder.getSelectionIndex() == 2 && this.diagsProvider != null;
        }
        return false;
    }

    public void setInvertCellSelectionListener(SelectionListener listener) {
        if (this.invertSelectionToolItem != null) {
            this.invertSelectionToolItem.addSelectionListener(listener);
        }
    }

    public void setReportSelectionListener(SelectionListener listener) {
        if (this.reportToolItem != null) {
            this.reportToolItem.addSelectionListener(listener);
        }
    }

    public void setExportLogSelectionListener(SelectionListener listener) {
        if (this.cellResultsView != null) {
            this.cellResultsView.setExportLogSelectionListener(listener);
        }
    }

    public void setReportToolsEnabled(boolean enabled) {
        if (this.autoReportToolItem != null) {
            this.autoReportToolItem.setEnabled(enabled);
        }
        if (this.reportToolItem != null) {
            this.reportToolItem.setEnabled(enabled);
        }
    }

    public void setRestoreComponentListener(SelectionListener listener) {
        if (this.revertToDefaultToolItem != null) {
            this.revertToDefaultToolItem.addSelectionListener(listener);
        }
    }

    public void setRestorePropertiesEnabled(boolean enabled) {
        if (this.revertToDefaultToolItem != null) {
            this.revertToDefaultToolItem.setEnabled(enabled);
        }
    }

    public void setScenarioCanvasMouseListener(MouseListener listener) {
        if (this.canvas != null) {
            this.canvas.addMouseListener(listener);
        }
    }

    public void setScenarioCanvasMenuDetectListener(MenuDetectListener listener) {
        if (this.canvas != null) {
            this.canvas.addMenuDetectListener(listener);
        }
    }

    public void setScenarioCanvasApplyConfigListener(SelectionListener listener) {
        Menu menu;
        if (this.canvas != null && (menu = this.canvas.getMenu()) != null) {
            MenuItem[] menuItemArray = menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                if (Messages.ApplyCurrentConfig.equals(item.getText())) {
                    item.addSelectionListener(listener);
                }
                ++n2;
            }
        }
    }

    public void setScenarioCanvasMenuShowListener(Listener listener) {
        Menu menu;
        if (this.canvas != null && (menu = this.canvas.getMenu()) != null) {
            menu.addListener(22, listener);
        }
    }

    public void setScenarioCanvasMouseMoveListener(MouseMoveListener listener) {
        if (this.canvas != null) {
            this.canvas.addMouseMoveListener(listener);
        }
    }

    public void setScenarioPaintListener(PaintListener paintListener) {
        if (this.canvas != null) {
            this.canvas.addPaintListener(paintListener);
        }
        if (this.graphCanvas != null) {
            this.graphCanvas.addPaintListener(paintListener);
        }
        if (this.diagChart != null) {
            this.diagChart.setScenarioPaintListener(paintListener);
        }
        this.paintListener = paintListener;
    }

    public void setSelectAllCellsListener(SelectionListener listener) {
        if (this.selectAllCellsToolItem != null) {
            this.selectAllCellsToolItem.addSelectionListener(listener);
        }
    }

    public void setSelectCellRegionListener(SelectionListener listener) {
        if (this.selectCellsToolItem != null) {
            this.selectCellsToolItem.addSelectionListener(listener);
        }
    }

    public void setSelectionToolsEnabled(boolean enabled) {
        if (this.selectAllCellsToolItem != null) {
            this.selectAllCellsToolItem.setEnabled(enabled);
        }
        if (this.selectCellsToolItem != null) {
            this.selectCellsToolItem.setEnabled(enabled);
        }
        if (this.invertSelectionToolItem != null) {
            this.invertSelectionToolItem.setEnabled(enabled);
        }
    }

    public void setTabResultsFocus() {
        if (this.scenTabFolder != null) {
            this.scenTabFolder.setSelection(0);
        }
    }

    public void setToggleCellErrorColoringListener(SelectionListener listener) {
        if (this.cellErrorColoringToolItem != null) {
            this.cellErrorColoringToolItem.addSelectionListener(listener);
        }
    }

    public void setToolItem(ToolItem toolItem) {
        this.toolItem = toolItem;
    }

    public void setToolItem2(ToolItem toolItem2) {
        this.toolItem2 = toolItem2;
    }

    public void setToolItem3(ToolItem toolItem3) {
        this.toolItem3 = toolItem3;
    }

    public void updateLegend() {
        if (this.legendComposite != null) {
            this.legendComposite.layout(false);
        }
    }

    public void updateTabs(VStagePresentation stage) {
        VScenarioPresentation scenario = stage.getSelectedScenario();
        if (this.diagChart != null) {
            this.diagChart.dispose();
        }
        if (scenario != null && (scenario.getModel().getName().equals(VScenario.ScenarioType.DIAG_TX_EYE.name) || scenario.getModel().getName().equals(VScenario.ScenarioType.DIAG_RX_EYE.name) || scenario.getModel().getName().equals(VScenario.ScenarioType.CA_BUS.name) || scenario.getModel().getName().equals(VScenario.ScenarioType.CA_EYE.name) || scenario.getModel().getName().contains(LANE_STRING))) {
            this.createDiagsTab();
        } else {
            if (this.diagsTab != null) {
                this.diagsTab.dispose();
            }
            if (this.diagsProvider != null) {
                this.diagsProvider.disposeDiagsTab();
            }
        }
    }

    public void widgetDisposed(@Nullable DisposeEvent e) {
        if (this.legendQueuedCellImage != null) {
            this.legendQueuedCellImage.dispose();
        }
        if (this.legendNotQueuedCellImage != null) {
            this.legendNotQueuedCellImage.dispose();
        }
        if (this.legendTestFailedCellImage != null) {
            this.legendTestFailedCellImage.dispose();
        }
        if (this.legendConfigurationErrorCellImage != null) {
            this.legendConfigurationErrorCellImage.dispose();
        }
        if (this.legendTargetErrorCellImage != null) {
            this.legendTargetErrorCellImage.dispose();
        }
        if (this.legendUserSelectedCellImage != null) {
            this.legendUserSelectedCellImage.dispose();
        }
        if (this.legendStableCellImage != null) {
            this.legendStableCellImage.dispose();
        }
        if (this.legendOptimalCellImage != null) {
            this.legendOptimalCellImage.dispose();
        }
    }
}

