/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.listeners.TimeParamListener;
import com.nxp.swtools.mem.validation.model.scripts.VScriptTimeParamValue;
import java.util.Objects;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class TimeParamView
extends Composite {
    private Spinner hoursSpinner;
    private Spinner minutesSpinner;
    private Button enabledCheckbox;

    public TimeParamView(Composite parent, int defaultValue) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(4, true);
        this.setLayout((Layout)gridLayout);
        this.setToolTipText(Messages.TimeParamView_ToolTip);
        this.enabledCheckbox = new Button((Composite)this, 32);
        Composite pannel = new Composite((Composite)this, 0);
        pannel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        gridLayout = new GridLayout(5, false);
        pannel.setLayout((Layout)gridLayout);
        pannel.setToolTipText(Messages.TimeParamView_ToolTip);
        ControlDecoration timerDecorator = new ControlDecoration((Control)pannel, 131200);
        timerDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
        timerDecorator.setDescriptionText(Messages.TimeParamView_TimeoutTooLargeWarn);
        timerDecorator.hide();
        this.hoursSpinner = new Spinner(pannel, 2048);
        this.hoursSpinner.setMinimum(0);
        this.hoursSpinner.setMaximum(5000);
        this.hoursSpinner.setSelection(defaultValue / 60);
        this.hoursSpinner.setToolTipText(Messages.TimeParamView_ToolTip);
        Label hoursLabel = new Label(pannel, 0);
        hoursLabel.setText(Messages.TimeHours);
        hoursLabel.setToolTipText(Messages.TimeParamView_ToolTip);
        this.hoursSpinner.setData("ddrv.model.time", (Object)"ddrv.model.time.hours");
        this.hoursSpinner.setData("qcs.validation.ddr.widget.decorator", (Object)timerDecorator);
        this.minutesSpinner = new Spinner(pannel, 2048);
        this.minutesSpinner.setMinimum(0);
        this.minutesSpinner.setMaximum(59);
        this.minutesSpinner.setSelection(defaultValue % 60);
        Label minutesLabel = new Label(pannel, 0);
        minutesLabel.setText(Messages.TimeMinutes);
        minutesLabel.setToolTipText(Messages.TimeParamView_ToolTip);
        this.minutesSpinner.setData("ddrv.model.time", (Object)"ddrv.model.time.minutes");
        this.minutesSpinner.setToolTipText(Messages.TimeParamView_ToolTip);
        this.minutesSpinner.setData("qcs.validation.ddr.widget.decorator", (Object)timerDecorator);
        this.setEnabled(false);
    }

    public TimeParamView(Composite parent) {
        this(parent, 0);
    }

    public void setValue(VScriptTimeParamValue paramValue) {
        if (Integer.parseInt(paramValue.getTimeValue().toString()) > 300000) {
            return;
        }
        this.enabledCheckbox.setSelection(paramValue.isEnabled());
        this.setEnabled(paramValue.isEnabled());
        this.hoursSpinner.setSelection(Integer.parseInt(paramValue.getTimeValue().toString()) / 60);
        this.minutesSpinner.setSelection(Integer.parseInt(paramValue.getTimeValue().toString()) % 60);
    }

    public void setEnabled(boolean enabledState) {
        if (!enabledState || enabledState == this.enabledCheckbox.getSelection()) {
            this.hoursSpinner.setEnabled(enabledState);
            this.minutesSpinner.setEnabled(enabledState);
        }
    }

    public int getInputedValue() {
        return this.hoursSpinner.getSelection() * 60 + this.minutesSpinner.getSelection();
    }

    public boolean isCheckBoxSelected() {
        return this.enabledCheckbox.getSelection();
    }

    public void setData(@Nullable String key, @Nullable Object value) {
        this.hoursSpinner.setData(Objects.requireNonNull(key), Objects.requireNonNull(value));
        this.minutesSpinner.setData(Objects.requireNonNull(key), Objects.requireNonNull(value));
        this.enabledCheckbox.setData(Objects.requireNonNull(key), Objects.requireNonNull(value));
    }

    public void addListener(TimeParamListener listener) {
        this.hoursSpinner.addModifyListener((ModifyListener)listener);
        this.minutesSpinner.addModifyListener((ModifyListener)listener);
        this.enabledCheckbox.addSelectionListener((SelectionListener)listener);
    }
}

