/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.table.params;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.table.params.VParam;

public class RegFieldParam
extends VParam {
    protected int minValue;
    protected int maxValue;
    protected boolean standardIterator;
    protected boolean dynamic;
    protected boolean doubleMode;
    protected Integer[] optValues;
    protected String[] optNames;

    public RegFieldParam(RegFieldParam proto) {
        super(proto.id, proto.name, proto.horizontal);
        this.minValue = proto.minValue;
        this.maxValue = proto.maxValue;
        this.standardIterator = proto.standardIterator;
        this.dynamic = proto.dynamic;
        this.doubleMode = proto.doubleMode;
        if (!this.dynamic) {
            this.optValues = (Integer[])proto.optValues.clone();
            this.optNames = (String[])proto.optNames.clone();
        } else {
            this.optNames = new String[]{"......"};
            this.optValues = new Integer[]{new Integer(0)};
        }
    }

    public RegFieldParam(String _id, String _name, boolean _horizontal) {
        super(_id, _name, _horizontal);
        this.minValue = -1;
        this.maxValue = -1;
        this.standardIterator = false;
        this.dynamic = false;
        this.optNames = new String[]{"......"};
        this.optValues = new Integer[]{new Integer(0)};
    }

    @Override
    public void applyConfiguration(Object value, boolean handleChanges, boolean genCodeEn) {
    }

    @Override
    public VParam createCopy() {
        return new RegFieldParam(this);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    @Override
    public String @Nullable [] getOptNames() {
        return (String[])this.optNames.clone();
    }

    @Override
    public Object @Nullable [] getOptValues() {
        return (Object[])this.optValues.clone();
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isStandardIterator() {
        return this.standardIterator;
    }

    @Override
    public void populate(ValidationContext vContext) {
        if (!this.dynamic) {
            if (this.standardIterator) {
                if (this.doubleMode) {
                    int size = (this.maxValue - this.minValue + 1) * 2;
                    this.optValues = new Integer[size];
                    this.optNames = new String[size];
                    int i = 0;
                    while (i < size) {
                        this.optValues[i] = new Integer(this.minValue + i / 2);
                        this.optNames[i] = "" + i;
                        this.optValues[i + 1] = new Integer(this.minValue + i / 2);
                        this.optNames[i + 1] = "" + (i + 1);
                        i += 2;
                    }
                } else {
                    int size = this.maxValue - this.minValue + 1;
                    this.optValues = new Integer[size];
                    this.optNames = new String[size];
                    int i = 0;
                    while (i < size) {
                        this.optValues[i] = new Integer(this.minValue + i);
                        this.optNames[i] = "" + i;
                        ++i;
                    }
                }
            } else {
                this.optValues = new Integer[]{new Integer(0)};
                this.optNames = new String[]{"0"};
            }
        }
    }

    public void reset() {
        if (!this.isStandardIterator()) {
            this.optValues = new Integer[]{new Integer(0)};
            this.optNames = new String[]{"0"};
        }
    }

    public void runtimePopulate(String @Nullable [] names, int[] values) {
        this.optNames = new String[values.length];
        this.optValues = new Integer[values.length];
        int i = 0;
        while (i < values.length) {
            this.optNames[i] = names == null ? "" + i : names[i];
            this.optValues[i] = new Integer(values[i]);
            ++i;
        }
    }

    @Override
    public void update(ValidationContext vContext) {
    }
}

