/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.reports;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.swt.graphics.Point;

public class XlsReportGenerator
implements IReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger(XlsReportGenerator.class);
    public static final String CORNER_TEXT = UtilsText.safeString((String)Messages.XlsReportGenerator_0);
    public static final String DOC_TITLE = UtilsText.safeString((String)Messages.XlsReportGenerator_1);
    public static final String MAIN_HEADER_TEXT = UtilsText.safeString((String)Messages.XlsReportGenerator_2);
    public static final String MAIN_HEADER_PREFIX = UtilsText.safeString((String)Messages.XlsReportGenerator_3);
    public static final String NOT_QUEUED_TEXT = "///";
    public static final String SKIPPED_TEXT = UtilsText.safeString((String)Messages.XlsReportGenerator_4);
    public static final String ERROR_TEXT = UtilsText.safeString((String)Messages.XlsReportGenerator_5);
    public static final String TODO_TEXT = UtilsText.safeString((String)Messages.XlsReportGenerator_6);
    private static final String CELL_TESTS_SUMMARY_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_7);
    private static final String SCRIPT_NAME_SUMMARY_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_8);
    private static final String ITERATION_SUMMARY_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_9);
    private static final String RESULT_SUMMARY_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_10);
    private static final String CELL_ERR_REGS_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_11);
    private static final String PARAM_VARIATION_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_12);
    private static final String REGISTER_VARIATION_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_13);
    private static final String DETAILED_CELL_RESULTS_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_14);
    private static final String INITIAL_DDR_CONFIG_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_15);
    private static final String SMOKE_DDR_CONFIG_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_16);
    private static final String REGISTER_NAME_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_17);
    private static final String REGISTER_VALUE_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_18);
    public static final String SELECTED_SCRIPTS_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_19);
    public static final String SCRIPT_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_20);
    public static final String ITERATION_HEADER = UtilsText.safeString((String)Messages.XlsReportGenerator_21);
    private IReportGenerator.ReportType type = IReportGenerator.ReportType.EXCEL;
    private int @Nullable [] finalPos;
    private int @Nullable [] finalPos2;
    private int @Nullable [] finalPos3;
    private int @Nullable [] finalPos4;

    private static void generateCellContent(WbOutput out, int row, int col, @Nullable VParamVariation cell, boolean isGoldenCell, boolean isUserCell) {
        if (cell != null) {
            int totalTests = cell.getNumPasses() + cell.getNumFails() + cell.getNumSkips();
            int passedTests = cell.getNumPasses();
            if (!cell.isSelected()) {
                out.applyContentAndStyle(row, col, NOT_QUEUED_TEXT, 9);
                return;
            }
            String strPassedTests = passedTests + "/" + totalTests;
            switch (cell.getState()) {
                case ERR_CONFIG: {
                    out.applyContentAndStyle(row, col, ERROR_TEXT, 8);
                    break;
                }
                case ERR_CODEGEN: {
                    out.applyContentAndStyle(row, col, ERROR_TEXT, 8);
                    break;
                }
                case FAILED: {
                    out.applyContentAndStyle(row, col, strPassedTests, 12);
                    break;
                }
                case PARTIALY_PASSED: {
                    out.applyContentAndStyle(row, col, strPassedTests, 13);
                    break;
                }
                case PAUSED: {
                    out.applyContentAndStyle(row, col, strPassedTests, 17);
                    break;
                }
                case PASSED: {
                    if (isGoldenCell) {
                        out.applyContentAndStyle(row, col, strPassedTests, 15);
                        break;
                    }
                    if (isUserCell) {
                        out.applyContentAndStyle(row, col, strPassedTests, 16);
                        break;
                    }
                    out.applyContentAndStyle(row, col, strPassedTests, 14);
                    break;
                }
                case DEFAULT: {
                    if (totalTests > 0) {
                        out.applyContentAndStyle(row, col, strPassedTests, 17);
                        break;
                    }
                    out.applyContent(row, col, TODO_TEXT);
                    break;
                }
                case SKIPPED: {
                    out.applyContentAndStyle(row, col, SKIPPED_TEXT, 11);
                    break;
                }
            }
        }
    }

    private static int[] generateComplexTestExecSummary(WbOutput out, int startRow, int startCol, VTable paramTable, VParamVariation cell) {
        ++startRow;
        startCol = 1;
        VRunResult[] trrs = cell.getResults();
        if (trrs == null || trrs.length == 0) {
            return new int[]{startRow, startCol};
        }
        out.applyContentAndStyle(startRow, startCol, CELL_TESTS_SUMMARY_HEADER, 6);
        out.mergeCells(startRow, startRow, startCol, startCol + 2);
        out.applyContentAndStyle(startRow, startCol + 3, CELL_ERR_REGS_HEADER, 6);
        out.mergeCells(startRow, startRow, startCol + 3, startCol + 3);
        out.applyContentAndStyle(startRow + 1, startCol, SCRIPT_NAME_SUMMARY_HEADER, 6);
        out.applyContentAndStyle(startRow + 1, startCol + 1, ITERATION_SUMMARY_HEADER, 6);
        out.applyContentAndStyle(startRow + 1, startCol + 2, RESULT_SUMMARY_HEADER, 6);
        int index = 0;
        VRunResult[] vRunResultArray = trrs;
        int n = trrs.length;
        int n2 = 0;
        while (n2 < n) {
            VRunResult trr = vRunResultArray[n2];
            out.applyContent(startRow + 2 + index, startCol, UtilsText.safeString((String)trr.getScriptConfig().getScript().getName()));
            int iteration = trr.getNumRun() + 1;
            out.applyContent(startRow + 2 + index, startCol + 1, iteration);
            out.applyContent(startRow + 2 + index, startCol + 2, UtilsText.safeString((String)trr.getType().uiName()));
            ++index;
            ++n2;
        }
        return new int[]{startRow + 2 + trrs.length, startCol};
    }

    private static int[] generateInitialConfiguration(WbOutput out, int startRow, int startCol, VTable paramTable) {
        ++startRow;
        startCol = 1;
        if (paramTable.hasScriptParam()) {
            out.applyContentAndStyle(startRow, startCol, SMOKE_DDR_CONFIG_HEADER, 6);
        } else {
            out.applyContentAndStyle(startRow, startCol, INITIAL_DDR_CONFIG_HEADER, 6);
        }
        out.mergeCells(startRow, startRow, startCol, startCol + 1);
        out.applyContentAndStyle(startRow + 1, startCol, REGISTER_NAME_HEADER, 6);
        out.applyContentAndStyle(startRow + 1, startCol + 1, REGISTER_VALUE_HEADER, 6);
        return new int[]{startRow + 2, startCol};
    }

    private static int[] generateParamTableReport_H0_V1(WbOutput out, VTable paramTable) {
        VParamVariation goldCell;
        String[] optNamesLoc;
        int startRow = 5;
        int startCol = 1;
        VParam vparam = paramTable.getVParams()[0];
        int numCols = vparam.getNumOptions();
        out.applyContentAndStyle(startRow, startCol, CORNER_TEXT, 1);
        out.mergeCells(startRow, startRow + 1, startCol, startCol + 1);
        out.applyContentAndStyle(startRow, startCol + 2, vparam.getName(), 4);
        out.mergeCells(startRow, startRow, startCol + 2, startCol + 2 + vparam.getNumOptions() - 1);
        String hLabel = paramTable.getOptions().gethLabel();
        if (hLabel != null) {
            out.applyContentAndStyle(startRow + 2, startCol, hLabel, 2);
        }
        if ((optNamesLoc = vparam.getOptNames()) != null) {
            int i = 0;
            while (i < vparam.getNumOptions()) {
                out.applyContentAndStyle(startRow + 1, startCol + 2 + i, UtilsText.safeString((String)optNamesLoc[i]), 5);
                ++i;
            }
        }
        Point goldCellPos = (goldCell = paramTable.getGoldenVariation()) == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int j = 0;
        while (j < numCols) {
            boolean isGoldCell = goldCellPos.x == 0 && goldCellPos.y == j;
            boolean isUserCell = userCellPos.x == 0 && userCellPos.y == j;
            XlsReportGenerator.generateCellContent(out, startRow + 2, startCol + 2 + j, paramTable.getParamVariation(new Point(0, j)), isGoldCell, isUserCell);
            ++j;
        }
        return new int[]{startRow + 3, startCol};
    }

    private static int[] generateParamTableReport_H0_Vn(WbOutput out, VTable paramTable) {
        return new int[2];
    }

    private static int[] generateParamTableReport_H1_V0(WbOutput out, VTable paramTable) {
        VParamVariation goldCell;
        VParam hparam = paramTable.getHParams()[0];
        int numRows = hparam.getNumOptions();
        int startRow = 5;
        int startCol = 1;
        out.applyContentAndStyle(startRow, startCol, CORNER_TEXT, 1);
        out.mergeCells(startRow, startRow, startCol, startCol + 1);
        String vLabel = paramTable.getOptions().getvLabel();
        if (vLabel != null) {
            out.applyContentAndStyle(startRow, startCol + 2, vLabel, 4);
        }
        out.applyContentAndStyle(startRow + 1, startCol, hparam.getName(), 2);
        out.mergeCells(startRow + 1, startRow + 1 + hparam.getNumOptions() - 1, startCol, startCol);
        String[] optNamesLoc = hparam.getOptNames();
        if (optNamesLoc != null) {
            int j = 0;
            while (j < hparam.getNumOptions()) {
                out.applyContentAndStyle(startRow + 1 + j, startCol + 1, UtilsText.safeString((String)optNamesLoc[j]), 3);
                ++j;
            }
        }
        Point goldCellPos = (goldCell = paramTable.getGoldenVariation()) == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int i = 0;
        while (i < numRows) {
            boolean isGoldCell = goldCellPos.x == i && goldCellPos.y == 0;
            boolean isUserCell = userCellPos.x == i && userCellPos.y == 0;
            XlsReportGenerator.generateCellContent(out, startRow + 1 + i, startCol + 2, paramTable.getParamVariation(new Point(i, 0)), isGoldCell, isUserCell);
            ++i;
        }
        return new int[]{startRow + 1 + hparam.getNumOptions(), startCol};
    }

    private static int[] generateParamTableReport_H1_V1(WbOutput out, VTable paramTable) {
        VParamVariation goldCell;
        int i;
        VParam hparam = paramTable.getHParams()[0];
        VParam vparam = paramTable.getVParams()[0];
        int numRows = hparam.getNumOptions();
        int numCols = vparam.getNumOptions();
        int startRow = 5;
        int startCol = 1;
        out.applyContentAndStyle(startRow, startCol, CORNER_TEXT, 1);
        out.mergeCells(startRow, startRow, startCol, startCol + 1);
        String vLabel = paramTable.getOptions().getvLabel();
        if (vLabel != null) {
            out.applyContentAndStyle(startRow, startCol + 2, vLabel, 4);
        }
        out.applyContentAndStyle(startRow, startCol + 2, vparam.getName(), 4);
        out.mergeCells(startRow, startRow, startCol + 2, startCol + 2 + vparam.getNumOptions() - 1);
        String[] optNamesLoc = vparam.getOptNames();
        if (optNamesLoc != null) {
            i = 0;
            while (i < numCols) {
                out.applyContentAndStyle(startRow + 1, startCol + 2 + i, Objects.requireNonNull(optNamesLoc[i]), 5);
                ++i;
            }
        }
        out.applyContentAndStyle(startRow + 2, startCol, hparam.getName(), 2);
        out.mergeCells(startRow + 2, startRow + 2 + hparam.getNumOptions() - 1, startCol, startCol);
        optNamesLoc = hparam.getOptNames();
        if (optNamesLoc != null) {
            i = 0;
            while (i < numRows) {
                out.applyContentAndStyle(startRow + 2 + i, startCol + 1, Objects.requireNonNull(optNamesLoc[i]), 3);
                ++i;
            }
        }
        Point goldCellPos = (goldCell = paramTable.getGoldenVariation()) == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int i2 = 0;
        while (i2 < numRows) {
            int j = 0;
            while (j < numCols) {
                boolean isGoldCell = goldCellPos.x == i2 && goldCellPos.y == j;
                boolean isUserCell = userCellPos.x == i2 && userCellPos.y == j;
                XlsReportGenerator.generateCellContent(out, startRow + 2 + i2, startCol + 2 + j, paramTable.getParamVariation(new Point(i2, j)), isGoldCell, isUserCell);
                ++j;
            }
            ++i2;
        }
        return new int[]{startRow + 2 + numRows, startCol};
    }

    private static int[] generateParamTableReport_H1_Vn(WbOutput out, VTable paramTable) {
        return new int[2];
    }

    private static int[] generateParamTableReport_Hn_V0(WbOutput out, VTable paramTable) {
        return new int[2];
    }

    private static int[] generateParamTableReport_Hn_V1(WbOutput out, VTable paramTable) {
        int startRow = 5;
        int startCol = 1;
        VParam[] hparams = paramTable.getHParams();
        VParam vparam = paramTable.getVParams()[0];
        int numRows = 1;
        VParam[] vParamArray = hparams;
        int n = hparams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hparam = vParamArray[n2];
            numRows *= hparam.getNumOptions();
            ++n2;
        }
        int numCols = vparam.getNumOptions();
        out.applyContentAndStyle(startRow, startCol, CORNER_TEXT, 1);
        out.mergeCells(startRow, startRow, startCol, startCol + hparams.length - 1);
        out.applyContentAndStyle(startRow, startCol + hparams.length, vparam.getName(), 4);
        out.mergeCells(startRow, startRow, startCol + hparams.length, startCol + hparams.length + vparam.getNumOptions() - 1);
        int i = 0;
        while (i < hparams.length) {
            out.applyContentAndStyle(startRow + 1, startCol + i, hparams[i].getName(), 2);
            ++i;
        }
        String[] optNamesLoc = vparam.getOptNames();
        if (optNamesLoc != null) {
            int i2 = 0;
            while (i2 < vparam.getNumOptions()) {
                out.applyContentAndStyle(startRow + 1, startCol + hparams.length + i2, Objects.requireNonNull(optNamesLoc[i2]), 5);
                ++i2;
            }
        }
        int[] hSpans = new int[hparams.length];
        hSpans[hparams.length - 1] = 1;
        int i3 = hparams.length - 2;
        while (i3 >= 0) {
            hSpans[i3] = hSpans[i3 + 1] * hparams[i3 + 1].getNumOptions();
            --i3;
        }
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int i4 = 0;
        while (i4 < numRows) {
            int j = 0;
            while (j < numCols) {
                int k = 0;
                while (k < hparams.length) {
                    int numOpts;
                    if (i4 % hSpans[k] == 0 && (numOpts = hparams[k].getNumOptions()) > 0) {
                        String optName = Objects.requireNonNull(hparams[k].getOptNames())[i4 / hSpans[k] % numOpts];
                        out.applyContentAndStyle(startRow + 2 + i4, startCol + k, UtilsText.safeString((String)optName), 3);
                        out.mergeCells(startRow + 2 + i4, startRow + 2 + i4 + hSpans[k] - 1, startCol + k, startCol + k);
                    }
                    ++k;
                }
                boolean isGoldCell = goldCellPos.x == i4 && goldCellPos.y == j;
                boolean isUserCell = userCellPos.x == i4 && userCellPos.y == j;
                XlsReportGenerator.generateCellContent(out, startRow + 2 + i4, startCol + hparams.length + j, paramTable.getParamVariation(new Point(i4, j)), isGoldCell, isUserCell);
                ++j;
            }
            ++i4;
        }
        return new int[2];
    }

    private static int[] generateParamTableReport_Hn_Vn(WbOutput out, VTable paramTable) {
        return new int[2];
    }

    private static int[] generateParamVariationTable(WbOutput out, int startRow, int startCol, VTable paramTable, VParamVariation cell) {
        startCol = 1;
        String[][] paramNameValuePairs = cell.getParamNameValuePairs();
        out.applyContentAndStyle(++startRow, startCol, PARAM_VARIATION_HEADER, 6);
        out.mergeCells(startRow, startRow, startCol, startCol + 1);
        int i = 0;
        while (i < paramNameValuePairs.length) {
            out.applyContent(startRow + 1 + i, startCol, Objects.requireNonNull(paramNameValuePairs[i][0]));
            out.applyContent(startRow + 1 + i, startCol + 1, Objects.requireNonNull(paramNameValuePairs[i][1]));
            ++i;
        }
        startRow += paramNameValuePairs.length;
        out.applyContentAndStyle(++startRow, startCol, REGISTER_VARIATION_HEADER, 6);
        out.mergeCells(startRow, startRow, startCol, startCol + 1);
        return new int[]{startRow + 1, startCol};
    }

    private static int[] generateSelectedTestScripts(WbOutput out, int startRow, int startCol, VTable paramTable) {
        startCol = 1;
        out.applyContentAndStyle(++startRow, startCol, SELECTED_SCRIPTS_HEADER, 6);
        out.mergeCells(startRow, startRow, startCol, startCol + 1);
        out.applyContentAndStyle(startRow + 1, startCol, SCRIPT_HEADER, 6);
        out.applyContentAndStyle(startRow + 1, startCol + 1, ITERATION_HEADER, 6);
        VScriptConfig[] tsus = paramTable.getSelectedScriptConfigs();
        int i = 0;
        VScriptConfig[] vScriptConfigArray = tsus;
        int n = tsus.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptConfig tsu = vScriptConfigArray[n2];
            out.applyContent(startRow + 2 + i, startCol, UtilsText.safeString((String)tsu.getScript().getName()));
            out.applyContent(startRow + 2 + i, startCol + 1, "" + tsu.getNumRuns());
            ++i;
            ++n2;
        }
        return new int[]{startRow + 2 + tsus.length, startCol + 1};
    }

    private static int[] generateSimpleTestExecSummary(WbOutput out, int startRow, int startCol, VTable paramTable, VParamVariation cell) {
        startCol = 1;
        VRunResult[] trrs = cell.getResults();
        out.applyContentAndStyle(++startRow, startCol, CELL_TESTS_SUMMARY_HEADER, 6);
        out.mergeCells(startRow, startRow, startCol, startCol + 2);
        out.applyContentAndStyle(startRow + 1, startCol, SCRIPT_NAME_SUMMARY_HEADER, 6);
        out.applyContentAndStyle(startRow + 1, startCol + 1, ITERATION_SUMMARY_HEADER, 6);
        out.applyContentAndStyle(startRow + 1, startCol + 2, RESULT_SUMMARY_HEADER, 6);
        if (trrs != null) {
            int index = 0;
            VRunResult[] vRunResultArray = trrs;
            int n = trrs.length;
            int n2 = 0;
            while (n2 < n) {
                VRunResult trr = vRunResultArray[n2];
                out.applyContent(startRow + 2 + index, startCol, Objects.requireNonNull(trr.getScriptConfig().getScript().getName()));
                int iteration = trr.getNumRun() + 1;
                out.applyContent(startRow + 2 + index, startCol + 1, "" + iteration);
                out.applyContent(startRow + 2 + index, startCol + 2, Objects.requireNonNull(trr.getType().uiName()));
                ++index;
                ++n2;
            }
        }
        return new int[]{startRow + 2 + Objects.requireNonNull(trrs).length, startCol};
    }

    private int @Nullable [] generateDetailedResults(WbOutput out, int startRow, int startCol, VTable paramTable, boolean addUpdatedRegs, boolean addErrCaptRegs) {
        VParamVariation[][] cells;
        startCol = 1;
        out.applyContentAndStyle(++startRow, startCol, DETAILED_CELL_RESULTS_HEADER, 0);
        out.mergeCells(startRow, startRow, startCol, startCol + 10);
        this.finalPos3 = new int[]{++startRow, startCol};
        VParamVariation[][] vParamVariationArray = cells = paramTable.getParamVariations();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                VParamVariation.VState state = cell.getState();
                if (cell.isSelected() && (state != VParamVariation.VState.SKIPPED && state != VParamVariation.VState.DEFAULT || cell.getNumFails() + cell.getNumPasses() != 0)) {
                    int[] finalPos3Loc = this.finalPos3;
                    if (finalPos3Loc != null) {
                        finalPos3Loc[0] = finalPos3Loc[0] + 1;
                        String cellHeader = "Cell (" + cell.getPos().x + ", " + cell.getPos().y + ")";
                        out.applyContentAndStyle(finalPos3Loc[0], finalPos3Loc[1], cellHeader, 6);
                        out.mergeCells(finalPos3Loc[0], finalPos3Loc[0], 1, 10);
                        finalPos3Loc[0] = finalPos3Loc[0] + 1;
                        if (addUpdatedRegs) {
                            finalPos3Loc = XlsReportGenerator.generateParamVariationTable(out, finalPos3Loc[0], finalPos3Loc[1], paramTable, cell);
                        }
                        finalPos3Loc = addErrCaptRegs ? XlsReportGenerator.generateComplexTestExecSummary(out, finalPos3Loc[0], finalPos3Loc[1], paramTable, cell) : XlsReportGenerator.generateSimpleTestExecSummary(out, finalPos3Loc[0], finalPos3Loc[1], paramTable, cell);
                    }
                    this.finalPos3 = finalPos3Loc;
                }
                ++n4;
            }
            ++n2;
        }
        return this.finalPos3;
    }

    private int @Nullable [] generateOperationalTableDetailedResults(WbOutput out, int startRow, int startCol, VTable smokeTable, boolean addUpdatedRegs, boolean addErrCaptRegs) {
        VParamVariation[][] cells;
        startCol = 1;
        out.applyContentAndStyle(++startRow, startCol, DETAILED_CELL_RESULTS_HEADER, 0);
        out.mergeCells(startRow, startRow, startCol, startCol + 10);
        this.finalPos4 = new int[]{++startRow, startCol};
        VParamVariation[][] vParamVariationArray = cells = smokeTable.getParamVariations();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                VParamVariation.VState state = cell.getState();
                if (cell.isSelected() && cell.getTotalRuns() != 0 && (state != VParamVariation.VState.SKIPPED && state != VParamVariation.VState.DEFAULT || cell.getNumFails() + cell.getNumPasses() != 0)) {
                    int[] finalPos4Loc = this.finalPos4;
                    if (finalPos4Loc != null) {
                        finalPos4Loc[0] = finalPos4Loc[0] + 1;
                        String cellHeader = "Cell (" + cell.getPos().x + ", " + cell.getPos().y + ")";
                        out.applyContentAndStyle(finalPos4Loc[0], finalPos4Loc[1], cellHeader, 6);
                        out.mergeCells(finalPos4Loc[0], finalPos4Loc[0], 1, 10);
                        finalPos4Loc[0] = finalPos4Loc[0] + 1;
                        finalPos4Loc = addErrCaptRegs ? XlsReportGenerator.generateComplexTestExecSummary(out, finalPos4Loc[0], finalPos4Loc[1], smokeTable, cell) : XlsReportGenerator.generateSimpleTestExecSummary(out, finalPos4Loc[0], finalPos4Loc[1], smokeTable, cell);
                    }
                    this.finalPos4 = finalPos4Loc;
                }
                ++n4;
            }
            ++n2;
        }
        return this.finalPos4;
    }

    private void generateParamTableReport(WbOutput out, VTable paramTable, IReportGenerator.ReportData data) {
        int numH = paramTable.getHParams().length;
        int numV = paramTable.getVParams().length;
        this.finalPos = null;
        if (numH == 0 && numV == 1) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_H0_V1(out, paramTable);
        }
        if (numH == 0 && numV > 1) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_H0_Vn(out, paramTable);
        }
        if (numH == 1 && numV == 0) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_H1_V0(out, paramTable);
        }
        if (numH == 1 && numV == 1) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_H1_V1(out, paramTable);
        }
        if (numH == 1 && numV > 1) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_H1_Vn(out, paramTable);
        }
        if (numH > 1 && numV == 0) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_Hn_V0(out, paramTable);
        }
        if (numH > 1 && numV == 1) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_Hn_V1(out, paramTable);
        }
        if (numH > 1 && numV > 1) {
            this.finalPos = XlsReportGenerator.generateParamTableReport_Hn_Vn(out, paramTable);
        }
        if (data.addInitConfigs && this.finalPos != null) {
            this.finalPos = XlsReportGenerator.generateInitialConfiguration(out, this.finalPos[0], this.finalPos[1], paramTable);
        }
        if (this.finalPos != null) {
            this.finalPos = XlsReportGenerator.generateSelectedTestScripts(out, this.finalPos[0], this.finalPos[1], paramTable);
        }
        if (data.addDetailedCellResults && this.finalPos != null) {
            this.finalPos = this.generateDetailedResults(out, this.finalPos[0], this.finalPos[1], paramTable, data.addUpdatedRegs, data.addErrCaptRegs);
        }
    }

    @Override
    public boolean generateReport(VTable[] tables, IReportGenerator.ReportData data) {
        if (data == null || tables == null || tables.length == 0) {
            return false;
        }
        try {
            WbOutput out = new WbOutput(new XSSFWorkbook());
            VTable[] vTableArray = tables;
            int n = tables.length;
            int n2 = 0;
            while (n2 < n) {
                VTable table = vTableArray[n2];
                if (table.getState() != VTable.TableState.CLEAN) {
                    this.generateTableReport(out, table, data);
                }
                ++n2;
            }
            out.writeTo(data.getConcreteFilePath());
        }
        catch (SecurityException noWriteAccess) {
            throw noWriteAccess;
        }
        catch (Exception e) {
            LOGGER.severe(String.valueOf(UtilsText.safeString((String)Messages.XlsReportGenerator_22)) + e.getMessage());
            return false;
        }
        return true;
    }

    private int[] generateSmokeTableReport(WbOutput out, VTable smokeTable, IReportGenerator.ReportData data) {
        int startRow = 5;
        int startCol = 1;
        out.applyContentAndStyle(startRow, startCol, CORNER_TEXT, 1);
        String vLabel = smokeTable.getOptions().getvLabel();
        if (vLabel != null) {
            out.applyContentAndStyle(startRow, startCol + 1, vLabel, 4);
        }
        List<VScriptConfig> tsus = smokeTable.getScriptsConfig();
        ArrayList<VScriptConfig> availableTsus = new ArrayList<VScriptConfig>();
        for (VScriptConfig tsu : tsus) {
            if (tsu == null || tsu.getScript().isSpecific()) continue;
            availableTsus.add(tsu);
        }
        int numRows = availableTsus.size();
        ++startRow;
        int i = 0;
        while (i < numRows) {
            out.applyContentAndStyle(startRow + i, startCol, UtilsText.safeString((String)((VScriptConfig)availableTsus.get(i)).getScript().getName()), 2);
            XlsReportGenerator.generateCellContent(out, startRow + i, startCol + 1, smokeTable.getParamVariation(new Point(i, 0)), false, false);
            ++i;
        }
        this.finalPos2 = new int[]{startRow += numRows, startCol};
        if (data.addInitConfigs) {
            this.finalPos2 = XlsReportGenerator.generateInitialConfiguration(out, this.finalPos2[0], this.finalPos2[1], smokeTable);
        }
        if (this.finalPos2 != null) {
            this.finalPos2 = XlsReportGenerator.generateSelectedTestScripts(out, this.finalPos2[0], this.finalPos2[1], smokeTable);
        }
        if (data.addDetailedCellResults && this.finalPos2 != null) {
            this.finalPos2 = this.generateOperationalTableDetailedResults(out, this.finalPos2[0], this.finalPos2[1], smokeTable, data.addUpdatedRegs, data.addErrCaptRegs);
        }
        return new int[2];
    }

    private void generateTableReport(WbOutput out, VTable table, IReportGenerator.ReportData data) {
        out.createSheet(UtilsText.safeString((String)table.getName()));
        String dateString = DateFormat.getDateInstance(0, Locale.getDefault()).format(new Date());
        String title = String.valueOf(MAIN_HEADER_PREFIX) + dateString;
        out.applyContentAndStyle(1, 1, title, 6);
        out.mergeCells(1, 1, 1, 10);
        out.applyContentAndStyle(3, 1, Objects.requireNonNull(table.getQualifiedName()), 6);
        out.mergeCells(3, 3, 1, 10);
        if (table.hasScriptParam()) {
            this.generateSmokeTableReport(out, table, data);
        } else {
            this.generateParamTableReport(out, table, data);
        }
    }

    @Override
    public IReportGenerator.ReportType getReportType() {
        return this.type;
    }

    private static class WbOutput {
        public static final int TITLE_STYLE = 0;
        public static final int CORNER_STYLE = 1;
        public static final int HPARAM_NAME_STYLE = 2;
        public static final int HPARAM_VALUE_STYLE = 3;
        public static final int VPARAM_NAME_STYLE = 4;
        public static final int VPARAM_VALUE_STYLE = 5;
        public static final int HEADER_STYLE = 6;
        public static final int ERR_REGS_HEADER_STYLE = 7;
        public static final int CELL_ERROR_STYLE = 8;
        public static final int CELL_NQUEUED_STYLE = 9;
        public static final int CELL_QUEUED_STYLE = 10;
        public static final int CELL_SKIP_STYLE = 11;
        public static final int CELL_FAIL_STYLE = 12;
        public static final int CELL_PART_PASS_STYLE = 13;
        public static final int CELL_PASS_STYLE = 14;
        public static final int CELL_GOLD_STYLE = 15;
        public static final int CELL_USER_STYLE = 16;
        public static final int CELL_PAUSE_STYLE = 17;
        public static final int NUM_STYLES = 18;
        public static final int NO_STYLE = -1;
        private XSSFWorkbook workbook;
        @Nullable
        private XSSFCreationHelper createHelper;
        private XSSFCellStyle[] cellStyles = new XSSFCellStyle[18];
        @Nullable
        private XSSFSheet sheet;
        private Map<XlsCellPosition, @Nullable XSSFCell> cellMap = new HashMap<XlsCellPosition, XSSFCell>();
        @Nullable
        private FileOutputStream fileOut;

        public WbOutput(XSSFWorkbook _workbook) {
            this.workbook = _workbook;
            this.createHelper = this.workbook.getCreationHelper();
            XSSFFont bold16font = this.workbook.createFont();
            bold16font.setFontHeightInPoints((short)16);
            bold16font.setBold(true);
            XSSFFont bold14font = this.workbook.createFont();
            bold14font.setFontHeightInPoints((short)14);
            bold14font.setBold(true);
            XSSFFont bold12font = this.workbook.createFont();
            bold12font.setFontHeightInPoints((short)10);
            bold12font.setBold(true);
            XSSFFont normal8font = this.workbook.createFont();
            normal8font.setFontHeightInPoints((short)8);
            XSSFFont normal10grayFont = this.workbook.createFont();
            normal10grayFont.setFontHeightInPoints((short)10);
            normal10grayFont.setColor(new XSSFColor(new Color(200, 200, 200)));
            XSSFFont normal10redFont = this.workbook.createFont();
            normal10redFont.setFontHeightInPoints((short)10);
            normal10redFont.setColor(new XSSFColor(new Color(255, 0, 0)));
            this.cellStyles[0] = this.workbook.createCellStyle();
            this.cellStyles[0].setFont((Font)bold14font);
            this.cellStyles[0].setAlignment((short)2);
            this.cellStyles[0].setVerticalAlignment((short)2);
            this.cellStyles[1] = this.workbook.createCellStyle();
            this.cellStyles[1].setFont((Font)bold14font);
            this.cellStyles[1].setAlignment((short)2);
            this.cellStyles[1].setVerticalAlignment((short)2);
            this.cellStyles[2] = this.workbook.createCellStyle();
            this.cellStyles[2].setFont((Font)bold12font);
            this.cellStyles[2].setAlignment((short)2);
            this.cellStyles[2].setVerticalAlignment(VerticalAlignment.CENTER);
            this.cellStyles[2].setFillForegroundColor(new XSSFColor(new Color(217, 151, 149)));
            this.cellStyles[2].setFillPattern((short)1);
            this.cellStyles[3] = this.workbook.createCellStyle();
            this.cellStyles[3].setFont((Font)bold12font);
            this.cellStyles[3].setAlignment((short)2);
            this.cellStyles[3].setVerticalAlignment((short)2);
            this.cellStyles[3].setFillForegroundColor(new XSSFColor(new Color(230, 185, 184)));
            this.cellStyles[3].setFillPattern((short)1);
            this.cellStyles[4] = this.workbook.createCellStyle();
            this.cellStyles[4].setFont((Font)bold12font);
            this.cellStyles[4].setAlignment((short)2);
            this.cellStyles[4].setVerticalAlignment((short)2);
            this.cellStyles[4].setFillForegroundColor(new XSSFColor(new Color(149, 179, 215)));
            this.cellStyles[4].setFillPattern((short)1);
            this.cellStyles[5] = this.workbook.createCellStyle();
            this.cellStyles[5].setFont((Font)bold12font);
            this.cellStyles[5].setAlignment((short)2);
            this.cellStyles[5].setVerticalAlignment((short)2);
            this.cellStyles[5].setFillForegroundColor(new XSSFColor(new Color(184, 204, 228)));
            this.cellStyles[5].setFillPattern((short)1);
            this.cellStyles[6] = this.workbook.createCellStyle();
            this.cellStyles[6].setFont((Font)bold12font);
            this.cellStyles[6].setAlignment((short)2);
            this.cellStyles[6].setVerticalAlignment((short)2);
            this.cellStyles[6].setFillForegroundColor(new XSSFColor(new Color(221, 221, 255)));
            this.cellStyles[6].setFillPattern((short)1);
            this.cellStyles[7] = this.workbook.createCellStyle();
            this.cellStyles[7].setFont((Font)normal8font);
            this.cellStyles[7].setAlignment((short)2);
            this.cellStyles[7].setVerticalAlignment((short)2);
            this.cellStyles[7].setFillForegroundColor(new XSSFColor(new Color(221, 221, 255)));
            this.cellStyles[7].setFillPattern((short)1);
            this.cellStyles[9] = this.workbook.createCellStyle();
            this.cellStyles[9].setFont((Font)normal10grayFont);
            this.cellStyles[9].setAlignment((short)2);
            this.cellStyles[9].setVerticalAlignment((short)2);
            this.cellStyles[8] = this.workbook.createCellStyle();
            this.cellStyles[8].setFont((Font)normal10redFont);
            this.cellStyles[8].setAlignment((short)2);
            this.cellStyles[8].setVerticalAlignment((short)2);
            this.cellStyles[10] = this.workbook.createCellStyle();
            this.cellStyles[10].setFont((Font)normal10grayFont);
            this.cellStyles[10].setAlignment((short)2);
            this.cellStyles[10].setVerticalAlignment((short)2);
            this.cellStyles[11] = this.workbook.createCellStyle();
            this.cellStyles[11].setFont((Font)normal10grayFont);
            this.cellStyles[11].setAlignment((short)2);
            this.cellStyles[11].setVerticalAlignment((short)2);
            this.cellStyles[12] = this.workbook.createCellStyle();
            this.cellStyles[12].setFont((Font)normal8font);
            this.cellStyles[12].setAlignment((short)2);
            this.cellStyles[12].setVerticalAlignment((short)2);
            this.cellStyles[13] = this.workbook.createCellStyle();
            this.cellStyles[13].setFont((Font)normal8font);
            this.cellStyles[13].setAlignment((short)2);
            this.cellStyles[13].setVerticalAlignment((short)2);
            this.cellStyles[13].setFillForegroundColor(new XSSFColor(new Color(255, 165, 0)));
            this.cellStyles[13].setFillPattern((short)1);
            this.cellStyles[14] = this.workbook.createCellStyle();
            this.cellStyles[14].setFont((Font)normal8font);
            this.cellStyles[14].setAlignment((short)2);
            this.cellStyles[14].setVerticalAlignment((short)2);
            this.cellStyles[14].setFillForegroundColor(new XSSFColor(new Color(0, 255, 0)));
            this.cellStyles[14].setFillPattern((short)1);
            this.cellStyles[15] = this.workbook.createCellStyle();
            this.cellStyles[15].setFont((Font)normal8font);
            this.cellStyles[15].setAlignment((short)2);
            this.cellStyles[15].setVerticalAlignment((short)2);
            this.cellStyles[15].setFillForegroundColor(new XSSFColor(new Color(217, 203, 7)));
            this.cellStyles[15].setFillPattern((short)1);
            this.cellStyles[16] = this.workbook.createCellStyle();
            this.cellStyles[16].setFont((Font)normal8font);
            this.cellStyles[16].setAlignment((short)2);
            this.cellStyles[16].setVerticalAlignment((short)2);
            this.cellStyles[16].setFillForegroundColor(new XSSFColor(new Color(133, 168, 86)));
            this.cellStyles[16].setFillPattern((short)1);
            this.cellStyles[17] = this.workbook.createCellStyle();
            this.cellStyles[17].setFont((Font)normal8font);
            this.cellStyles[17].setAlignment((short)2);
            this.cellStyles[17].setVerticalAlignment((short)2);
            this.cellStyles[17].setFillForegroundColor(new XSSFColor(new Color(136, 238, 255)));
            this.cellStyles[17].setFillPattern((short)1);
        }

        public void applyContent(int row, int col, Object content) {
            this.applyContentAndStyle(row, col, content, -1);
        }

        public void applyContentAndStyle(int row, int col, Object content, int style) {
            XSSFCell cell = this.getCell(row, col);
            if (cell != null) {
                if (content instanceof String && this.createHelper != null) {
                    cell.setCellValue((RichTextString)this.createHelper.createRichTextString((String)content));
                }
                if (content instanceof Integer) {
                    cell.setCellValue((double)((Integer)content).intValue());
                }
                if (style >= 0 && style < 18) {
                    cell.setCellStyle((CellStyle)this.cellStyles[style]);
                }
            }
        }

        public void createSheet(String name) {
            this.sheet = this.workbook.createSheet(WorkbookUtil.createSafeSheetName((String)name));
            this.cellMap.clear();
        }

        public @Nullable XSSFCell getCell(int rowNum, int colNum) {
            if (rowNum < 0 || colNum < 0) {
                return null;
            }
            XlsCellPosition cellPos = new XlsCellPosition(rowNum, colNum);
            XSSFCell cell = this.cellMap.get(cellPos);
            XSSFSheet sheetLoc = this.sheet;
            if (cell == null && sheetLoc != null) {
                XSSFRow row = sheetLoc.getRow(rowNum);
                if (row == null) {
                    row = sheetLoc.createRow(rowNum);
                }
                if ((cell = row.getCell(colNum)) == null) {
                    cell = row.createCell(colNum);
                }
                this.cellMap.put(cellPos, cell);
            }
            return cell;
        }

        public void mergeCells(int firstRow, int lastRow, int firstCol, int lastCol) {
            if (this.sheet != null) {
                this.sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
            }
        }

        public void writeTo(String filePath) throws IOException {
            this.fileOut = new FileOutputStream(filePath);
            try {
                this.workbook.write((OutputStream)this.fileOut);
            }
            finally {
                this.fileOut.close();
            }
        }
    }

    private static class XlsCellPosition {
        private int row;
        private int col;

        public XlsCellPosition(int _row, int _col) {
            this.row = _row;
            this.col = _col;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XlsCellPosition other = (XlsCellPosition)obj;
            if (this.col != other.col) {
                return false;
            }
            return this.row == other.row;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.col;
            result = 31 * result + this.row;
            return result;
        }
    }
}

