/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.ScenarioDrawTool;
import com.nxp.swtools.mem.validation.model.presenter.SelectCellDrawTool;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.RegFieldParam;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public abstract class VScenarioPresentation {
    private static final Logger LOGGER = LogManager.getLogger(VScenarioPresentation.class);
    public static final int X_MARGIN = 10;
    public static final int Y_MARGIN = 10;
    public static final String FIRST_TABLE_PARAM_ID = "FIRST_TABLE";
    protected VStagePresentation parent;
    protected VScenario model;
    protected Point figSize = new Point(0, 0);
    protected IDisplayFigure @Nullable [][] tableFigures;
    protected Map<String, IDisplayFigure> tableFiguresMap = new HashMap<String, IDisplayFigure>();
    protected Map<String, Point> tableFiguresPosMap = new HashMap<String, Point>();
    @Nullable
    protected IDisplayFigure selectedTable;
    @Nullable
    private Point selectedCellPos;
    @Nullable
    private VParamVariation selectedCell;
    @Nullable
    private VRunResult selRunResult;
    private boolean scriptConfigAutoSelected = false;
    @Nullable
    private VScriptConfig selectedScriptConfig = null;
    @Nullable
    private VScriptConfig selectedScriptConfigSnapshot = null;
    private boolean showAllLogs = false;
    protected boolean computed;

    public VScenarioPresentation(VScenario _model, VStagePresentation _parent) {
        this.model = _model;
        this.parent = _parent;
    }

    public void draw(PaintEvent e, boolean highlight) {
        GC eventGc = e.gc;
        if (eventGc != null) {
            VTable opTable;
            if (!this.isComputed()) {
                this.precompute(eventGc);
                this.setComputed(true);
            }
            if (this.parent.getParent().getUserScriptsChanged() && (opTable = this.model.getScriptParamTable()) != null) {
                this.refreshTableFigure(opTable);
                this.precompute(eventGc);
                this.parent.getParent().setUserScriptsChanged(false);
            }
            if (this.tableFigures != null) {
                IDisplayFigure[][] iDisplayFigureArray = this.tableFigures;
                int n = this.tableFigures.length;
                int n2 = 0;
                while (n2 < n) {
                    IDisplayFigure[] tablesRow;
                    IDisplayFigure[] iDisplayFigureArray2 = tablesRow = iDisplayFigureArray[n2];
                    int n3 = tablesRow.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IDisplayFigure table = iDisplayFigureArray2[n4];
                        if (table.getModel().isVisible()) {
                            VRunResult[] res;
                            VParamVariation param;
                            Point selCell = new Point(-1, -1);
                            if (table == this.selectedTable) {
                                selCell = this.selectedCellPos;
                            }
                            if (selCell != null && (param = table.getModel().getParamVariation(new Point(0, 0))) != null && (res = param.getResults()) != null) {
                                table.draw(e, selCell, this.parent.getParent().isHighlight(), res.length);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            Collection<ScenarioDrawTool> drawTools = this.parent.getParent().getDrawTools();
            for (ScenarioDrawTool drawTool : drawTools) {
                if (!drawTool.isActive()) continue;
                if (drawTool instanceof SelectCellDrawTool) {
                    SelectCellDrawTool selectTool = (SelectCellDrawTool)drawTool;
                    IDisplayFigure selectedTableLoc = this.selectedTable;
                    Point selectedCellPosLoc = this.selectedCellPos;
                    if (selectedTableLoc != null && selectedCellPosLoc != null) {
                        Point cellPos = selectedTableLoc.getCellBoxPos(selectedCellPosLoc);
                        Point cellSize = selectedTableLoc.getCellBoxSize(selectedCellPosLoc);
                        if (cellPos != null && cellSize != null) {
                            selectTool.setCellPos(cellPos);
                            selectTool.setCellSize(cellSize);
                        } else {
                            selectTool.setCellSize(new Point(0, 0));
                        }
                    }
                }
                drawTool.draw(eventGc);
            }
        }
    }

    public @Nullable String getCheckedScript() {
        VScriptConfig[] sc;
        String script = null;
        VScriptConfig[] vScriptConfigArray = sc = this.getVisibleScriptConfigs();
        int n = sc.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptConfig s = vScriptConfigArray[n2];
            if (s.isSelected()) {
                script = s.getScript().getName();
                return script;
            }
            ++n2;
        }
        return null;
    }

    public @Nullable Point getCellAt(Point pos) {
        IDisplayFigure tableFigure = this.getTableAt(pos);
        if (tableFigure != null) {
            return tableFigure.getCellPositionAt(pos);
        }
        return new Point(-1, -1);
    }

    public VParamVariation[] getCellsInRegion(Point p1, Point p2) {
        ArrayList<VParamVariation> cellList = new ArrayList<VParamVariation>();
        Point start = new Point(0, 0);
        Point end = new Point(0, 0);
        start.x = p1.x <= p2.x ? p1.x : p2.x;
        start.y = p1.y <= p2.y ? p1.y : p2.y;
        end.x = p1.x > p2.x ? p1.x : p2.x;
        int n = end.y = p1.y > p2.y ? p1.y : p2.y;
        if (this.tableFigures != null) {
            IDisplayFigure[][] iDisplayFigureArray = this.tableFigures;
            int n2 = this.tableFigures.length;
            int n3 = 0;
            while (n3 < n2) {
                IDisplayFigure[] figList;
                IDisplayFigure[] iDisplayFigureArray2 = figList = iDisplayFigureArray[n3];
                int n4 = figList.length;
                int n5 = 0;
                while (n5 < n4) {
                    Point[] cellsPos;
                    IDisplayFigure fig = iDisplayFigureArray2[n5];
                    if (fig.getModel().isVisible() && (cellsPos = fig.getCellPositions(start, end)) != null) {
                        Point[] pointArray = cellsPos;
                        int n6 = cellsPos.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            VParamVariation el;
                            Point cellPos = pointArray[n7];
                            if (cellPos != null && (el = fig.getModel().getParamVariation(cellPos)) != null) {
                                cellList.add(el);
                            }
                            ++n7;
                        }
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        return cellList.toArray(new VParamVariation[cellList.size()]);
    }

    public VScenario getModel() {
        return this.model;
    }

    public VStagePresentation getParent() {
        return this.parent;
    }

    public @Nullable VParamVariation getSelectedCell() {
        return this.selectedCell;
    }

    public @Nullable Point getSelectedCellPosition() {
        return this.selectedCellPos;
    }

    public @Nullable VRunResult getSelectedRunResult() {
        return this.selRunResult;
    }

    public @Nullable VScriptConfig getSelectedScriptConfig() {
        boolean validScriptConfigSelection;
        boolean bl = validScriptConfigSelection = this.selectedScriptConfig != null;
        if (!validScriptConfigSelection) {
            this.setDefaultScriptConfigSelection();
        }
        return this.selectedScriptConfig;
    }

    public @Nullable VScriptConfig getSelectedScriptConfigSnapshot() {
        return this.selectedScriptConfigSnapshot;
    }

    public @Nullable IDisplayFigure getSelectedTable() {
        return this.selectedTable;
    }

    public Point getSize() {
        return this.figSize;
    }

    public @Nullable IDisplayFigure getTableAt(Point pos) {
        if (this.tableFigures != null) {
            IDisplayFigure[][] iDisplayFigureArray = this.tableFigures;
            int n = this.tableFigures.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplayFigure[] tableFiguresRow;
                IDisplayFigure[] iDisplayFigureArray2 = tableFiguresRow = iDisplayFigureArray[n2];
                int n3 = tableFiguresRow.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDisplayFigure tableFigure = iDisplayFigureArray2[n4];
                    Point tPos = tableFigure.getOffset();
                    Point tSize = tableFigure.getSize();
                    if (tableFigure.getModel().isVisible() && tPos.x <= pos.x && pos.x <= tPos.x + tSize.x && tPos.y <= pos.y && pos.y <= tPos.y + tSize.y) {
                        return tableFigure;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public @Nullable IDisplayFigure getTableFigure(VTable table) {
        return this.tableFiguresMap.get(table.getId());
    }

    public IDisplayFigure @Nullable [][] getTableFigures() {
        return this.tableFigures != null ? (IDisplayFigure[][])this.tableFigures.clone() : null;
    }

    public Collection<IDisplayFigure> getTables() {
        return this.tableFiguresMap.values();
    }

    public VScriptConfig[] getVisibleScriptConfigs() {
        ArrayList<VScriptConfig> vscList = new ArrayList<VScriptConfig>();
        VPresentationModel data = this.parent.getParent().getParent();
        VModel ddrvModel = data.getModel();
        if (ddrvModel != null) {
            Scripts scripts = ddrvModel.getValidationModel().getScripts();
            List<VScriptConfig> scList = this.model.getScriptsConfig();
            for (VScriptConfig sc : scList) {
                if (!scripts.isScriptVisible(sc.getScript())) continue;
                vscList.add(sc);
            }
        }
        return vscList.toArray(new VScriptConfig[vscList.size()]);
    }

    public boolean isComputed() {
        return this.computed;
    }

    public boolean isScriptConfigAutoSelected() {
        return this.scriptConfigAutoSelected;
    }

    private void setDefaultScriptConfigSelection() {
        VScriptConfig[] sscList = this.model.getSelectedScriptConfigs();
        if (sscList.length > 0) {
            this.selectedScriptConfig = sscList[0];
            this.selectedScriptConfigSnapshot = sscList[0];
        }
    }

    protected void makeDefaultSelections() throws Exception {
        if (this.model.isVisible()) {
            if (this.tableFigures != null) {
                IDisplayFigure[][] iDisplayFigureArray = this.tableFigures;
                int n = this.tableFigures.length;
                int n2 = 0;
                while (n2 < n) {
                    IDisplayFigure[] tableFigGroup;
                    IDisplayFigure[] iDisplayFigureArray2 = tableFigGroup = iDisplayFigureArray[n2];
                    int n3 = tableFigGroup.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IDisplayFigure tableFig = iDisplayFigureArray2[n4];
                        if (tableFig.getModel().isVisible()) {
                            this.selectedTable = tableFig;
                            break;
                        }
                        ++n4;
                    }
                    if (this.selectedTable != null) break;
                    ++n2;
                }
            }
            if (this.selectedTable == null) {
                throw new Exception();
            }
            this.selectedCellPos = new Point(0, 0);
            this.selectedCell = Objects.requireNonNull(this.selectedTable).getModel().getParamVariation(Objects.requireNonNull(this.selectedCellPos));
            this.setDefaultScriptConfigSelection();
        }
    }

    public void onUpdateTableVisibility() {
        try {
            this.makeDefaultSelections();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
        this.computed = false;
    }

    protected abstract void precompute(GC var1);

    public abstract void refreshTableFigure(VTable var1);

    public void reset() {
        if (this.tableFigures != null) {
            IDisplayFigure[][] iDisplayFigureArray = this.tableFigures;
            int n = this.tableFigures.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplayFigure[] tablesRow;
                IDisplayFigure[] iDisplayFigureArray2 = tablesRow = iDisplayFigureArray[n2];
                int n3 = tablesRow.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDisplayFigure table = iDisplayFigureArray2[n4];
                    table.reset();
                    boolean tableChanged = false;
                    VParam[] vParamArray = table.getModel().getVParams();
                    int n5 = vParamArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        RegFieldParam rParam;
                        VParam vParam = vParamArray[n6];
                        if (vParam instanceof RegFieldParam && !(rParam = (RegFieldParam)vParam).isStandardIterator()) {
                            rParam.reset();
                            tableChanged = true;
                        }
                        ++n6;
                    }
                    table.getModel().getOptions().setParam("read_eye_start", null);
                    table.getModel().getOptions().setParam("read_eye_end", null);
                    if (tableChanged) {
                        this.refreshTableFigure(table.getModel());
                        this.setComputed(false);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public void setComputed(boolean _computed) {
        this.computed = _computed;
    }

    public void setScriptConfigAutoSelected(boolean scriptConfigAutoSelected) {
        this.scriptConfigAutoSelected = scriptConfigAutoSelected;
    }

    public boolean setSelectedCell(Point cellPos) {
        if (this.selectedTable == null) {
            return false;
        }
        this.selectedCell = Objects.requireNonNull(this.selectedTable).getModel().getParamVariation(cellPos);
        if (this.selectedCell == null) {
            return false;
        }
        this.selectedCellPos = Objects.requireNonNull(this.selectedCell).getPos();
        VRunResult[] res = Objects.requireNonNull(this.selectedCell).getResults();
        if (res != null && res.length > 0) {
            this.selRunResult = res[0];
        }
        return true;
    }

    public void setSelectedCell(@Nullable VParamVariation _selectedCell) {
        if (_selectedCell == null) {
            return;
        }
        this.selectedTable = this.getTableFigure(_selectedCell.getParent());
        this.selectedCell = _selectedCell;
        this.selectedCellPos = this.selectedCell.getPos();
        VRunResult[] res = Objects.requireNonNull(this.selectedCell).getResults();
        if (res != null && res.length > 0) {
            this.selRunResult = res[0];
        }
    }

    public void setSelectedScriptConfig(VScriptConfig sc) {
        this.selectedScriptConfig = sc;
    }

    public void setSelectedScriptConfigSnapshot(VScriptConfig _selectedScriptConfigSnapshot) {
        this.selectedScriptConfigSnapshot = _selectedScriptConfigSnapshot;
    }

    public abstract boolean setSelection(Point var1);

    public void setShowAllLogs(boolean _showAllLogs) {
        this.showAllLogs = _showAllLogs;
    }

    public boolean showAllLogs() {
        return this.showAllLogs;
    }

    public void updateSelectedCell() {
        if (this.selectedTable != null && this.selectedCellPos != null) {
            this.selectedCell = this.selectedTable.getModel().getParamVariation(Objects.requireNonNull(this.selectedCellPos));
        }
    }

    public void updateTableContents() {
        if (this.tableFigures != null) {
            IDisplayFigure[][] iDisplayFigureArray = this.tableFigures;
            int n = this.tableFigures.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplayFigure[] tablesRow;
                IDisplayFigure[] iDisplayFigureArray2 = tablesRow = iDisplayFigureArray[n2];
                int n3 = tablesRow.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDisplayFigure table = iDisplayFigureArray2[n4];
                    if (table.getModel().isVisible()) {
                        table.updateAllCellContents();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public void updateCellContents(VParamVariation cell) {
        IDisplayFigure tableFig = this.getTableFigure(cell.getParent());
        if (tableFig != null) {
            tableFig.updateCellContents(cell);
        }
    }

    public void setRunningCell(VTable table, VParamVariation cell) {
        IDisplayFigure tableFig = this.getTableFigure(table);
        if (tableFig != null) {
            tableFig.setRunningCell(cell);
        }
    }
}

