/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.DiagsEyeResultHandler;
import com.nxp.swtools.mem.validation.model.presenter.Messages;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsFigure;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.figures.IntensityGraphFigure;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Label;

public class VDiagsChartsFigure
extends VDiagsFigure {
    private static final Logger LOGGER = LogManager.getLogger(VDiagsChartsFigure.class);
    @Nullable
    private IntensityGraphFigure[] intensityGraphs = new IntensityGraphFigure[0];
    @Nullable
    private Label[] intensityGraphsLabels = new Label[0];
    @Nullable
    private Label[] goldenGraphsLabels = new Label[0];

    public VDiagsChartsFigure(VTable vTable) {
        super(vTable);
    }

    @Override
    public void draw(PaintEvent e, Point selCell, boolean hiliteRunCell, int numRuns) {
        int count = 0;
        ArrayList crtDiagsData = this.diagsData;
        if (crtDiagsData == null) {
            IntensityGraphFigure label;
            IntensityGraphFigure[] intensityGraphFigureArray = this.intensityGraphs;
            int n = this.intensityGraphs.length;
            int n2 = 0;
            while (n2 < n) {
                IntensityGraphFigure intensityGraphFigure = intensityGraphFigureArray[n2];
                if (intensityGraphFigure != null) {
                    intensityGraphFigure.setDataArray(new short[0]);
                }
                ++n2;
            }
            intensityGraphFigureArray = this.intensityGraphsLabels;
            n = this.intensityGraphsLabels.length;
            n2 = 0;
            while (n2 < n) {
                label = intensityGraphFigureArray[n2];
                if (label != null) {
                    label.setText(Messages.VDiagsFigure_DQInitialLabel);
                }
                ++n2;
            }
            intensityGraphFigureArray = this.goldenGraphsLabels;
            n = this.goldenGraphsLabels.length;
            n2 = 0;
            while (n2 < n) {
                label = intensityGraphFigureArray[n2];
                if (label != null) {
                    label.setText(Messages.VDiagsFigure_GoldenCoordInitialLabel);
                }
                ++n2;
            }
            return;
        }
        for (DiagsEyeResultHandler.EyeTable table : crtDiagsData) {
            IntensityGraphFigure intensityGraph;
            if (count >= this.intensityGraphsLabels.length) {
                LOGGER.severe(String.format("Number of graph label (%d) if out of range (%d)!", count, this.intensityGraphsLabels.length));
                break;
            }
            if (count >= this.goldenGraphsLabels.length) {
                LOGGER.severe(String.format("Number of graph label (%d) if out of range (%d)!", count, this.goldenGraphsLabels.length));
                break;
            }
            ArrayList<Double> yAxis = table.yAxis();
            ArrayList<Integer> xAxis = table.xAxis();
            int[][] data = table.data();
            if (xAxis == null || yAxis == null || data == null) {
                LOGGER.severe("Invalid table data!");
                break;
            }
            int dataWidth = xAxis.size();
            int dataHeight = yAxis.size();
            short[] simuData = new short[dataWidth * dataHeight];
            int i = dataHeight - 1;
            while (i >= 0) {
                int j = 0;
                while (j < dataWidth) {
                    int currentData = data[dataHeight - i - 1][j];
                    if (currentData == -1) {
                        currentData = 255;
                    }
                    simuData[i * dataWidth + j] = currentData;
                    ++j;
                }
                --i;
            }
            Label label = this.intensityGraphsLabels[count];
            if (label == null) {
                LOGGER.severe("IntensityGraph has no label!");
                break;
            }
            Label goldenCLabel = this.goldenGraphsLabels[count];
            if (goldenCLabel == null) {
                LOGGER.severe("IntensityGraph has no golden coordinates label!");
                break;
            }
            if ((intensityGraph = this.intensityGraphs[count++]) == null) {
                LOGGER.severe("IntensityGraphFigure was not created!");
                break;
            }
            intensityGraph.setDataWidth(dataWidth);
            intensityGraph.getXAxis().setTitle(String.valueOf(String.format(Messages.VDiagsFigure_StepLabel, table.width())) + "%");
            double xAxisRangeStep = 100.0 / (double)dataWidth;
            int xAxisP = xAxis.get(dataWidth - 1) - table.tapDelay() + 1;
            double xAxisRangeEnd = xAxisRangeStep * (double)xAxisP;
            int xAxisN = dataWidth - xAxisP;
            double xAxisRangeStart = -(xAxisRangeStep * (double)xAxisN);
            intensityGraph.getXAxis().setRange(xAxisRangeStart, xAxisRangeEnd, true);
            intensityGraph.setDataHeight(dataHeight);
            intensityGraph.getYAxis().setTitle(String.format(Messages.VDiagsFigure_VrefLabel, table.height()));
            intensityGraph.getYAxis().setRange(yAxis.get(0).doubleValue(), yAxis.get(yAxis.size() - 1).doubleValue(), true);
            label.setText(String.format(Messages.VDiagsFigure_DQLabel, table.dq()));
            goldenCLabel.setText(String.format(Messages.VDiagsFigure_GoldenCoordLabel, table.goldenVref(), table.tapDelay()));
            goldenCLabel.pack();
            intensityGraph.setDataArray(simuData);
            ColorMap colorMap = new ColorMap();
            LinkedHashMap<Double, RGB> colorMapHash = new LinkedHashMap<Double, RGB>();
            colorMapHash.put(0.0, new RGB(134, 178, 51));
            colorMapHash.put(255.0, new RGB(45, 10, 1));
            colorMap.setColorMap(colorMapHash);
            colorMap.setInterpolate(true);
            intensityGraph.setColorMap(colorMap);
        }
    }

    public void updateDiagsInfo(@Nullable IntensityGraphFigure[] intenGraphs, @Nullable Label[] intenGraphsLabels, @Nullable Label[] goldGraphsLabels) {
        this.intensityGraphs = intenGraphs;
        this.intensityGraphsLabels = intenGraphsLabels;
        this.goldenGraphsLabels = goldGraphsLabels;
    }
}

