/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.model.presenter.ScenarioDrawTool;
import com.nxp.swtools.mem.validation.ui.UIResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class SelectCellRegionDrawTool
extends ScenarioDrawTool {
    public static final int SELECT_REGION_ALPHA = 100;
    private GcState savedState = new GcState();
    private GcState toolState = new GcState();
    private boolean active;
    private Point start = new Point(0, 0);
    private Point end = new Point(0, 0);

    public SelectCellRegionDrawTool() {
        this.toolState.alpha = 100;
        this.toolState.bgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.LIGHT_BLUE);
        this.toolState.fgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.DARK_GRAY);
    }

    @Override
    public void drawTool(GC gc) {
        gc.setAlpha(this.toolState.alpha);
        if (this.toolState.bgColor != null) {
            gc.setBackground(this.toolState.bgColor);
        }
        if (this.toolState.fgColor != null) {
            gc.setForeground(this.toolState.fgColor);
        }
        gc.fillRectangle(this.start.x, this.start.y, this.end.x - this.start.x, this.end.y - this.start.y);
        gc.drawRectangle(this.start.x, this.start.y, this.end.x - this.start.x, this.end.y - this.start.y);
    }

    public Point getEnd() {
        return this.end;
    }

    public Point getStart() {
        return this.start;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void restoreState(GC gc) {
        gc.setAlpha(this.savedState.alpha);
        if (this.savedState.bgColor != null) {
            gc.setBackground(this.savedState.bgColor);
        }
        if (this.savedState.fgColor != null) {
            gc.setForeground(this.savedState.fgColor);
        }
    }

    @Override
    public void saveState(GC gc) {
        this.savedState.alpha = gc.getAlpha();
        this.savedState.bgColor = gc.getBackground();
        this.savedState.fgColor = gc.getForeground();
    }

    public void setActive(boolean _active) {
        this.active = _active;
    }

    public void setEnd(Point _end) {
        this.end = _end;
    }

    public void setStart(Point _start) {
        this.start = _start;
    }

    private static class GcState {
        public int alpha;
        @Nullable
        public Color bgColor;
        @Nullable
        public Color fgColor;
    }
}

