/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HintsHandler {
    private static final Logger LOGGER = LogManager.getLogger(HintsHandler.class);
    private static final String PHY_ERROR_REGEX = "^(\\[[1-2]\\])(.*)(Assertion Error - terminating)(.*)";
    private static final String PHY_STAGE_COMPLETED_REGEX = "\\[%s\\] End of %s";
    private static final String GENERIC_PHASE_NAME = "Generic";
    private static final String INITIALIZATION_STAGE_NAME = "initialization";
    private static final String TEST_STAGE_NAME = "test failure";
    private static final String GENERIC_SYMPTOM = "Generic failure";
    boolean hasHintsSupport = false;
    String hintsFileName = "";
    Map<String, Map<String, Map<String, List<Hint>>>> hintsData = new LinkedHashMap<String, Map<String, Map<String, List<Hint>>>>();
    List<CollectionsUtils.Pair<String, String>> knownStages = new ArrayList<CollectionsUtils.Pair<String, String>>();

    public HintsHandler() {
        this.hintsFileName = HintsHandler.getHintsFileName();
        this.hasHintsSupport = !this.hintsFileName.isBlank();
        this.computeHints();
        this.computeKnownStages();
    }

    public boolean isAvailable() {
        return this.hasHintsSupport;
    }

    public List<Hint> getHints(VRunResult runResult) {
        Map<String, List<Hint>> genericSymptoms;
        Map<String, Map<String, List<Hint>>> genericStages;
        String stage;
        Map<String, List<Hint>> symptoms;
        CollectionsUtils.Pair<String, String> failedStage;
        String phase;
        Map<String, Map<String, List<Hint>>> stages;
        int failedStageIdx;
        int lastSuccessfullStageIdx;
        ArrayList<Hint> hints = new ArrayList<Hint>();
        // Could not load outer class - annotation placement on inner may be incorrect
        CollectionsUtils.Pair<String, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable CollectionsUtils.Pair<String, String>> problem = this.getHintDataFromResult(runResult);
        CollectionsUtils.Pair lastSuccessfullStage = (CollectionsUtils.Pair)problem.getSecond();
        if (lastSuccessfullStage != null && (lastSuccessfullStageIdx = this.knownStages.indexOf(lastSuccessfullStage)) > 0 && (failedStageIdx = lastSuccessfullStageIdx + 1) < this.knownStages.size() && (stages = this.hintsData.get(phase = (String)(failedStage = this.knownStages.get(failedStageIdx)).getFirst())) != null && (symptoms = stages.get(stage = (String)failedStage.getSecond())) != null) {
            String error = (String)problem.getFirst();
            for (Map.Entry<String, List<Hint>> entry : symptoms.entrySet()) {
                if (!HintsHandler.errorMatchesSymptom(error, entry.getKey())) continue;
                hints.addAll((Collection<Hint>)entry.getValue());
            }
        }
        if (hints.isEmpty() && (genericStages = this.hintsData.get(GENERIC_PHASE_NAME)) != null && (genericSymptoms = runResult.getFailureType() == VLoggingUtils.ScriptResultType.CONFIGURATION_ERROR ? genericStages.get(INITIALIZATION_STAGE_NAME) : genericStages.get(TEST_STAGE_NAME)) != null) {
            hints.addAll((Collection<Hint>)genericSymptoms.get(GENERIC_SYMPTOM));
        }
        if (hints.isEmpty()) {
            hints.add(new Hint("", "", Messages.LogLevelSymptom, Messages.LogLevelCause));
        }
        return hints;
    }

    /*
     * WARNING - void declaration
     */
    private // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<String, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CollectionsUtils.Pair<String, String>> getHintDataFromResult(VRunResult runResult) {
        Object option;
        VModel vModel;
        VPresentationModel presentationModel;
        boolean filterPhyLog = false;
        ValidationContext vContext = ValidationContext.getInstance();
        if (vContext.isModelSet() && (presentationModel = vContext.getData()) != null && (vModel = presentationModel.getModel()) != null && (option = vModel.getCustomOption("filterPhyLog")) != null) {
            filterPhyLog = Boolean.parseBoolean((String)option);
        }
        String logFilePath = filterPhyLog ? TestResultsLogger.getPhyTrainingLogFilePath(runResult.getParamVariation()) : TestResultsLogger.getLogFilePath(runResult);
        List<@NonNull E> log = new ArrayList();
        try {
            option = null;
            Object var7_10 = null;
            try (InputStream file = UtilsFile.readFile((String)logFilePath);){
                if (file != null) {
                    log = UtilsFile.readStreamStringList((InputStream)file);
                }
            }
            catch (Throwable throwable) {
                if (option == null) {
                    option = throwable;
                } else if (option != throwable) {
                    ((Throwable)option).addSuppressed(throwable);
                }
                throw option;
            }
        }
        catch (IOException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        int logSize = log.size();
        if (logSize != 0) {
            void var10_20;
            Pattern errPattern = Pattern.compile(PHY_ERROR_REGEX);
            int errorLineIdx = -1;
            LinkedHashMap<CollectionsUtils.Pair<String, String>, Pattern> stagePatterns = new LinkedHashMap<CollectionsUtils.Pair<String, String>, Pattern>();
            for (CollectionsUtils.Pair<String, String> pair : this.knownStages) {
                String stagePattern = String.format(PHY_STAGE_COMPLETED_REGEX, pair.getFirst(), pair.getSecond());
                stagePatterns.put(pair, Pattern.compile(stagePattern));
            }
            Object var10_19 = null;
            int idx = logSize - 1;
            while (idx >= 0 && var10_20 == null) {
                String logLine = (String)log.get(idx);
                Matcher errMatcher = errPattern.matcher(logLine);
                if (errorLineIdx == -1 && errMatcher.matches()) {
                    errorLineIdx = idx - 1;
                }
                for (Map.Entry entry : stagePatterns.entrySet()) {
                    Matcher stageMatcher = ((Pattern)entry.getValue()).matcher(logLine);
                    if (!stageMatcher.matches()) continue;
                    CollectionsUtils.Pair pair = (CollectionsUtils.Pair)entry.getKey();
                    break;
                }
                --idx;
            }
            String errorMsg = errorLineIdx > 0 ? (String)log.get(errorLineIdx) : "";
            return new CollectionsUtils.Pair((Object)errorMsg, (Object)var10_20);
        }
        return new CollectionsUtils.Pair((Object)"", null);
    }

    private static String getHintsFileName() {
        String option;
        VModel vModel;
        VPresentationModel presentationModel;
        ValidationContext vContext = ValidationContext.getInstance();
        if (vContext.isModelSet() && (presentationModel = vContext.getData()) != null && (vModel = presentationModel.getModel()) != null && (option = vModel.getCustomOption("showAdvisor")) != null) {
            return option;
        }
        return "";
    }

    private void computeHints() {
        if (!this.hasHintsSupport) {
            return;
        }
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController == null) {
            return;
        }
        File file = configController.getResourceFile(this.hintsFileName);
        if (file == null) {
            LOGGER.severe("[DDR TOOL] No hints json file found for DDR Config Tool");
            return;
        }
        String hintsString = UtilsFile.readFileToString((String)file.getAbsolutePath(), (Charset)StandardCharsets.UTF_8);
        if (hintsString == null) {
            LOGGER.severe("[DDR TOOL] Hints json file could not be loaded");
            return;
        }
        if (!this.hintsData.isEmpty()) {
            this.hintsData.clear();
        }
        try {
            JSONObject hintsJson = new JSONObject(hintsString);
            Iterator phaseIterator = hintsJson.keys();
            while (phaseIterator.hasNext()) {
                String phase = String.valueOf(phaseIterator.next());
                JSONArray arrayStages = hintsJson.getJSONArray(phase);
                int i = 0;
                while (i < arrayStages.length()) {
                    JSONObject arrayStageData = arrayStages.getJSONObject(i);
                    Iterator stageIterator = arrayStageData.keys();
                    while (stageIterator.hasNext()) {
                        String stage = String.valueOf(stageIterator.next());
                        JSONObject stageData = arrayStageData.getJSONObject(stage);
                        Iterator symptomIterator = stageData.keys();
                        while (symptomIterator.hasNext()) {
                            String symptom = String.valueOf(symptomIterator.next());
                            JSONArray causes = stageData.getJSONArray(symptom);
                            int idx = 0;
                            while (idx < causes.length()) {
                                List<Hint> hints;
                                Map symptoms;
                                Map<Object, Object> stages;
                                String possibleCause = causes.getString(idx);
                                Hint hint = new Hint(phase, stage, idx == 0 ? symptom : "", possibleCause);
                                if (this.hintsData.containsKey(phase)) {
                                    stages = Objects.requireNonNull(this.hintsData.get(phase));
                                } else {
                                    stages = new LinkedHashMap();
                                    this.hintsData.put(phase, stages);
                                }
                                if (stages.containsKey(stage)) {
                                    symptoms = Objects.requireNonNull((Map)stages.get(stage));
                                } else {
                                    symptoms = new LinkedHashMap();
                                    stages.put(stage, symptoms);
                                }
                                if (symptoms.containsKey(symptom)) {
                                    hints = Objects.requireNonNull((List)symptoms.get(symptom));
                                } else {
                                    hints = new ArrayList();
                                    symptoms.put(symptom, hints);
                                }
                                hints.add(hint);
                                ++idx;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (JSONException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    private void computeKnownStages() {
        if (!this.knownStages.isEmpty()) {
            this.knownStages.clear();
        }
        for (Map.Entry<String, Map<String, Map<String, List<Hint>>>> entry : this.hintsData.entrySet()) {
            String phase = entry.getKey();
            for (String stage : entry.getValue().keySet()) {
                this.knownStages.add((CollectionsUtils.Pair<String, String>)new CollectionsUtils.Pair((Object)phase, (Object)stage));
            }
        }
    }

    private static boolean errorMatchesSymptom(String error, String symptom) {
        String[] symptomArray = symptom.split(" ");
        int crtIdx = 0;
        String[] stringArray = symptomArray;
        int n = symptomArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((crtIdx = error.indexOf(s, crtIdx)) < 0) {
                return false;
            }
            crtIdx += s.length();
            ++n2;
        }
        return true;
    }

    public static class Hint {
        private String phase;
        private String stage;
        private String symptom;
        private String cause;

        public Hint(String phase, String stage, String symptom, String cause) {
            this.phase = phase;
            this.stage = stage;
            this.symptom = symptom;
            this.cause = cause;
        }

        public String getPhase() {
            return this.phase;
        }

        public String getStage() {
            return this.stage;
        }

        public String getSymptom() {
            return this.symptom;
        }

        public String getCause() {
            return this.cause;
        }
    }
}

