/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.listeners.PatternParamModifyListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.ui.CustomText;
import com.nxp.swtools.mem.validation.ui.FileParamView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.mem.validation.ui.VScriptParamsView;
import com.nxp.swtools.mem.validation.utils.MathUtils;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BoolParamSelectionListener
extends SelectionAdapter {
    private VPresentationModel data;
    private static final int MIN_SELECTIONS = 1;

    public BoolParamSelectionListener(VPresentationModel data) {
        this.data = data;
    }

    public VPresentationModel getData() {
        return this.data;
    }

    private @Nullable VScriptConfig getScriptConfig() {
        VScenarioPresentation scenario;
        VScriptConfig scriptConfig = null;
        VStagePresentation stage = this.data.getSelectedStage();
        if (stage != null && (scenario = stage.getSelectedScenario()) != null) {
            scriptConfig = scenario.getSelectedScriptConfig();
        }
        return scriptConfig;
    }

    private @Nullable VScriptParamsView getParamView() {
        VScriptParamsView paramView = null;
        VScriptConfig scriptConfig = this.getScriptConfig();
        if (scriptConfig != null) {
            String scriptId = scriptConfig.getScript().getId();
            VScenarioOptionsView scenarioView = this.data.getView().getScenarioOptionsView();
            if (scenarioView != null) {
                paramView = scenarioView.getParamViews().get(scriptId);
            }
        }
        return paramView;
    }

    private void handleRandomPattern(boolean selected, @Nullable String eventString) {
        Long[] defaultPattern = new Long[]{};
        String[] tokenValues = new String[]{};
        VScriptParamsView paramView = this.getParamView();
        VScriptConfig scriptConfig = this.getScriptConfig();
        VScriptParam.VScriptParamType scriptParamType = VScriptParam.VScriptParamType.BYTE_PATTERN_HEX;
        if (paramView != null && scriptConfig != null) {
            Control patternControl = paramView.getControlByParamId("app.test_params.params");
            Text patternText = (Text)patternControl;
            VScriptParam[] vScriptParamArray = scriptConfig.getScript().getParams();
            int n = vScriptParamArray.length;
            int n2 = 0;
            while (n2 < n) {
                VScriptParam param = vScriptParamArray[n2];
                if (param.getId().equals("app.test_params.params")) {
                    scriptParamType = param.getType();
                    Object stringPattern = param.getDefaultValue();
                    tokenValues = ((String)stringPattern).replace("\n", "").replace(" ", "").split(",");
                    defaultPattern = new Long[tokenValues.length];
                    int i = 0;
                    while (i < tokenValues.length) {
                        defaultPattern[i] = Long.decode(tokenValues[i]);
                        ++i;
                    }
                }
                ++n2;
            }
            Long[] patternArray = selected ? MathUtils.getRandomArray(tokenValues.length, scriptParamType == VScriptParam.VScriptParamType.BYTE_PATTERN_HEX ? 1 : 4) : defaultPattern;
            Control fileControl = paramView.getControlByParamId("app.test_params.input_file");
            if (patternText != null) {
                if (fileControl instanceof FileParamView) {
                    patternText.setEnabled(!selected && !((FileParamView)fileControl).isCheckBoxSelected());
                } else {
                    patternText.setEnabled(!selected);
                }
                if (!"ScenarioSelection".equals(eventString)) {
                    String beautifiedPatternText = PatternParamModifyListener.beautifyLongPattern(Objects.requireNonNull(patternArray), scriptParamType);
                    patternText.setText(beautifiedPatternText);
                    VScriptParamValue paramVal = scriptConfig.getParamValue("app.test_params.params");
                    if (paramVal != null) {
                        paramVal.setValue(beautifiedPatternText);
                    }
                }
            }
        }
    }

    private void handleFullMemoryControl(boolean selected) {
        Control sizeBox;
        VScriptParamsView paramView = this.getParamView();
        if (paramView != null && (sizeBox = paramView.getControlByParamId("app.test_params.size")) != null) {
            sizeBox.setEnabled(!selected);
        }
    }

    private boolean hasMinimumSelections(boolean selected, @Nullable String eventString) {
        VScriptConfig scriptConfig;
        if (!selected && !"ScenarioSelection".equals(eventString) && (scriptConfig = this.getScriptConfig()) != null) {
            return 1L < Arrays.stream(scriptConfig.getParamValues()).filter(p -> p.getParam().getType().equals((Object)VScriptParam.VScriptParamType.BOOL) && Boolean.parseBoolean(p.getValue().toString())).count();
        }
        return true;
    }

    public void widgetSelected(SelectionEvent event) {
        VStagePresentation selectedStage;
        ValidationPresentationModel validation;
        Control sizeText;
        Button button = (Button)event.widget;
        boolean selected = button.getSelection();
        boolean hasMinSelections = true;
        VScriptParamValue param = (VScriptParamValue)button.getData("qcs.validation.ddr.model");
        VScriptParamsView paramView = this.getParamView();
        if (paramView != null && param != null) {
            Control patternControl = paramView.getControlByParamId("app.test_params.params");
            Control fileControl = paramView.getControlByParamId("app.test_params.input_file");
            String paramId = param.getParam().getId();
            if ("USE_RANDOM_PATTERN".equals(paramId)) {
                this.handleRandomPattern(selected, (String)event.data);
            } else if ("app.test_params.check_full_memory".equals(paramId) && fileControl instanceof FileParamView) {
                this.handleFullMemoryControl(selected);
                ((FileParamView)fileControl).setCheckboxState(!selected);
            }
            if (patternControl == null) {
                hasMinSelections = this.hasMinimumSelections(selected, (String)event.data);
            }
        }
        if (param != null && hasMinSelections) {
            param.setValue(selected);
        } else {
            button.setSelection(true);
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null) {
                Shell shell = workbenchWindow.getShell();
                MessageBox notifyUserBox = new MessageBox(shell, 65576);
                notifyUserBox.setText(Messages.ScriptConfigSelectionListener_WarningText);
                notifyUserBox.setMessage(Messages.BoolParamSelectionListener_WarningMessage);
                notifyUserBox.open();
            }
        }
        if (param != null && param.getParam().getMinSize() != 0L && paramView != null && (sizeText = paramView.getControlByParamId("app.test_params.size")) instanceof CustomText) {
            Text text = ((CustomText)sizeText).getText();
            this.data.setSkipSync(true);
            text.notifyListeners(24, new Event());
            this.data.setSkipSync(false);
        }
        if (param != null && !this.getData().getSkipSync() && (validation = this.data.getValidationModel()) != null && (selectedStage = validation.getSelectedStage()) != null && selectedStage.getSyncScriptConfig()) {
            selectedStage.syncModifiedParam(param, this.data);
        }
        this.data.validateSelectedScriptConfig();
    }
}

