/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.jobs;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.Objects;

public class ValidationJobUpdater
implements Runnable {
    private UpdaterType type;
    private VPresentationModel data;
    @Nullable
    private VStage stage;
    @Nullable
    private VScenario scenario;
    private VTable[] tables = new VTable[0];
    private int tableIdx;
    @Nullable
    private VTable table;
    @Nullable
    private VParamVariation cell;
    private boolean targetUnlockSuccess;

    public ValidationJobUpdater(VPresentationModel data, UpdaterType type) {
        this.data = data;
        this.type = type;
    }

    @Override
    public void run() {
        VStage _stage = Objects.requireNonNull(this.stage);
        switch (this.type) {
            case ON_CANCEL: {
                this.data.onValidationCancelled(_stage, Objects.requireNonNull(this.scenario), this.tables, this.tableIdx, this.cell, this.targetUnlockSuccess);
                break;
            }
            case ON_CONFIG_ERROR: {
                this.data.onValidationConfigError(_stage, Objects.requireNonNull(this.scenario), this.tables, this.tableIdx, Objects.requireNonNull(this.cell), this.targetUnlockSuccess);
                break;
            }
            case ON_CODEGEN_ERROR: {
                this.data.onValidationCodegenError(_stage, Objects.requireNonNull(this.scenario), this.tables, this.tableIdx, Objects.requireNonNull(this.cell), this.targetUnlockSuccess);
                break;
            }
            case ON_SERVER_TIMEOUT: {
                this.data.onValidationServerTimeout(_stage, Objects.requireNonNull(this.scenario), this.tables, this.tableIdx, this.cell, this.targetUnlockSuccess);
                break;
            }
            case ON_VALIDATION_FINISH: {
                this.data.onValidationEnd(_stage, Objects.requireNonNull(this.scenario), this.targetUnlockSuccess);
                break;
            }
            case ON_TARGET_ERROR: {
                this.data.onValidationTargetError(_stage);
            }
        }
    }

    public void setCell(VParamVariation cell) {
        this.cell = cell;
    }

    public void setScenario(VScenario scenario) {
        this.scenario = scenario;
    }

    public void setStage(VStage stage) {
        this.stage = stage;
    }

    public void setTables(VTable[] _tables, @Nullable VTable _table) {
        assert (_tables.length > 0) : Messages.ValidationJobUpdater_0;
        this.tables = new VTable[_tables.length];
        int index = 0;
        while (index < _tables.length) {
            this.tables[index] = Objects.requireNonNull(_tables[index]);
            ++index;
        }
        this.table = _table;
        this.tableIdx = -1;
        int i = 0;
        while (i < _tables.length) {
            if (_tables[i] == this.table) {
                this.tableIdx = i;
                break;
            }
            ++i;
        }
        assert (this.tableIdx != -1) : Messages.ValidationJobUpdater_1;
    }

    public void setTargetUnlockSuccess(boolean _targetUnlockSuccess) {
        this.targetUnlockSuccess = _targetUnlockSuccess;
    }

    public static enum UpdaterType {
        ON_CANCEL,
        ON_CONFIG_ERROR,
        ON_CODEGEN_ERROR,
        ON_SERVER_TIMEOUT,
        ON_VALIDATION_FINISH,
        ON_TARGET_ERROR;

    }
}

