/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.tasystem;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessType;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class TASystemDescriptor {
    public final String name;
    public TargetAccessType type;
    public final TAProcessDescriptor[] processes;

    public TASystemDescriptor(String _name, TargetAccessType _type, TAProcessDescriptor[] _processes) {
        this.name = _name;
        this.type = _type;
        this.processes = Arrays.copyOf(_processes, _processes.length);
    }

    public static class TAProcessArgument {
        public static final String PARAM_PREFIX = "${";
        public static final String PARAM_POSTFIX = "}";
        public final ArgFragment @Nullable [] fragments;

        public TAProcessArgument(ArgFragment @Nullable [] _fragments) {
            this.fragments = _fragments == null ? null : (ArgFragment[])_fragments.clone();
        }

        public String generate(Map<String, String> params) {
            StringBuilder buff = new StringBuilder();
            if (this.fragments != null) {
                ArgFragment[] argFragmentArray = this.fragments;
                int n = this.fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    ArgFragment fragment = argFragmentArray[n2];
                    if (fragment.isParam) {
                        String paramValue = params.get(fragment.text);
                        if (paramValue == null) {
                            throw new NoSuchElementException(String.valueOf(Messages.TASystemDescriptor_0) + fragment.text);
                        }
                        buff.append(paramValue);
                    } else {
                        buff.append(fragment.text);
                    }
                    ++n2;
                }
            }
            return buff.toString();
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            if (this.fragments != null) {
                ArgFragment[] argFragmentArray = this.fragments;
                int n = this.fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    ArgFragment fragment = argFragmentArray[n2];
                    if (fragment.isParam) {
                        buff.append(PARAM_PREFIX).append(fragment.text).append(PARAM_POSTFIX);
                    } else {
                        buff.append(fragment.text);
                    }
                    ++n2;
                }
            }
            return buff.toString();
        }

        public static class ArgFragment {
            public final String text;
            public final boolean isParam;

            public ArgFragment(String _text) {
                this.text = _text;
                this.isParam = false;
            }

            public ArgFragment(String _text, boolean _isParam) {
                this.text = _text;
                this.isParam = _isParam;
            }
        }
    }

    public static class TAProcessDescriptor {
        public final TargetAccessType type;
        public final TAProcessMode mode;
        public final TAProcessArgument @Nullable [] args;
        public final boolean gobbler;

        public TAProcessDescriptor(TargetAccessType _type, TAProcessMode _mode, TAProcessArgument @Nullable [] _args, boolean _gobbler) {
            this.type = _type;
            this.mode = _mode;
            this.args = _args == null ? null : (TAProcessArgument[])_args.clone();
            this.gobbler = _gobbler;
        }
    }

    public static enum TAProcessMode {
        SHARED_SERVICE,
        SERVICE,
        TRANSIENT;

    }
}

