/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.actions;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.actions.GdbPyRunAction;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GdbPyStressTestAction
extends GdbPyRunAction {
    @Override
    protected boolean isTestPassed(String logResults) {
        boolean allPassed = false;
        try {
            Pattern appStatePattern = Pattern.compile("'state': \\d+");
            String[] stringArray = logResults.split(UtilsText.platformEOL);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher matcher = appStatePattern.matcher(line);
                if (matcher.find()) {
                    allPassed = true;
                    JSONObject jsonObject = new JSONObject(line.substring(line.indexOf("{")));
                    if (jsonObject.getInt("state") != 1) {
                        allPassed = false;
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (JSONException e) {
            LOGGER.info(e.getLocalizedMessage());
            return false;
        }
        return allPassed;
    }

    @Override
    protected String createShortLog(VLoggingUtils.ScriptResultType resultType, String logResults) {
        StringBuilder result = new StringBuilder();
        Pattern appStatePattern = Pattern.compile("'state': \\d+");
        String[] stringArray = logResults.split(UtilsText.platformEOL);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = appStatePattern.matcher(line);
            if (matcher.find()) {
                try {
                    boolean isPassed;
                    JSONObject jsonObject = new JSONObject(line.substring(line.indexOf("{")));
                    String testName = this.getScriptName(String.format("%d", jsonObject.getInt("test_id")));
                    boolean bl = isPassed = jsonObject.optInt("state") == 1;
                    if (isPassed) {
                        result.append(String.format("%s: %s", Messages.RunAction_TestPass, testName));
                        result.append("\r\n");
                    } else {
                        result.append(String.format("%s: %s", Messages.RunAction_TestFail, testName));
                        result.append("\r\n");
                        JSONArray recordData = jsonObject.getJSONArray("data");
                        RunAction.TestFailType errCode = RunAction.TestFailType.fromValue(recordData.getInt(0));
                        result.append(String.valueOf(errCode.errMessage) + "\r\n");
                        result.append(String.format("%s: 0x%08x%n", Messages.RunAction_AddressStr, recordData.getLong(1)));
                        result.append(String.valueOf(Messages.RunAction_TestDataLabel) + ": ");
                        result.append(jsonObject.getJSONArray("data"));
                        result.append("\r\n");
                    }
                    result.append("\r\n");
                }
                catch (JSONException e) {
                    LOGGER.info(e.getMessage());
                }
            }
            ++n2;
        }
        return result.toString();
    }

    private String getScriptName(@Nullable String testId) {
        VScript script;
        VModel vModel;
        if (testId != null && this.model != null && (vModel = this.model.getModel()) != null && (script = vModel.getValidationModel().getScript(testId)) != null) {
            return script.getName();
        }
        return "";
    }
}

