/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.core;

import com.nxp.s32ds.cle.runtime.debugger.registry.Configuration;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashAlgorithmDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FlashDescriptors;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.util.HashMap;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerFlashProgrammerLaunchUtils {
    public static void addDefaultExecutableParametersToLaunch(ILaunchConfigurationWorkingCopy lcWorkingCopy, String executable) {
        S32DebuggerFlashProgrammerParams flashParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lcWorkingCopy);
        HashMap<String, String> idToBinaryMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdIsEnabledMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToBaseAddressMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToProjectNameMap = new HashMap<String, String>();
        String binaryId = flashParams.getNextProjectId();
        idToBinaryMap.put(binaryId, executable);
        binaryIdIsEnabledMap.put(binaryId, "enabled");
        binaryIdToBaseAddressMap.put(binaryId, "");
        binaryIdToProjectNameMap.put(binaryId, "<undefined>");
        flashParams.setIdToBinaryMap(idToBinaryMap);
        flashParams.setBinaryIdIsEnabledMap(binaryIdIsEnabledMap);
        flashParams.setBinaryIdToBaseAddressMap(binaryIdToBaseAddressMap);
        flashParams.setBinaryIdToProjectNameMap(binaryIdToProjectNameMap);
        flashParams.applyParams(lcWorkingCopy);
    }

    public static void addDefaultS32DebuggerParametersToLaunch(ILaunchConfigurationWorkingCopy lcWorkingCopy, DeviceDescriptor deviceDescriptor, String deviceRevision) {
        S32DebuggerParams params = new S32DebuggerParams();
        String deviceId = deviceDescriptor.getId();
        params.setDeviceId(deviceId);
        params.setDeviceCoreId(null);
        List configs = DebuggerDescriptors.getDeviceDebuggerConfiguration((String)"s32debuggerflashprogrammer", (String)deviceId);
        String initializationScriptPath = !configs.isEmpty() ? ((Configuration)configs.get(0)).getScript() : DeviceDebuggerDescriptors.getInitializationScriptPath((String)deviceId, (String)"s32debuggerflashprogrammer");
        params.setInitializationScript(initializationScriptPath);
        params.setClientExecutable("${S32DS_GDB_ARM32_PY}");
        if (deviceRevision != null) {
            params.setDeviceRevision(deviceRevision);
        }
        params.applyParams(lcWorkingCopy);
    }

    public static void addDefaultFlashDataParametersToLaunch(ILaunchConfigurationWorkingCopy lcWorkingCopy, DeviceDescriptor deviceDescriptor) {
        S32DebuggerFlashProgrammerParams flashParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lcWorkingCopy);
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceDescriptor.getId());
        if (!descriptors.isEmpty()) {
            String flashId = ((FlashAlgorithmDescriptor)descriptors.get(0)).getFlashId();
            flashParams.setFlashName(FlashDescriptors.getFlashRegistry().getFlashDescriptor(flashId).getName());
            flashParams.setFlashType(((FlashProtocolDescriptor)FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(flashId).get(0)).getProtocolId());
        }
        flashParams.applyParams(lcWorkingCopy);
    }
}

