/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.periphs.controller.PeripheralsProblem;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class ValidationParams {
    Collection<IDependency> dependencies = new ArrayList<IDependency>();
    Collection<GenericProblem> problems = new ArrayList<GenericProblem>();

    public ValidationParams(IChildProvidable childProvidable, String source) {
        this.collectAll(CollectionsUtils.asList((Object)childProvidable), source);
    }

    public ValidationParams(Collection<? extends IChild> children, String source) {
        this.collectAll(children, source);
    }

    void collectAll(Collection<? extends IChild> children, String source) {
        for (IChild iChild : new ArrayList<IChild>(children)) {
            if (!iChild.isSettingVisible()) continue;
            this.collectDependenciesOf(iChild, source);
            this.collectProblemsOf(iChild);
            if (!(iChild instanceof IChildProvidable)) continue;
            this.collectAll(((IChildProvidable)iChild).getChildren(), source);
        }
    }

    public Collection<IDependency> getDependencies() {
        return this.dependencies;
    }

    public Collection<GenericProblem> getProblems() {
        return this.problems;
    }

    void collectDependenciesOf(IChild child, String source) {
        IDependency[] ownDeps = child.getOwnDependencies(source);
        if (!Objects.isNull(ownDeps)) {
            assert (ownDeps != null);
            this.dependencies.addAll(Arrays.asList(ownDeps));
        }
    }

    void collectProblemsOf(IChild child) {
        Level[] levelArray = Level.values();
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            String[] ownProblems = child.getOwnProblems(level);
            if (!Objects.isNull(ownProblems)) {
                assert (ownProblems != null);
                String[] stringArray = ownProblems;
                int n3 = ownProblems.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ownProblem = stringArray[n4];
                    this.problems.add(new PeripheralsProblem(child, ownProblem, level));
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

