/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.util.Objects;

public class PeripheralsProblem
extends GenericProblem {
    @Nullable
    private final String componentType;
    @Nullable
    private final String componentInstanceName;
    @Nullable
    private final String functionalGroupName;
    private IChild child;

    protected PeripheralsProblem(IChild child, String problem, Level problemLevel) {
        super("Peripherals", PeripheralsProblem.getIntLevel(problemLevel), problem, "Peripherals:" + PeripheralsProblem.getFunctionalGroupName(child.getChildContext()), PeripheralsProblem.getResource(child), problem);
        IComponentConfig componentConfig = child.getChildContext().getComponentConfig();
        this.componentType = componentConfig == null ? null : componentConfig.getName();
        IComponentInstanceConfig componentInstanceConfig = child.getChildContext().getComponentInstanceConfig();
        this.componentInstanceName = componentInstanceConfig == null ? null : componentInstanceConfig.getUiName();
        IFunctionalGroup functionalGroup = child.getChildContext().getFunctionalGroup();
        this.functionalGroupName = functionalGroup == null ? null : functionalGroup.getUiName();
        this.child = child;
    }

    private static String getFunctionalGroupName(ChildContext childContext) {
        IFunctionalGroup functionalGroup = childContext.getFunctionalGroup();
        return functionalGroup == null ? "" : functionalGroup.getName();
    }

    public static int getIntLevel(Level level) {
        switch (level) {
            case ERROR: {
                return 2;
            }
            case VERIFICATION: {
                return 1;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        return -1;
    }

    private static String getResource(IChild child) {
        IComponentInstanceConfig compInstConfig = child.getChildContext().getComponentInstanceConfig();
        IComponentConfig comConfig = child.getChildContext().getComponentConfig();
        return compInstConfig != null ? compInstConfig.getUiName() : (comConfig != null ? comConfig.getUiName() : "");
    }

    public @Nullable String getComponentInstanceName() {
        return this.componentInstanceName;
    }

    public @Nullable String getComponentType() {
        return this.componentType;
    }

    public @Nullable String getFunctionalGroupName() {
        return this.functionalGroupName;
    }

    public IChild getChild() {
        return this.child;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.componentType);
        result = 31 * result + Objects.hashCode(this.componentInstanceName);
        result = 31 * result + Objects.hashCode(this.functionalGroupName);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        PeripheralsProblem other = (PeripheralsProblem)((Object)obj);
        if (!Objects.equals(this.componentType, other.componentType)) {
            return false;
        }
        if (!Objects.equals(this.componentInstanceName, other.componentInstanceName)) {
            return false;
        }
        return Objects.equals(this.functionalGroupName, other.functionalGroupName);
    }
}

