/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.Nullable;
import java.util.Locale;

public class MigrationMessage {
    private String path;
    private String message;
    private Severity severity = Severity.getDefault();
    private ShowMode showMode = ShowMode.getDefault();

    public MigrationMessage(String path, String message) {
        this.path = path;
        this.message = message;
    }

    public MigrationMessage(String path, String message, Severity severity, ShowMode showMode) {
        this(path, message);
        this.severity = severity;
        this.showMode = showMode;
    }

    public String getPath() {
        return this.path;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public ShowMode getShowMode() {
        return this.showMode;
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;


        public static Severity getDefault() {
            return INFO;
        }

        public String getCSSClass() {
            return this.toString().toLowerCase(Locale.US);
        }

        public static Severity byName(@Nullable String name) {
            if (name == null) {
                return Severity.getDefault();
            }
            switch (name.toLowerCase(Locale.US)) {
                case "error": {
                    return ERROR;
                }
                case "warning": {
                    return WARNING;
                }
                case "info": {
                    return INFO;
                }
            }
            return Severity.getDefault();
        }
    }

    public static enum ShowMode {
        AUTOMATIC,
        MANUAL,
        ALWAYS;


        public static ShowMode getDefault() {
            return ALWAYS;
        }

        public static ShowMode byNameInMigrationElement(@Nullable String name) {
            if (name == null) {
                return ShowMode.getDefault();
            }
            switch (name.toLowerCase(Locale.US)) {
                case "automatic_only": {
                    return AUTOMATIC;
                }
                case "manual_only": {
                    return MANUAL;
                }
                case "always": {
                    return ALWAYS;
                }
            }
            return ShowMode.getDefault();
        }
    }
}

