/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime.internal.ui;

import com.nxp.s32ds.ext.rcp.runtime.internal.ui.RuntimeUiActivator;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;

public class OpenUrlHandler
extends AbstractHandler {
    private static final String URL_PARAM_ID = "com.nxp.s32ds.ext.rcp.runtime.ui.openUrl.url.param";
    private static final String FILE_PROTOCOL_PREFIX = "file:";
    private static final String ECLIPSE_HOME = "${eclipse_home}";

    public Object execute(ExecutionEvent event) {
        try {
            String path = OpenUrlHandler.resolveVars(event.getParameter(URL_PARAM_ID));
            if (path.startsWith(FILE_PROTOCOL_PREFIX)) {
                path = path.substring(FILE_PROTOCOL_PREFIX.length());
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                path = "file:///" + path;
            }
            URL url = new URL(OpenUrlHandler.urlEncodeForSpaces(path));
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        }
        catch (Exception e) {
            RuntimeUiActivator.getInstance().logError("Error during open url", e);
        }
        return null;
    }

    private static String resolveVars(String str) {
        return str.replaceAll(Pattern.quote(ECLIPSE_HOME), Platform.getInstallLocation().getURL().toExternalForm());
    }

    private static String urlEncodeForSpaces(String path) {
        return path.replaceAll(" ", "%20");
    }
}

