/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.importer;

import com.nxp.swtools.common.ui.utils.swt.UtilsImage;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.JobsHelper;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.ddr.controller.DDRController;
import com.nxp.swtools.ddr.model.DataDirectoryForDDR;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.codgen.ValidationScriptProfile;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.JTAGConnection;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.connections.ui.JtagConnectionParamView;
import com.nxp.swtools.mem.validation.integration.ddr.Messages;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.api.IProfileProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.CompiledScript;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImportTargetConfigDialog
extends Dialog {
    private static final Logger LOGGER = LogManager.getLogger(ImportTargetConfigDialog.class);
    private static final URL IMPORT_IMAGE_FILE;
    @Nullable
    protected CompiledScript compiledScript;
    protected ScriptFileProvider resourceFileProvider;
    protected IProfileProvider profileProvider;
    private static final String IMPORT_FROM_TARGET_SCRIPT = "importFromTarget.js";
    protected IConfigProvider configProvider;
    @Nullable
    VModel vModel;
    @Nullable
    protected ConnectionView connView;

    static {
        URL url = null;
        try {
            url = new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/import_wiz.png");
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Failed to load import image", e);
        }
        assert (url != null);
        IMPORT_IMAGE_FILE = url;
    }

    public ImportTargetConfigDialog(Shell parent, IConfigProvider configProvider, ScriptFileProvider resourceFileProvider) {
        super(parent);
        this.configProvider = configProvider;
        this.vModel = configProvider.getVModel();
        ValidationContext.getInstance().setConfigController(configProvider);
        this.resourceFileProvider = resourceFileProvider;
        this.profileProvider = uiThread -> new ValidationScriptProfile();
        File file = resourceFileProvider.findScriptFile(IMPORT_FROM_TARGET_SCRIPT);
        if (file != null) {
            JobsHelper.runjob((String)"Recompile Javascript", () -> {
                CompiledScript compiledScript = this.compiledScript = JavaScriptHelper.compile((File)file);
            });
        } else {
            LOGGER.severe("[TOOL] No script file found while trying to recompile the codegeneration script for DDR Config Tool");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ImportDDRConfigDialog_2);
        newShell.setImage(UtilsImage.getImage((URL)IMPORT_IMAGE_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        Control conn;
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        ConnectionView c = this.connView = new ConnectionView(mainComposite);
        c.getConnConfigComposite().setLayout((Layout)new GridLayout(1, false));
        ValidationContext context = ValidationContext.getInstance();
        JTAGConnection jtag = (JTAGConnection)context.getCurrentConnection();
        if (this.vModel != null) {
            c.updateConnectionComboEntries(this.vModel.getConnections());
        }
        Control control = conn = c.getConnConfigComposite().getChildren().length > 0 ? c.getConnConfigComposite().getChildren()[0] : null;
        if (conn == null) {
            LOGGER.severe("Import from target connection view cannot be opened!");
        } else if (conn instanceof JtagConnectionParamView && jtag != null) {
            ((JtagConnectionParamView)conn).setInput(jtag);
        }
        return c.getConnConfigComposite();
    }

    public static String calculatePathToResourcesFolder() {
        return !UtilsText.isEmpty((String)DDRController.getInstance().getSharedConfiguration().getCommonConfig().getMcuIdentification().getMcu()) ? DataDirectoryForDDR.getDDRJavaScriptDir((IMcuIdentification)SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getMcuIdentification()) : "";
    }
}

