/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.xml.settings;

import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.utils.UctXmlSettingsUtils;
import java.util.List;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;

public class AComponentStateSetting {
    @Attribute(name="id", required=true)
    private String id;
    @Attribute(name="state", required=true)
    private boolean state = false;
    @Attribute(name="condition", required=true)
    private String condition;
    @Attribute(name="value_to_write", required=false)
    private String valueToWrite;

    public AComponentStateSetting(String id, boolean state, String condition, String valueToWrite) {
        this.id = id;
        this.state = state;
        this.condition = condition;
        this.valueToWrite = valueToWrite;
    }

    public AComponentStateSetting() {
        this.id = "";
        this.state = false;
        this.condition = "";
        this.valueToWrite = "";
    }

    public String getId() {
        return this.id;
    }

    public boolean getState() {
        return this.state;
    }

    public String getCondition() {
        return this.condition;
    }

    public long getValueToWrite() {
        return UctUtils.getLongValueFromString(this.valueToWrite);
    }

    public List<String> getAllOrConditions() {
        return UctUtils.getAllOrConditions(this.condition);
    }

    public List<String> getAllAndConditions() {
        return UctUtils.getAllAndConditions(this.condition);
    }

    public String getValueToWriteAsString() {
        return this.valueToWrite;
    }

    public boolean existsOrConditionWithFieldId(String condFieldId) {
        for (String conditionLoc : this.getAllOrConditions()) {
            Matcher parenthesisGroupMatcher = UctUtils.PARENTHESIS_GROUP_REGEX.matcher(conditionLoc);
            if (parenthesisGroupMatcher.find() && parenthesisGroupMatcher.groupCount() == 1) {
                String exprString = parenthesisGroupMatcher.group(1);
                if (exprString == null) continue;
                List<String> allAndConditions = UctUtils.getAllAndConditions(exprString);
                for (String andCondition : allAndConditions) {
                    String fieldId = UctXmlSettingsUtils.getConditionField(andCondition);
                    if (fieldId == null || !fieldId.equals(condFieldId)) continue;
                    return true;
                }
                continue;
            }
            String fieldId = UctXmlSettingsUtils.getConditionField(conditionLoc);
            if (fieldId == null || !fieldId.equals(condFieldId)) continue;
            return true;
        }
        return false;
    }
}

