/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.DivCommonRatioList;
import com.nxp.swtools.clocks.model.DivCommonSlave;
import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DivMasterSlave
extends DivCommonRatioList {
    @NonNull
    private Divider master;
    @NonNull
    private DivCommonSlave slave;
    @NonNull
    private @NonNull List<@NonNull Divider> masters = new ArrayList<Divider>(1);
    @NonNull
    private @NonNull List<@NonNull DivCommonSlave> slaves = new ArrayList<DivCommonSlave>(1);

    public DivMasterSlave(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, scaler);
        this.type = ENodeType.DivMasterSlave;
        this.master = DUMMY_DIVIDER;
        this.slave = DUMMY_SLAVE;
    }

    public DivMasterSlave(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, scaler, defaultScale);
        this.type = ENodeType.DivMasterSlave;
        this.master = DUMMY_DIVIDER;
        this.slave = DUMMY_SLAVE;
    }

    @Override
    public void setMaster(@NonNull Divider master) {
        this.master = master;
    }

    @Override
    public @Nullable Divider getMasterDivider() {
        if (this.master == DUMMY_DIVIDER) {
            return null;
        }
        return this.master;
    }

    @Override
    public @NonNull List<@NonNull Divider> getMasters() {
        if (this.masters.size() < 1) {
            this.masters.add(0, this.master);
        } else {
            this.masters.set(0, this.master);
        }
        List<@NonNull Divider> result = Collections.unmodifiableList(this.masters);
        assert (result != null);
        return result;
    }

    @Override
    public void setSlave(@NonNull Divider slave) {
        assert (slave instanceof DivCommonSlave);
        this.slave = (DivCommonSlave)slave;
    }

    @Override
    public @Nullable Divider getSlave() {
        if (this.slave == DUMMY_SLAVE) {
            return null;
        }
        return this.slave;
    }

    @Override
    public @NonNull List<@NonNull DivCommonSlave> getSlaveDividers() {
        if (this.slaves.size() < 1) {
            this.slaves.add(0, this.slave);
        } else {
            this.slaves.set(0, this.slave);
        }
        List<@NonNull DivCommonSlave> result = Collections.unmodifiableList(this.slaves);
        assert (result != null);
        return result;
    }

    @Override
    public boolean setScale(@Nullable BigRational newScale) {
        BigRational curScale = null;
        FreqLimitErrorI locLogFLE = this.logFLE;
        if (newScale == null || this.scaler == null) {
            this.setScale = null;
            if (this.useDefaults) {
                curScale = this.defaultScale;
            }
        } else if (this.scaler.elem(newScale)) {
            curScale = this.setScale = newScale;
        } else {
            this.setScale = null;
        }
        if (curScale == null && newScale != null) {
            if (locLogFLE != null && this.enabled) {
                locLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
            }
            return false;
        }
        if (curScale == null) {
            return true;
        }
        boolean res = true;
        if (this.master != DUMMY_DIVIDER) {
            if (this.master.setScale != null) {
                res = this.checkScaleRatio(curScale.divide(this.master.setScale), this.master);
            } else if (this.master.useDefaults && this.master.defaultScale != null) {
                res = this.checkScaleRatio(curScale.divide(this.master.defaultScale), this.master);
            }
        }
        if (!res) {
            return false;
        }
        if (this.slave != DUMMY_SLAVE) {
            BigRational xxSlaveSetScale = this.slave.setScale;
            if (xxSlaveSetScale != null && !this.slave.isLocked()) {
                res = res && this.slave.checkScaleRatio(xxSlaveSetScale.divide(curScale), this);
            } else {
                BigRational xxSlaveDefaultScale = this.slave.defaultScale;
                if (this.slave.useDefaults && xxSlaveDefaultScale != null) {
                    res = res && this.slave.checkScaleRatio(xxSlaveDefaultScale.divide(curScale), this);
                }
            }
        }
        return res;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        EErrorType result;
        EErrorType sbr;
        assert (this.master != DUMMY_DIVIDER) : "Master divider not set in " + this.id;
        assert (this.slave != DUMMY_SLAVE) : "Slave divider not set in " + this.id;
        if (callee != this.master) {
            return EErrorType.None;
        }
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        if ((sbr = this.testInputFreq(clock)) != EErrorType.None) {
            return sbr;
        }
        assert (this.scaler != null) : "Null scaler in divider " + this.id;
        assert (this.child != null) : "Null child in divider " + this.id;
        this.inputClock = clock;
        this.compScale = null;
        BigRational xxCompScale = this.getActualScale();
        BigRational masterCompScale = this.master.getActualScale();
        assert (masterCompScale != null) : "Not defined master division scale";
        if (xxCompScale != null && ((result = this.computeWith2Scales(clock, xxCompScale, masterCompScale)) == EErrorType.None || result == EErrorType.NotEnabled)) {
            return this.slave.computeAutoWR(this, clock);
        }
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (xxSetOutputFreq != null && ((result = this.computeWithFreqScale(clock, xxSetOutputFreq, masterCompScale)) == EErrorType.None || result == EErrorType.NotEnabled)) {
            return this.slave.computeAutoWR(this, clock);
        }
        BigRational xxDefaultScale = this.defaultScale;
        if (!(xxDefaultScale == null || xxDefaultScale.compareTo(this.scaler.from) == 0 || (result = this.computeWith2Scales(clock, xxDefaultScale, masterCompScale)) != EErrorType.None && result != EErrorType.NotEnabled || (result = this.slave.computeAutoWR(this, clock)) != EErrorType.None && result != EErrorType.NotEnabled)) {
            return EErrorType.None;
        }
        EErrorType res = EErrorType.TooFast;
        boolean fst = true;
        EErrorType outres = EErrorType.None;
        block5: for (BigRational scale : this.scaler) {
            assert (scale != null);
            @NonNull EErrorType scaleRes = this.testScaleRatio(scale.divide(masterCompScale));
            if (scaleRes != EErrorType.None) {
                switch (scaleRes) {
                    case TooFast: {
                        continue block5;
                    }
                    case TooSlow: {
                        if (outres == EErrorType.None) {
                            return EErrorType.TooSlow;
                        }
                        return EErrorType.CannotSetup;
                    }
                    case CannotSetup: {
                        if (outres != EErrorType.None) continue block5;
                        outres = EErrorType.CannotSetup;
                        continue block5;
                    }
                    default: {
                        return scaleRes;
                    }
                }
            }
            BigRational newClock = clock.divide(scale);
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                if (outres != EErrorType.CannotSetup || sbr == EErrorType.TooFast) {
                    outres = sbr == EErrorType.TooFast ? sbr : (outres == EErrorType.TooFast ? EErrorType.CannotSetup : sbr);
                }
                if (sbr != EErrorType.TooSlow) continue;
                return outres;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = scale;
                nres = this.slave.computeAutoWR(this, clock);
                if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                    return EErrorType.None;
                }
            }
            if (nres == EErrorType.BothFastSlow) {
                return nres;
            }
            if (nres == EErrorType.TooSlow) {
                if (fst) {
                    return EErrorType.TooSlow;
                }
                return EErrorType.CannotSetup;
            }
            fst = false;
            if (nres == EErrorType.TooFast && res == nres) continue;
            res = EErrorType.CannotSetup;
        }
        if (outres == EErrorType.CannotSetup) {
            res = outres;
        }
        return res;
    }
}

