/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.Clock;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRatComparator;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;

public class ClockListFixed
extends Clock {
    @NonNull
    private @NonNull List<@NonNull BigRational> freqList;
    @Nullable
    private BigRational defaultFreq;
    private boolean useDefaults;

    public ClockListFixed(@NonNull String id, @NonNull List<@NonNull BigRational> freqList, @Nullable BigRational defFreq) {
        super(id, ENodeType.ClockListFixed);
        freqList.sort((Comparator<BigRational>)new BigRatComparator());
        this.freqList = freqList;
        this.defaultFreq = defFreq;
        this.useDefaults = true;
    }

    @Override
    public void includeDefaults() {
        this.useDefaults = true;
    }

    @Override
    public void excludeDefaults() {
        this.useDefaults = false;
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        boolean res = false;
        for (BigRational f : this.freqList) {
            if (!f.equals((Object)freq)) continue;
            this.freq = freq;
            res = true;
            break;
        }
        if (res) {
            return this.checkOutputFreq(freq);
        }
        FreqLimitErrorI tmpLogFLE = this.logFLE;
        if (tmpLogFLE != null && this.enabled) {
            tmpLogFLE.logFreqLimitError(false, this);
        }
        return false;
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        assert (this.child != null) : "Null child in clock source " + this.id;
        assert (this.freqList != null) : "Null list of possible frequencies in clock source " + this.id;
        assert (this.freqList.size() > 0) : "Empty list of possible frequencies in clock source " + this.id;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        this.wasComputed = true;
        BigRational actFreq = null;
        if (this.freq != null) {
            actFreq = this.freq;
        } else if (this.useDefaults && this.defaultFreq != null) {
            actFreq = this.defaultFreq;
        }
        if (actFreq != null) {
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType res = this.child.computeAutoWR(this, actFreq);
            if (res == EErrorType.None || res == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return res;
        }
        boolean wasCannotSetup = false;
        this.lastComp = ECompState.OnceSatisfied;
        for (BigRational f : this.freqList) {
            EErrorType res = this.child.computeAutoWR(this, f);
            if (res == EErrorType.TooSlow) continue;
            if (res == EErrorType.CannotSetup) {
                wasCannotSetup = true;
                continue;
            }
            if (res == EErrorType.None || res == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.freq = f;
                return EErrorType.None;
            }
            return res;
        }
        if (wasCannotSetup) {
            return EErrorType.CannotSetup;
        }
        return EErrorType.TooSlow;
    }
}

