/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Optional;

public class CalculatedTimingScale
extends TimingScale {
    @NonNull
    private ICalculus calculus;

    public CalculatedTimingScale(@NonNull ICalculus calculus) {
        this.nxt = p -> this.from;
        this.calculus = calculus;
    }

    @Override
    public int hashCode() {
        int res = this.type.hashCode();
        res ^= this.from.getNumerator().intValue();
        res ^= this.to.getDenominator().intValue();
        return res ^= this.numOfScales.intValue();
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (arg.getClass() != this.getClass()) {
            return false;
        }
        CalculatedTimingScale as = (CalculatedTimingScale)arg;
        if (this.type != as.type) {
            return false;
        }
        if (!this.from.equals((Object)as.from)) {
            return false;
        }
        if (!this.to.equals((Object)as.to)) {
            return false;
        }
        if (!this.numOfScales.equals(as.numOfScales)) {
            return false;
        }
        Optional<BigRational> op = Optional.ofNullable(this.setRequiredRatio(this.from));
        return op.equals(Optional.ofNullable(as.setRequiredRatio(as.from)));
    }

    @Override
    public boolean elem(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        CollectionsUtils.Pair<BigRational, Long[]> result = this.calculus.calculate(value);
        return result != null;
    }

    @Override
    public @Nullable BigRational setRequiredRatio(@NonNull BigRational requiredRatio) {
        CollectionsUtils.Pair<BigRational, Long[]> result = this.calculus.calculate(requiredRatio);
        if (result == null) {
            return null;
        }
        this.from = (BigRational)result.getFirst();
        this.to = this.from;
        this.numOfScales = this.numOfScales.add(BigInteger.ONE);
        return this.from;
    }
}

