/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.wizards.importWizard;

import com.nxp.swtools.clocks.script.ClocksProfileInfo;
import com.nxp.swtools.clocks.script.ClocksYamlConverter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.importer.YamlNotFoundException;
import com.nxp.swtools.utils.scripting.FileYamlContent;
import com.nxp.swtools.utils.wizards.importWizard.ASourcesImporter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ClocksSrcImporter
extends ASourcesImporter<ClocksProfileInfo, StorageClocksConfiguration> {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> extractYaml(String filePath, InputStream iStrm, IProgressMonitor monitor, boolean legacy) throws YamlNotFoundException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.setWorkRemaining(1);
        try {
            @NonNull @NonNull FileYamlContent parsed = new ClocksYamlConverter(legacy).parse(iStrm);
            if (legacy && parsed != null) {
                parsed.getFunctions().forEach(f -> {
                    if ("BOARD_BootClockRUN".equals(f.getName())) {
                        f.setCalledFromInit(true);
                    }
                });
            }
            FileYamlContent fileYamlContent = parsed;
            return fileYamlContent;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Failed to parse file: " + filePath, ex);
            return null;
        }
        finally {
            subMonitor.done();
        }
    }

    public static @Nullable FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> extractYaml(String filePath, IProgressMonitor monitor, boolean legacy) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream iStrm = new FileInputStream(filePath);){
                return ClocksSrcImporter.extractYaml(filePath, iStrm, monitor, legacy);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Failed to parse file: " + filePath, ex);
            return null;
        }
    }

    protected @Nullable FileYamlContent<ClocksProfileInfo, StorageClocksConfiguration> extractYaml(@NonNull String fileName, @NonNull IProgressMonitor monitor) {
        return ClocksSrcImporter.extractYaml(fileName, monitor, false);
    }
}

