/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.utils;

import com.nxp.swtools.clocks.data.model.EmptyProfile;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;

@NonNullByDefault
public class ClocksSourcesHelper {
    private static final Logger LOGGER = LogManager.getLogger(ClocksSourcesHelper.class);

    private ClocksSourcesHelper() {
    }

    public static boolean isGeneratingForMultiCore(ScriptResult scriptResult) {
        return scriptResult.getCores().size() > 1;
    }

    public static @Nullable ProcessorCore getProcessorCore(String coreId) {
        return (ProcessorCore)CollectionsUtils.findAny((Collection)SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getCores(), core -> core.getID().equals(coreId));
    }

    public static AExportWizard.GenerationResult getGeneratedSources(@Nullable ProcessorCore core) {
        IClocksProfile profile = UiController.getInstance().getProfile();
        ScriptResult scriptResult = profile.getGeneratedCode();
        if (profile instanceof EmptyProfile && SWToolsProperties.isHeadlessOn()) {
            LOGGER.warning("Source generation not possible for empty profile:" + scriptResult.getErrors());
            return AExportWizard.GenerationResult.fromScriptResult((ScriptResult)scriptResult);
        }
        AExportWizard.GenerationResult generationResult = ClocksSourcesHelper.isGeneratingForMultiCore(scriptResult) && core != null ? ClocksSourcesHelper.getGenerationResultForCore(scriptResult, core) : AExportWizard.GenerationResult.fromScriptResult((ScriptResult)scriptResult);
        boolean clocksEnabled = UiController.getInstance().isEnabled();
        if (clocksEnabled && !generationResult.wasSuccessful) {
            if (SWToolsProperties.isHeadlessOn()) {
                LOGGER.severe("[SDK/Data] Sources generation finished with error(s): " + scriptResult.getErrors());
            } else {
                LOGGER.warning("Sources generation finished with error(s): " + scriptResult.getErrors());
            }
        }
        return generationResult;
    }

    private static AExportWizard.GenerationResult getGenerationResultForCore(ScriptResult scriptResult, ProcessorCore core) {
        if (scriptResult.containsAnyError()) {
            return AExportWizard.GenerationResult.fail((String)scriptResult.getErrors());
        }
        return AExportWizard.GenerationResult.success((Map)CollectionsUtils.safeMap((Map)scriptResult.getOpenedFiles(core.getID())));
    }
}

