/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagram.Style;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.PaintEvent;

public class PinConnection
extends GraphicalElement {
    @Nullable
    Pin mInputPin;
    @Nullable
    Pin mOutputPin;

    public PinConnection(@Nullable Pin inputPin, @Nullable Pin outputPin) {
        this.mInputPin = inputPin;
        this.mOutputPin = outputPin;
    }

    public void setInputPin(@Nullable Pin pin) {
        this.mInputPin = pin;
    }

    public void setOutputPin(@Nullable Pin pin) {
        this.mOutputPin = pin;
    }

    @Override
    public void draw(@NonNull AffineTransform transform, @NonNull PaintEvent e, DiagramStyleProvider styleProvider) {
        Pin input = this.mInputPin;
        Pin output = this.mOutputPin;
        if (input != null && output != null) {
            Point2D startCS = transform.transform(input.getEndDS(), null);
            Point2D endCS = transform.transform(output.getStartDS(), null);
            Style style = styleProvider.getStyle(this, this.mDrawState);
            style.LineStyle.set(e);
            e.gc.drawLine((int)startCS.getX(), (int)startCS.getY(), (int)endCS.getX(), (int)endCS.getY());
            style.LineStyle.unset(e);
        }
    }

    @Override
    protected @NonNull PinConnection makeCopy() {
        return new PinConnection(this.mInputPin, this.mOutputPin);
    }

    @Override
    public void applyTransform(@NonNull AffineTransform transformDS) {
    }
}

