/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.FnPll;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.OutputEnabler;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.PrescalerSetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.FindNearValueClockOutputDialog;
import com.nxp.swtools.clocks.ui.FindNearValueDialog;
import com.nxp.swtools.clocks.ui.IValueChangeListener;
import com.nxp.swtools.clocks.ui.LockedElementDialog;
import com.nxp.swtools.clocks.ui.SettingValueDialog;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.ToolTipFormatter;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SettingEditorHelper {
    @NonNull
    private static final String ZERO_DIVISION = "/ 0";

    public static @Nullable IElement getElement(@Nullable ISettingNode node) {
        if (node == null) {
            return null;
        }
        ArrayDeque<IElement> elementStack = new ArrayDeque<IElement>(3);
        IMcu mcu = UiController.getInstance().getProfile().getMcu();
        ISettingNode workingNode = node;
        while (workingNode != null) {
            IElement element = null;
            ISetting setting = workingNode.getSetting();
            element = setting == null ? mcu.getClockElement(workingNode.getId()) : setting.getElement();
            if (element != null) {
                elementStack.push(element);
            }
            workingNode = workingNode.getParent();
        }
        IElement superElement = null;
        if (!elementStack.isEmpty()) {
            superElement = (IElement)elementStack.pop();
        }
        return superElement;
    }

    private static @NonNull Map<@NonNull ISetting, @Nullable LockState> unlockAllSettings(@NonNull IClocksConfig config) {
        HashMap<@NonNull ISetting, @Nullable LockState> backupLockedSettings = new HashMap<ISetting, LockState>();
        IMcu mcu = config.getMcu();
        SettingsDB settingsDB = mcu.getSettings();
        SettingsConfig settConf = config.getSettingsConfig();
        for (ISetting setting : settingsDB.getAllSettings()) {
            if (!setting.isUserLockable() || !config.isLocked(setting)) continue;
            LockState state = settConf.getLockState(setting);
            config.unlockSetting(setting, false);
            backupLockedSettings.put(setting, state);
        }
        return backupLockedSettings;
    }

    private static @NonNull Map<@NonNull ISetting, @Nullable LockState> unlockSettingsElement(@NonNull IClocksConfig config, @NonNull IElement element) {
        HashMap<@NonNull ISetting, @Nullable LockState> backupLockedSettings = new HashMap<ISetting, LockState>();
        SettingsConfig settConf = config.getSettingsConfig();
        ISetting mainSetting = ((IClockElement)element).getMainSetting();
        if (mainSetting != null && mainSetting.isUserLockable() && config.isLocked(mainSetting)) {
            LockState state = settConf.getLockState(mainSetting);
            config.unlockSetting(mainSetting, false);
            backupLockedSettings.put(mainSetting, state);
        }
        if (element instanceof AClockElement) {
            List<@NonNull IClockElement> internals = ((AClockElement)element).getInternalElements();
            if (internals != null) {
                for (IClockElement internal : internals) {
                    ISetting mainSettingInternal = internal.getMainSetting();
                    if (mainSettingInternal == null || !mainSettingInternal.isUserLockable() || !config.isLocked(mainSettingInternal)) continue;
                    LockState state = settConf.getLockState(mainSettingInternal);
                    config.unlockSetting(mainSettingInternal, false);
                    backupLockedSettings.put(mainSettingInternal, state);
                }
            }
            if (element instanceof FnPll) {
                FnPll fnPll = (FnPll)element;
                ArrayList<@NonNull ISetting> fnPllSettings = new ArrayList<ISetting>();
                fnPllSettings.add(fnPll.getDivSetting());
                fnPllSettings.add(fnPll.getDenomSetting());
                fnPllSettings.add(fnPll.getNumSetting());
                for (ISetting setting : fnPllSettings) {
                    if (!setting.isUserLockable() || !config.isLocked(setting)) continue;
                    LockState state = settConf.getLockState(setting);
                    config.unlockSetting(setting, false);
                    backupLockedSettings.put(setting, state);
                }
            }
        }
        return backupLockedSettings;
    }

    private static @NonNull Map<@NonNull ISetting, @Nullable LockState> unlockAllSettingsOnPath(@NonNull IClocksConfig config, @NonNull ISetting setting) {
        HashMap<@NonNull ISetting, @Nullable LockState> backupLockedSettings = new HashMap<ISetting, LockState>();
        List<@NonNull IClockElement> path = GuiController.getInstance().getElementsPathTo(setting.getElement().getID());
        if (path != null) {
            SettingsConfig settConf = config.getSettingsConfig();
            for (IClockElement elem : path) {
                List<@NonNull ISetting> settingList = elem.getSettings();
                for (ISetting settingOnPath : settingList) {
                    if (!settingOnPath.isUserLockable() || !config.isLocked(settingOnPath)) continue;
                    LockState state = settConf.getLockState(settingOnPath);
                    config.unlockSetting(settingOnPath, false);
                    backupLockedSettings.put(settingOnPath, state);
                }
            }
        }
        return backupLockedSettings;
    }

    private static void importBackupLockedSettings(@NonNull IClocksConfig config, @Nullable Map<@NonNull ISetting, @Nullable LockState> backupLockedSettings) {
        if (backupLockedSettings == null) {
            return;
        }
        for (Map.Entry<ISetting, LockState> ent : backupLockedSettings.entrySet()) {
            config.restoreLockState(ent.getKey(), ent.getValue());
        }
    }

    public static boolean findNearValue(@NonNull ISetting setting, @NonNull IClocksConfig config, @Nullable IValueChangeListener changeListener, @Nullable Shell shell) {
        if (!SettingEditorHelper.findNearValueWorker(setting, config, changeListener)) {
            SettingsConfig settingsConfig = config.getSettingsConfig();
            boolean hasOtherErrors = settingsConfig.getInvalidSettings().stream().filter(x -> !x.equals(setting)).findAny().isPresent();
            if (hasOtherErrors) {
                MessageDialog.openError((Shell)shell, (String)Messages.get().SettingsEditorHelper_FindNearValue, (String)Messages.get().SettingEditorHelper_FindNearValue_ErrorMessage_NotApplicable);
            } else {
                String requestedValue;
                LockState lockState = settingsConfig.getLockState(setting);
                SettingValue settingValue = settingsConfig.getSettingValue(setting);
                String string = requestedValue = lockState != null ? lockState.getUiValue() : settingValue.getUiValue();
                if (shell != null) {
                    if (setting.getElement() instanceof ClockOutput) {
                        Map<ISetting, LockState> backupLockedSettings;
                        FindNearValueClockOutputDialog dialog = new FindNearValueClockOutputDialog(shell, requestedValue);
                        dialog.open();
                        if (dialog.getDialogResponse() == FindNearValueClockOutputDialog.DialogResponseClockOutput.UNLOCK_ALL) {
                            backupLockedSettings = SettingEditorHelper.unlockAllSettings(config);
                        } else if (dialog.getDialogResponse() == FindNearValueClockOutputDialog.DialogResponseClockOutput.UNLOCK_ACTIVE_PATH) {
                            backupLockedSettings = SettingEditorHelper.unlockAllSettingsOnPath(config, setting);
                        } else {
                            return false;
                        }
                        config.restoreLockState(setting, lockState);
                        if (SettingEditorHelper.findNearValueWorker(setting, config, changeListener)) {
                            return true;
                        }
                        SettingEditorHelper.importBackupLockedSettings(config, backupLockedSettings);
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.get().SettingsEditorHelper_FindNearValue, (String)MessageFormat.format(UtilsText.safeString((String)Messages.get().SettingsEditorHelper_FindNearValue_ErrorMessage_NotFound), requestedValue));
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private static boolean findNearValueWorker(@NonNull ISetting setting, @NonNull IClocksConfig config, @Nullable IValueChangeListener changeListener) {
        if (setting.isFindNearValueSupported()) {
            SettingValue value = config.findNearValue(setting);
            SettingsConfig settingsConfig = config.getSettingsConfig();
            if (value != null) {
                settingsConfig.setSettingValue(setting, value);
                config.recomputeWithLock(setting);
                if (config.getErrorsAsText(setting.getName()) != null) {
                    return false;
                }
                IClocksProfile profile = config.getProfile();
                if (profile != null) {
                    profile.regenerateCode();
                }
                if (changeListener != null) {
                    UiController.getInstance().runTransaction(() -> {
                        changeListener.onValueChanged(setting, value);
                        Boolean isLocked = config.getSettingsConfig().isLocked(setting);
                        changeListener.onLockChanged(setting, isLocked);
                    });
                }
                return true;
            }
        }
        return false;
    }

    public static void findNearValueOrRestore(@NonNull ISetting setting, @NonNull IClocksConfig config, @Nullable IValueChangeListener changeListener, @Nullable Shell shell, @NonNull SettingValue value) {
        SettingsConfig settingsConfig = config.getSettingsConfig();
        SettingValue prevValue = settingsConfig.getSettingValue(setting);
        LockState prevLockState = settingsConfig.getLockState(setting);
        settingsConfig.setSettingValue(setting, value);
        settingsConfig.lockSetting(setting);
        if (!SettingEditorHelper.findNearValue(setting, config, changeListener, shell)) {
            config.setSettingValue(setting, prevValue, false, false);
        }
        SettingEditorHelper.restoreLockState(config, setting, prevLockState, true);
        if (changeListener != null) {
            Boolean isLocked = config.getSettingsConfig().isLocked(setting);
            changeListener.onLockChanged(setting, isLocked);
        }
    }

    public static void findValueInRange(@NonNull ISetting setting, @NonNull IClocksConfig config, @Nullable IValueChangeListener listener, @NonNull Frequency from, @NonNull Frequency to) {
        BigRational rangeSize = to.getValue().subtract(from.getValue());
        BigRational halveRangeSize = rangeSize.divide(2).abs();
        BigRational rationalTo = to.getValue();
        BigRational middle = rationalTo.add(halveRangeSize);
        String oldValue = SettingEditorHelper.getValue(setting, config);
        LockState oldLock = config.getSettingsConfig().getLockState(setting);
        SettingEditorHelper.setValue(setting, config, middle.toString(), null);
        boolean success = SettingEditorHelper.findNearValue(setting, config, null, null);
        String newValue = SettingEditorHelper.getValue(setting, config);
        Frequency newFrequency = Frequency.parse((String)newValue);
        if (!(success && newFrequency != null && (newFrequency.compareTo(from) >= 0 && newFrequency.compareTo(to) <= 0 || newFrequency.compareTo(to) >= 0 && newFrequency.compareTo(from) <= 0))) {
            MessageDialog.openError((Shell)GuiController.getActiveShell(), (String)Messages.get().SettingsEditorHelper_FindNearValue, (String)MessageFormat.format(Messages.get().SettingsEditorHelper_FindNearValue_ErrorMessage_NotFound, String.valueOf(from.toString()) + "-" + to.toString()));
            SettingEditorHelper.setValue(setting, config, oldValue, null);
            SettingEditorHelper.restoreLockState(config, setting, oldLock, true);
            return;
        }
        if (listener != null) {
            UiController.getInstance().runTransaction(() -> {
                listener.onValueChanged(setting, config.getSettingsConfig().getSettingValue(setting));
                listener.onLockChanged(setting, Boolean.TRUE);
            });
        }
    }

    public static String @Nullable [] getUiValuesForCombo(@NonNull ISetting setting) {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        return activeConfig == null ? null : SettingEditorHelper.getUiValuesForCombo(setting, activeConfig);
    }

    public static @NonNull String @Nullable [] getUiValuesForCombo(@NonNull ISetting setting, @NonNull IClocksConfig config) {
        @NonNull String @Nullable [] values = null;
        List<SettingValue> allowedValues = setting.getValues(config);
        if (!(allowedValues == null || setting.isComboSuppressionAllowed() && allowedValues.size() > 256)) {
            values = new String[allowedValues.size()];
            int i = 0;
            while (i < allowedValues.size()) {
                String allowedValue;
                values[i] = allowedValue = allowedValues.get(i).getUiValue();
                ++i;
            }
        } else {
            Range range = setting.getRangeOfValues(config);
            if (range != null) {
                BigRational steps = range.getMax().subtract(range.getMin()).divide(range.getStep()).add(BigRational.ONE);
                long stepsLong = (long)Math.floor(steps.doubleValue());
                if (!setting.isComboSuppressionAllowed() || stepsLong <= 256L) {
                    values = new String[(int)stepsLong];
                    int i = 0;
                    while ((long)i < stepsLong) {
                        BigRational numericalValue = range.getMin().add(new BigRational(i).multiply(range.getStep()));
                        SettingValue parsedValue = setting.parseValue(numericalValue.toString(), config);
                        values[i] = parsedValue == null ? "" : parsedValue.getUiValue();
                        ++i;
                    }
                }
            }
        }
        if (values != null && values.length != 0) {
            values[0] = SettingEditorHelper.getUiValueToShow(setting, values[0]);
        }
        return values;
    }

    public static @Nullable String getEditorToolTip(@NonNull ISetting setting) {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        return activeConfig == null ? null : SettingEditorHelper.getEditorToolTip(setting, activeConfig);
    }

    public static @Nullable String getEditorToolTip(@NonNull ISetting setting, @NonNull IClocksConfig config) {
        Range range;
        Prescaler prescaler;
        IConfigElement master;
        StringBuilder toolTipBuilder = new StringBuilder();
        String allowedValueDescription = setting.getAllowedValueDescription(config);
        if (!UtilsText.isEmpty((String)allowedValueDescription)) {
            toolTipBuilder.append(allowedValueDescription);
        }
        if (setting.getElement() instanceof Prescaler && (master = (prescaler = (Prescaler)setting.getElement()).getMasterIfCorrect(config)) != null) {
            ModelCreationI.ScaleData data = prescaler.createScaleData(config);
            String messageHead = "This divider belongs to clock group controlled by " + master.getName() + ". Allowed values are: ";
            if (data.scalelist != null) {
                toolTipBuilder.append(String.valueOf(messageHead) + UtilsText.join(data.scalelist.stream().map(x -> String.valueOf(x.longValue())), (String)", "));
                String result = UtilsText.convertLineEndings((String)toolTipBuilder.toString(), (String)"<br/>");
                return result.isEmpty() ? null : result;
            }
        }
        if ((range = setting.getRangeOfValues(config)) != null) {
            SettingValue valueForStep;
            SettingValue valueForMax;
            SettingValue valueForMin;
            if (range.isFrequency()) {
                valueForMin = setting.parseValue(Converter.toFrequency(range.getMin()), config);
                valueForMax = setting.parseValue(Converter.toFrequency(range.getMax()), config);
                valueForStep = setting.parseValue(Converter.toFrequency(range.getStep()), config);
            } else {
                valueForMin = setting.parseValue(range.getMin().toString(), config);
                valueForMax = setting.parseValue(range.getMax().toString(), config);
                valueForStep = setting.parseValue(range.getStep().toString(), config);
            }
            if (valueForMin != null && valueForMax != null && valueForStep != null) {
                if (toolTipBuilder.length() > 0) {
                    toolTipBuilder.append("\n");
                }
                if (valueForMin.equals(valueForMax)) {
                    toolTipBuilder.append(MessageFormat.format(Messages.get().SettingsEditorHelper_OnlyOneAllowedValue, valueForMin.getUiValue()));
                } else if (!valueForStep.getUiValue().equals("* 0")) {
                    toolTipBuilder.append(MessageFormat.format(Messages.get().SettingsEditorHelper_AllowedValuesFromToWithStep, valueForMin.getUiValue(), valueForMax.getUiValue(), valueForStep.getUiValue()));
                } else {
                    toolTipBuilder.append(MessageFormat.format(Messages.get().SettingEditorHelper_AllowedValuesRational, valueForMin.getUiValue(), valueForMax.getUiValue(), valueForStep.getUiValue()));
                }
            }
        }
        String toolTip = toolTipBuilder.toString();
        return (toolTip = UtilsText.convertLineEndings((String)toolTip, (String)"<br/>")).isEmpty() ? null : ToolTipFormatter.format(toolTip);
    }

    public static boolean setValue(@NonNull ISetting setting, @NonNull IClocksConfig config, @Nullable Object value, @Nullable IValueChangeListener changeListener) {
        SettingValue prevValue = config.getSettingsConfig().getSettingValue(setting);
        LockState lockState = config.getSettingsConfig().getLockState(setting);
        if (setting.isUserLockable() && lockState != null) {
            prevValue = lockState.getValue();
        }
        SettingValue selectedValue = null;
        if (value instanceof Integer) {
            int valuePos = (Integer)value;
            if (valuePos < 0) {
                return false;
            }
            List<SettingValue> allowedValues = setting.getValues(config);
            if (allowedValues != null) {
                if (valuePos >= 0 && valuePos < allowedValues.size()) {
                    selectedValue = allowedValues.get(valuePos);
                }
            } else {
                Range range = setting.getRangeOfValues(config);
                if (range != null) {
                    Object valueToParse = range.getMin().add(new BigRational(valuePos).multiply(range.getStep()));
                    valueToParse = range.isFrequency() ? Converter.toFrequency(range.getMin().add(new BigRational(valuePos).multiply(range.getStep()))) : range.getMin().add(new BigRational(valuePos).multiply(range.getStep())).toString();
                    selectedValue = setting.parseValue(valueToParse, config);
                }
            }
        } else {
            assert (value instanceof String);
            String stringValue = SettingEditorHelper.getValueToSet(setting, (String)value);
            selectedValue = setting.parseUiValue(stringValue, config);
            if (selectedValue == null) {
                selectedValue = setting.findNearestUiValue(stringValue, config);
            }
        }
        if (selectedValue != null && !selectedValue.equals(prevValue)) {
            boolean canSet;
            UiController.getInstance().setLastlyChangedSetting(setting.getId());
            if (setting.isUserLockable()) {
                SettingEditorHelper.lockSynchronously(setting, config, true, false, true, changeListener);
            }
            if (setting.getType().equals((Object)SettingType.FREQUENCY_OUTPUT) && !(setting instanceof ClockOutputSetting) && !(setting instanceof ClockSourceSetting)) {
                canSet = config.trySetSettingValue((OutputFrequencySetting)setting, selectedValue, true, true);
                if (!canSet) {
                    if (setting.isEnabled(config)) {
                        MessageDialog dialog;
                        if (!config.canChangeOutput(setting)) {
                            dialog = new LockedElementDialog(GuiController.getActiveShell(), setting.getElement().getName());
                            dialog.open();
                            if (dialog.getDialogResponse() == LockedElementDialog.DialogResponseLockedElement.UNLOCK_ELEMENT_SETTINGS) {
                                SettingEditorHelper.unlockSettingsElement(config, setting.getElement());
                                canSet = config.trySetSettingValue((OutputFrequencySetting)setting, selectedValue, true, true);
                            }
                        }
                        if (!canSet) {
                            if (setting.isFindNearValueSupported()) {
                                dialog = new FindNearValueDialog(GuiController.getActiveShell(), 0, setting, selectedValue, config);
                                dialog.open();
                            } else {
                                MessageDialog.openError((Shell)GuiController.getActiveShell(), (String)Messages.get().SettingEditorHelper_InvalidFreqTitle, (String)MessageFormat.format(Messages.get().SettingEditorHelper_InvalidFreqMessage, selectedValue.getUiValue(), setting.getName()));
                            }
                        }
                    } else {
                        MessageDialog.openError((Shell)GuiController.getActiveShell(), (String)Messages.get().SettingEditorHelper_DisabledElementTitle, (String)MessageFormat.format(Messages.get().SettingEditorHelper_DisabledElementMessage, setting.getElement().getID()));
                    }
                }
            } else {
                IElement element = setting.getElement();
                if (element instanceof ClockOutput && setting instanceof ClockOutputSetting) {
                    config.enableElementsOnPath((ClockOutput)element);
                }
                SettingValue fValue = selectedValue;
                GuiController.getInstance().runBlocking(m -> config.setSettingValue(setting, fValue, true, true));
                canSet = true;
            }
            if (canSet || !prevValue.equals(config.getSettingsConfig().getSettingValue(setting))) {
                IClocksProfile profile = config.getProfile();
                if (profile != null) {
                    profile.regenerateCode();
                }
                if (changeListener != null) {
                    SettingValue finalValue = selectedValue;
                    UiController.getInstance().runTransaction(() -> {
                        changeListener.onValueChanged(setting, finalValue);
                        Boolean isLocked = config.getSettingsConfig().isLocked(setting);
                        if (setting.isUserLockable()) {
                            changeListener.onLockChanged(setting, isLocked);
                        }
                    });
                }
                return true;
            }
        }
        return false;
    }

    public static boolean setValue(@NonNull ISetting setting, @Nullable Object value, @Nullable IValueChangeListener changeListener) {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        if (activeConfig != null) {
            return SettingEditorHelper.setValue(setting, activeConfig, value, changeListener);
        }
        return false;
    }

    public static void lockSynchronously(@NonNull ISetting setting, @NonNull IClocksConfig clocksConfig, boolean lock, boolean fireEvents, boolean coLockersOnly, @Nullable IValueChangeListener changeListener) {
        Collection<@NonNull ISetting> coLockers = setting.getSynchronousLockers();
        Boolean checkedLock = lock;
        assert (checkedLock != null);
        if (!coLockersOnly) {
            if (lock) {
                clocksConfig.lockSetting(setting);
            } else {
                clocksConfig.unlockSetting(setting, false);
            }
            if (fireEvents && changeListener != null) {
                changeListener.onLockChanged(setting, checkedLock);
            }
        }
        for (ISetting coLocker : coLockers) {
            if (lock) {
                clocksConfig.lockSetting(coLocker);
            } else {
                clocksConfig.unlockSetting(coLocker, false);
            }
            if (!fireEvents || changeListener == null) continue;
            changeListener.onLockChanged(coLocker, checkedLock);
        }
    }

    public static void lockSetting(@NonNull ISetting setting, @NonNull IClocksConfig clocksConfig, boolean lock, @Nullable IValueChangeListener changeListener) {
        SettingEditorHelper.lockSynchronously(setting, clocksConfig, lock, false, false, changeListener);
        UiController.getInstance().setLastlyChangedSetting(setting.getId());
        GuiController.getInstance().runBlocking(m -> {
            clocksConfig.recompute(setting);
            IClocksProfile profile = clocksConfig.getProfile();
            if (profile != null) {
                profile.regenerateCode();
            }
        });
        if (changeListener != null) {
            changeListener.onValueChanged(setting, clocksConfig.getSettingsConfig().getSettingValue(setting));
        }
    }

    public static @NonNull String getValue(@NonNull ISetting setting, @NonNull IClocksConfig clocksConfig) {
        LockState lockState;
        SettingValue selectedValue;
        SettingValue valueToUse = selectedValue = clocksConfig.getSettingsConfig().getSettingValue(setting);
        if (setting.isUserLockable() && (lockState = clocksConfig.getSettingsConfig().getLockState(setting)) != null) {
            valueToUse = lockState.getValue();
        }
        if (setting.getType() == SettingType.FREQUENCY_OUTPUT) {
            return setting.toString(valueToUse);
        }
        return SettingEditorHelper.getUiValueToShow(setting, valueToUse);
    }

    public static @NonNull String getUiValueToShow(@NonNull ISetting setting, @NonNull SettingValue value) {
        return SettingEditorHelper.getUiValueToShow(setting, value.getUiValue());
    }

    private static @NonNull String getUiValueToShow(@NonNull ISetting setting, @NonNull String value) {
        if (setting instanceof PrescalerSetting) {
            return SettingEditorHelper.getReplacedUiValue(value, ZERO_DIVISION, Messages.get().SettingEditorHelper_Disabled);
        }
        return value;
    }

    public static @NonNull String getValueToSet(@NonNull ISetting setting, @NonNull String value) {
        if (setting instanceof PrescalerSetting) {
            return SettingEditorHelper.getReplacedUiValue(value, Messages.get().SettingEditorHelper_Disabled, ZERO_DIVISION);
        }
        return value;
    }

    public static @NonNull String getReplacedUiValue(@NonNull String text, @Nullable String searchedValue, @Nullable String replacePattern) {
        if (Objects.equals(text.trim(), searchedValue)) {
            return UtilsText.safeString((String)replacePattern);
        }
        return text;
    }

    private static void restoreLockState(@NonNull IClocksConfig config, @NonNull ISetting setting, LockState lockState, boolean recompute) {
        if (lockState == null) {
            config.unlockSetting(setting, recompute);
        } else {
            config.lockSetting(setting);
            BigRational accuracy = lockState.getAccuracy();
            if (accuracy != null) {
                config.changeLockAccuracy(setting, accuracy, recompute);
            }
        }
    }

    public static void tryEnableOutput(@NonNull ISetting setting, @NonNull IClocksConfig clocksConfig, @Nullable IValueChangeListener changeListener, boolean isAdvancedResolver) {
        IClockElement clockElement = clocksConfig.getMcu().getClockElement(setting.getElement().getID());
        if (clockElement instanceof ClockOutput) {
            OutputEnabler outputEnabler = new OutputEnabler((ClockOutput)clockElement, (ClocksConfig)clocksConfig);
            String title = Messages.get().AdvancedResolver_DialogTitle;
            Display display = Display.getCurrent();
            Shell activeShell = display.getActiveShell();
            Function<@Nullable IProgressMonitor, Void> runEnabler = monitor -> {
                boolean outputEnabled = outputEnabler.enableOutput(display, (IProgressMonitor)monitor);
                display.asyncExec(() -> {
                    if (!outputEnabled && monitor != null && !monitor.isCanceled() && activeShell != null) {
                        SettingEditorHelper.showEnableOutputClockFailedDialog(setting.getElement().getID(), activeShell, isAdvancedResolver);
                    } else if (changeListener != null) {
                        changeListener.onValueChanged(setting, clocksConfig.getSettingsConfig().getSettingValue(setting));
                    }
                });
                return null;
            };
            if (Rap.isActive()) {
                UIJobHelper.runUIJob(() -> {
                    Object r = runEnabler.apply(null);
                }, (String)title, (boolean)true, (Display)display);
            } else {
                Job job = Job.create((String)title, runEnabler::apply);
                job.setUser(true);
                job.schedule();
            }
        }
    }

    public static @NonNull SettingValueDialog createSettingValueInputDialog(@NonNull ISetting setting, @NonNull IClocksConfig config, @NonNull Shell shell) {
        SettingValueDialog settingValueDialog = SettingValueDialog.getDialogForSetting(shell, setting, MessageFormat.format(Messages.get().SettingsTable_SetValueOfSetting, setting.getName()), String.valueOf(Messages.get().SettingsTable_ValueIsNotValid) + "\n" + setting.getAllowedValueDescription(config));
        return settingValueDialog;
    }

    public static void showEnableOutputClockFailedDialog(@NonNull String outputName, @NonNull Shell shell, boolean isAdvancedResolver) {
        String title = Messages.get().SettingsEditorHelper_EnableOutput_ErrorTitle;
        if (isAdvancedResolver) {
            title = Messages.get().SettingsEditorHelper_AdvancedResolver_ErrorTitle;
        }
        String errorMessage = Messages.get().SettingsEditorHelper_EnableOutput_ErrorMessage;
        MessageDialog.openError((Shell)shell, (String)UtilsText.safeString((String)MessageFormat.format(title, outputName)), (String)UtilsText.safeString((String)MessageFormat.format(errorMessage, outputName)));
    }
}

