/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingsTable;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Connection {
    @NonNull
    static final RGB RAP_TABLE_HEADER_FROM_COLOR = new RGB(249, 249, 249);
    @NonNull
    static final RGB RAP_TABLE_HEADER_TO_COLOR = new RGB(228, 228, 228);
    @NonNull
    Canvas canvas;
    @Nullable
    SettingsTable tableFrom;
    @Nullable
    SettingsTable tableTo;
    int tableLeftOffset;
    int tableRightOffset;

    public Connection(Composite parent, int style) {
        this.canvas = new Canvas(parent, style);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int canvasWidth = Connection.this.canvas.getSize().x;
                int canvasHeight = Connection.this.canvas.getSize().y;
                GC gc = e.gc;
                if (!$assertionsDisabled && gc == null) {
                    throw new AssertionError();
                }
                this.clearBackground(gc, canvasWidth, canvasHeight);
                this.drawOffsetsPolygon(gc, canvasWidth);
                this.prepareGcForDrawing(gc);
                if (Connection.this.tableFrom != null && Connection.this.tableTo != null) {
                    Connection.this.recomputeTablesOffsets();
                    this.drawArrows(gc, canvasWidth, canvasHeight);
                }
            }

            private void drawArrows(@NonNull GC gc, int canvasWidth, int canvasHeight) {
                IClockElement input = GuiController.getInstance().getSourceForActiveOutput();
                Collection<@NonNull IClockElement> outputs = GuiController.getInstance().getAssociatedOutputs();
                if (input != null && !outputs.isEmpty()) {
                    int maxY = 0;
                    int minY = canvasHeight;
                    for (IClockElement outputElement : outputs) {
                        ISetting outputSetting = outputElement.getOutputFrequencySetting();
                        int yRight = this.drawArrow(gc, outputSetting, false);
                        minY = Math.min(minY, yRight);
                        maxY = Math.max(maxY, yRight);
                    }
                    if (input instanceof ClockSource) {
                        ISetting inputSetting = input.getOutputFrequencySetting();
                        int yLeft = this.drawArrow(gc, inputSetting, true);
                        minY = Math.min(minY, yLeft);
                        maxY = Math.max(maxY, yLeft);
                    } else if (outputs.size() == 1) {
                        minY -= 5;
                        maxY += 5;
                    }
                    gc.drawLine(canvasWidth / 2, minY, canvasWidth / 2, maxY);
                }
            }

            private void drawOffsetsPolygon(@NonNull GC gc, int canvasWidth) {
                int headerRight;
                Display canvasDisplay = Connection.this.canvas.getDisplay();
                Color oldBgColor = gc.getBackground();
                Color oldFgColor = gc.getForeground();
                gc.setAntialias(1);
                SettingsTable tableLocal = Connection.this.tableTo;
                int n = headerRight = tableLocal == null ? 0 : tableLocal.getGrid().getHeaderHeight();
                if (Rap.isActive()) {
                    gc.setForeground(new Color((Device)canvasDisplay, RAP_TABLE_HEADER_FROM_COLOR));
                    gc.setBackground(new Color((Device)canvasDisplay, RAP_TABLE_HEADER_TO_COLOR));
                    gc.fillGradientRectangle(0, Connection.this.tableLeftOffset, canvasWidth, headerRight, true);
                } else {
                    gc.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_header_BG"));
                    gc.fillRectangle(0, Connection.this.tableLeftOffset, canvasWidth, headerRight);
                }
                gc.setForeground(oldFgColor);
                gc.setBackground(oldBgColor);
            }

            private void prepareGcForDrawing(@NonNull GC gc) {
                gc.setForeground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_FG"));
                gc.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_FG"));
                gc.setAntialias(1);
                gc.setLineWidth(2);
                gc.setLineCap(2);
            }

            private void clearBackground(@NonNull GC gc, int width, int height) {
                gc.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_list_BG"));
                gc.fillRectangle(0, 0, width, height);
            }

            private int drawArrow(@NonNull GC gc, @NonNull ISetting setting, boolean left) {
                SettingsTable table;
                SettingsTable settingsTable = table = left ? Connection.this.tableFrom : Connection.this.tableTo;
                if (table != null) {
                    int offset = left ? Connection.this.tableLeftOffset : Connection.this.tableRightOffset;
                    int y = table.getCenterY(setting);
                    if (y == Integer.MAX_VALUE) {
                        int bottomY;
                        y = bottomY = table.getLastVisibleBottom() + offset;
                    } else if (y == Integer.MIN_VALUE) {
                        int topFromY;
                        y = topFromY = table.getFirstVisibleTop() + offset;
                    } else if (y != -1) {
                        int canvasWidth = Connection.this.canvas.getSize().x;
                        Connection.fillArrowHead(gc, left ? 2 : canvasWidth - 7, y += offset, 5);
                        gc.drawLine(left ? 6 : canvasWidth - 6, y, canvasWidth / 2, y);
                    }
                    return y;
                }
                return -1;
            }
        });
        this.attachResizeListener();
    }

    private void attachResizeListener() {
        if (Rap.isActive()) {
            this.canvas.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Connection.this.redrawAsync();
                }
            });
        }
    }

    void recomputeTablesOffsets() {
        SettingsTable tableLeft = this.tableFrom;
        SettingsTable tableRight = this.tableTo;
        if (tableLeft != null && tableRight != null) {
            int table1Y = Connection.getRelativeYPosition((Control)tableLeft.getGrid(), new Control[]{tableLeft.getGrid(), tableRight.getGrid(), this.canvas});
            int table2Y = Connection.getRelativeYPosition((Control)tableRight.getGrid(), new Control[]{tableLeft.getGrid(), tableRight.getGrid(), this.canvas});
            int canvasY = Connection.getRelativeYPosition((Control)this.canvas, new Control[]{tableLeft.getGrid(), tableRight.getGrid(), this.canvas});
            this.tableLeftOffset = table1Y - canvasY;
            this.tableRightOffset = table2Y - canvasY;
        }
    }

    static void fillArrowHead(@NonNull GC gc, int startX, int midY, int width) {
        Path path = new Path(gc.getDevice());
        path.moveTo((float)startX, (float)(midY - width));
        path.lineTo((float)(startX + width), (float)midY);
        path.lineTo((float)startX, (float)(midY + width));
        path.close();
        gc.fillPath(path);
        path.dispose();
    }

    static int getRelativeYPosition(@NonNull Control control, Control ... controls) {
        Composite commonPredcessor = Connection.getCommonPredcessor(controls);
        int y = control.getBounds().y;
        Composite predcessor = control.getParent();
        while (predcessor != null && predcessor != commonPredcessor) {
            y += predcessor.getBounds().y;
            predcessor = predcessor.getParent();
        }
        return y;
    }

    private static @NonNull Composite getCommonPredcessor(Control ... controls) {
        if (controls.length == 0) {
            throw new IllegalArgumentException("At least one control is required");
        }
        List<@NonNull Composite> parents = Connection.getParents(controls[0]);
        int i = 1;
        while (i < controls.length) {
            Control control = controls[i];
            Composite predcessor = control.getParent();
            while (predcessor != null && !parents.contains(predcessor)) {
                predcessor = predcessor.getParent();
            }
            parents = parents.subList(parents.indexOf(predcessor), parents.size());
            ++i;
        }
        if (parents.isEmpty()) {
            throw new IllegalArgumentException("Controls do not lie in the same composite");
        }
        return parents.get(0);
    }

    private static @NonNull List<@NonNull Composite> getParents(@NonNull Control control) {
        ArrayList<@NonNull Composite> result = new ArrayList<Composite>();
        Composite predcessor = control.getParent();
        while (predcessor != null) {
            result.add(predcessor);
            predcessor = predcessor.getParent();
        }
        return result;
    }

    public void setTables(@NonNull SettingsTable fromTable, @NonNull SettingsTable toTable) {
        this.tableFrom = fromTable;
        this.tableTo = toTable;
        this.canvas.redraw();
    }

    public void setLayoutData(@NonNull Object layoutData) {
        this.canvas.setLayoutData(layoutData);
    }

    public void redraw() {
        if (!this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void redrawAsync() {
        UIJobHelper.runUIJob(() -> this.redraw(), (String)"Redrawing connection", (boolean)true, (Display)this.canvas.getDisplay());
        this.canvas.redraw();
    }
}

