/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.DependencyContextWrapper;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.utils.ExpressionUtils;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class EnableSetting
extends AGeneralSetting {
    @NonNull
    public static final String ID_SUFFIX = "enable";
    @NonNull
    public static final SettingValue ENABLED_SETTING = new SettingValue((Object)EnableType.ENABLE);
    @NonNull
    private @NonNull List<@NonNull EnableDisableCondition> conditions;
    @Nullable
    private Expression softEnableCondition;
    @Nullable
    private Expression componentEnableCondition;
    @Nullable
    private Expression autoDisableCondition;

    public EnableSetting(@NonNull String name, @NonNull IElement element, @NonNull List<@NonNull EnableDisableCondition> conditions) {
        super(name, SettingType.ENABLE_DISABLE, element);
        this.conditions = new ArrayList<EnableDisableCondition>(conditions);
    }

    public EnableSetting(@NonNull String name, @NonNull IElement element, @NonNull EnableDisableCondition enableDisable) {
        this(name, element, new ArrayList<EnableDisableCondition>());
        this.conditions.add(enableDisable);
    }

    public EnableSetting(@NonNull String name, @NonNull IElement element) {
        this(name, element, new ArrayList<EnableDisableCondition>());
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return true;
    }

    @Override
    protected @NonNull String getIdSuffix() {
        return ID_SUFFIX;
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        return ENABLED_SETTING;
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        return new SettingValue((Object)this.findEnableType(config));
    }

    @Override
    public @Nullable String getDescription() {
        return null;
    }

    @Override
    public @Nullable List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
        return null;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig clocksConfig) {
        return this.getEnableType(clocksConfig).toBoolValue();
    }

    public @NonNull EnableType findEnableType(@NonNull IClocksConfig clocksConfig) {
        Expression softEnableConditionLoc = this.softEnableCondition;
        Expression componentEnableConditionLoc = this.componentEnableCondition;
        Expression autoDisableConditionLoc = this.autoDisableCondition;
        if (this.isUserDisabled(clocksConfig) || this.isDisabledByDefault(clocksConfig) || !this.activeCase(clocksConfig, new HashSet<String>()).isEnabled(clocksConfig) || componentEnableConditionLoc != null && !componentEnableConditionLoc.resolve(new ConfigContext(componentEnableConditionLoc.getContext(), clocksConfig)).getBoolean() || autoDisableConditionLoc != null && autoDisableConditionLoc.resolve(new ConfigContext(autoDisableConditionLoc.getContext(), clocksConfig)).getBoolean()) {
            return EnableType.HARD_DISABLE;
        }
        if (softEnableConditionLoc != null && !softEnableConditionLoc.resolve(new ConfigContext(softEnableConditionLoc.getContext(), clocksConfig)).getBoolean()) {
            return EnableType.SOFT_DISABLE;
        }
        return EnableType.ENABLE;
    }

    public @NonNull EnableType getEnableType(@NonNull IClocksConfig clocksConfig) {
        return (EnableType)((Object)clocksConfig.getSettingsConfig().getSettingValue(this).getValue());
    }

    private boolean isUserDisabled(@NonNull IClocksConfig clocksConfig) {
        if (this.getElement() instanceof IClockElement) {
            IClockElement clockElement = (IClockElement)this.getElement();
            ISetting mainSetting = clockElement.getMainSetting();
            return mainSetting != null && mainSetting.isUserEnableable() && !mainSetting.isUserEnabled(clocksConfig);
        }
        return false;
    }

    private boolean isDisabledByDefault(@NonNull IClocksConfig clocksConfig) {
        if (this.getElement() instanceof IClockElement) {
            IClockElement clockElement = (IClockElement)this.getElement();
            return clocksConfig.isDisabledByDefault(clockElement);
        }
        return false;
    }

    public @NonNull EnableDisableCondition activeCase(@NonNull IClocksConfig clocksConfig, @NonNull Set<@NonNull String> usedSettings) {
        if (!this.conditions.isEmpty()) {
            for (EnableDisableCondition enableDisable : this.conditions) {
                if (!enableDisable.isResolvable(clocksConfig, usedSettings)) continue;
                return enableDisable;
            }
        }
        return EnableDisableCondition.DEFAULT;
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        LinkedHashSet<@NonNull String> usedBitFields = new LinkedHashSet<String>();
        for (EnableDisableCondition condition : this.conditions) {
            usedBitFields.addAll(condition.getUsedBitFields());
        }
        return usedBitFields;
    }

    public @NonNull Collection<@NonNull String> getUsedSettings() {
        LinkedHashSet<@NonNull String> usedSettings = new LinkedHashSet<String>();
        for (EnableDisableCondition condition : this.conditions) {
            usedSettings.addAll(condition.getUsedSettings());
        }
        return usedSettings;
    }

    @Override
    public boolean canRead(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) {
        if (this.softEnableCondition != null && !resolvedSettingIds.containsAll(this.softEnableCondition.getSettings())) {
            return false;
        }
        if (this.componentEnableCondition != null && !resolvedSettingIds.containsAll(this.componentEnableCondition.getSettings())) {
            return false;
        }
        HashSet<@NonNull String> usedSettings = new HashSet<String>();
        EnableDisableCondition activeCase = this.activeCase(config, usedSettings);
        if (!resolvedSettingIds.containsAll(usedSettings)) {
            return false;
        }
        Expression expression = activeCase.getExpression();
        DependencyContextWrapper contextWrapper = ExpressionUtils.getDependencyContextWrapper(expression, config);
        expression.resolve(contextWrapper);
        return resolvedSettingIds.containsAll(contextWrapper.getAllUsedSettings(config));
    }

    @Override
    public @NonNull String toString(@NonNull SettingValue settingValue) {
        return UtilsText.safeString((String)settingValue.getValue().toString());
    }

    @Override
    public @Nullable SettingValue fromString(@NonNull String string, @NonNull IClocksConfig clocksConfig) {
        EnableType bool = EnableType.valueOf(string);
        assert (bool != null);
        return this.parseValue((Object)bool, clocksConfig);
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        return this.getDependencies(mcu, true);
    }

    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu, boolean includeAutoDisableCondition) {
        HashSet<@NonNull String> settings = new HashSet<String>();
        if (includeAutoDisableCondition && this.autoDisableCondition != null) {
            settings.addAll(ExpressionUtils.getRelatedSettingIDs(this.autoDisableCondition, mcu));
        }
        if (this.softEnableCondition != null) {
            settings.addAll(ExpressionUtils.getRelatedSettingIDs(this.softEnableCondition, mcu));
        }
        if (this.componentEnableCondition != null) {
            settings.addAll(ExpressionUtils.getRelatedSettingIDs(this.componentEnableCondition, mcu));
        }
        this.getUsedBitFields().forEach(x -> SettingProvider.addBitFieldSetting(settings, x, mcu));
        this.getUsedSettings().forEach(settings::add);
        return settings;
    }

    @Override
    public @NonNull Collection<@NonNull ISetting> getReadOnlySettings(@NonNull IClocksConfig config) {
        Expression autoDisableConditionLoc;
        Expression componentEnableConditionLoc;
        EnableDisableCondition activeCase = this.activeCase(config, new HashSet<String>());
        HashSet<@NonNull ISetting> readOnly = new HashSet<ISetting>(ExpressionUtils.getRelatedSettings(activeCase.getCaseExpression(), config.getMcu()));
        readOnly.addAll(ExpressionUtils.getRelatedSettings(activeCase.getExpression(), config.getMcu()));
        Expression softEnableConditionLoc = this.softEnableCondition;
        if (softEnableConditionLoc != null) {
            readOnly.addAll(ExpressionUtils.getRelatedSettings(softEnableConditionLoc, config.getMcu()));
        }
        if ((componentEnableConditionLoc = this.componentEnableCondition) != null) {
            readOnly.addAll(ExpressionUtils.getRelatedSettings(componentEnableConditionLoc, config.getMcu()));
        }
        if ((autoDisableConditionLoc = this.autoDisableCondition) != null) {
            readOnly.addAll(ExpressionUtils.getRelatedSettings(autoDisableConditionLoc, config.getMcu()));
        }
        return readOnly;
    }

    public void setSoftEnableCondition(@NonNull Expression softEnableCondition) {
        this.softEnableCondition = softEnableCondition;
    }

    public @Nullable Expression getSoftEnableCondition() {
        return this.softEnableCondition;
    }

    public void setComponentEnableCondition(@NonNull Expression componentEnableCondition) {
        this.componentEnableCondition = componentEnableCondition;
    }

    public @Nullable Expression getAutoDisableCondition() {
        return this.autoDisableCondition;
    }

    public void setAutoDisableCondition(@NonNull Expression autoDisableCondition) {
        this.autoDisableCondition = autoDisableCondition;
    }

    public static enum EnableType {
        HARD_DISABLE(false),
        SOFT_DISABLE(false),
        ENABLE(true),
        OTHER(false);

        private boolean boolValue;

        private EnableType(boolean boolValue) {
            this.boolValue = boolValue;
        }

        public boolean toBoolValue() {
            return this.boolValue;
        }

        public String toString() {
            return Boolean.toString(this.boolValue);
        }
    }
}

