/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AFrequencyModifierSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.util.ArrayList;
import java.util.List;

public class ClockSelectSetting
extends AFrequencyModifierSetting {
    @NonNull
    public static final String ID_SUFFIX = "sel";
    @NonNull
    private ClockSelect clockSelect;

    public ClockSelectSetting(@NonNull ClockSelect clockSelect) {
        super(clockSelect);
        this.clockSelect = clockSelect;
    }

    @Override
    public @NonNull List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
        ArrayList<@NonNull SettingValue> values = new ArrayList<SettingValue>();
        for (String option : this.clockSelect.getOptions(clocksConfig)) {
            boolean available;
            ValueMap activeValueMap = this.clockSelect.getActiveValueMap(clocksConfig);
            if (activeValueMap == null) continue;
            String controlValue = this.clockSelect.getActivatedSignal(option, clocksConfig);
            boolean bl = available = !clocksConfig.getMcu().getNotAvailableElements().contains(controlValue);
            if (controlValue != null && available) {
                values.add(new SettingValue(controlValue, option));
                continue;
            }
            if (available) {
                LOGGER.warning("Bit field value(s) and/or control value not found for: " + this.clockSelect.getID());
                continue;
            }
            if (!SWToolsProperties.isVerificationOn()) continue;
            LOGGER.info(String.valueOf(controlValue) + " not available for: " + this.clockSelect.getID());
        }
        return values;
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        for (SettingValue value : this.getValues(clocksConfig)) {
            if (!value.getUiValue().equals(uiValue)) continue;
            return value;
        }
        return null;
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        for (SettingValue settingValue : this.getValues(clocksConfig)) {
            if (!settingValue.getValue().equals(value)) continue;
            return settingValue;
        }
        return null;
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return this.clockSelect.isValid(clocksConfig);
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        String defaultInputSignal = this.clockSelect.getDefaultUiInputSignal(clockConfig);
        return this.parseUiValue(UtilsText.safeString((String)defaultInputSignal), clockConfig);
    }

    public @NonNull ClockSelect getClockSelect() {
        return this.clockSelect;
    }

    @Override
    protected @NonNull String getIdSuffix() {
        return ID_SUFFIX;
    }

    @Override
    public boolean isUserLockable() {
        return false;
    }

    @Override
    public boolean isLockedByDefault() {
        return true;
    }

    @Override
    public @NonNull String toString(@NonNull SettingValue settingValue) {
        return UtilsText.safeString((String)settingValue.getValue().toString());
    }

    @Override
    public @Nullable SettingValue fromString(@NonNull String string, @NonNull IClocksConfig clocksConfig) {
        SettingValue result = this.parseValue(string, clocksConfig);
        if (result == null) {
            result = SettingValue.N_A;
        }
        return result;
    }

    @Override
    public boolean isPrioritized() {
        return this.clockSelect.isPrioritized();
    }
}

