/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.ErrorHelper;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerModeSpecificElement;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.model.ClockModel;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Pll
extends AClockElement {
    @NonNull
    private final @NonNull List<@NonNull IClockElement> internalElements = new ArrayList<IClockElement>(2);
    @NonNull
    private Prescaler divider;
    @NonNull
    private Prescaler multiplier;
    @Nullable
    private Prescaler postDivider;

    public Pll(@NonNull ClockElementData elementData, @NonNull Prescaler divider, @NonNull Prescaler multiplier, @Nullable Prescaler postDivider) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), elementData.getInputSignal(), elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        EnableSetting dividerEnable;
        super.setPowerModeSpecific(elementData.isPowerModeSpecific);
        this.divider = divider;
        this.multiplier = multiplier;
        this.postDivider = postDivider;
        ENodeType type = null;
        type = postDivider != null ? ENodeType.PLLrev : ENodeType.PLL;
        this.modelDevice = new PllModel(this.id, type);
        this.internalElements.add(divider);
        this.internalElements.add(multiplier);
        EnableSetting pllEnable = new EnableSetting(this.id, (IElement)this, elementData.getEnableDisableConditions());
        this.addNestedSetting(pllEnable);
        divider.getSettings(SettingType.BIT_FIELD, SettingType.FREQUENCY_MODIFIER).forEach(x -> {
            ISetting iSetting = this.settings.put(x.getId(), x);
        });
        multiplier.getSettings(SettingType.BIT_FIELD, SettingType.FREQUENCY_MODIFIER).forEach(x -> {
            ISetting iSetting = this.settings.put(x.getId(), x);
        });
        EnableSetting multiplierEnable = multiplier.getEnableSetting();
        if (multiplierEnable != null) {
            multiplierEnable.setSoftEnableCondition(Expression.create(pllEnable.getId()));
        }
        if ((dividerEnable = divider.getEnableSetting()) != null) {
            dividerEnable.setSoftEnableCondition(Expression.create(pllEnable.getId()));
        }
        ISetting multiplierModifier = multiplier.getSetting(SettingType.FREQUENCY_MODIFIER);
        ISetting dividerModifier = divider.getSetting(SettingType.FREQUENCY_MODIFIER);
        if (postDivider != null) {
            this.internalElements.add(postDivider);
            postDivider.getSettings(SettingType.BIT_FIELD, SettingType.FREQUENCY_MODIFIER).forEach(x -> {
                ISetting iSetting = this.settings.put(x.getId(), x);
            });
        } else if (dividerModifier != null && multiplierModifier != null) {
            dividerModifier.setSynchronousLockers(CollectionsUtils.asList((Object)multiplierModifier));
            multiplierModifier.setSynchronousLockers(CollectionsUtils.asList((Object)dividerModifier));
        }
    }

    @Override
    public String getType() {
        return ElementType.PLL.toString();
    }

    public @NonNull Prescaler getDivider() {
        return this.divider;
    }

    public @NonNull Prescaler getMultiplier() {
        return this.multiplier;
    }

    public @Nullable Prescaler getPostDivider() {
        return this.postDivider;
    }

    @Override
    public @NonNull List<@NonNull IClockElement> getInternalElements() {
        return this.internalElements;
    }

    @Override
    public void updateMinMaxConstraints(@NonNull List<@NonNull Constraint> applicableConstraints, @NonNull Node compNode) {
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        Node compNode;
        SettingsConfig settingsConfig = config.getSettingsConfig();
        ISetting dividerSetting = this.getDivider().getFrequencyModifierSetting();
        ISetting multiplySetting = this.getMultiplier().getFrequencyModifierSetting();
        ISetting postDividerSetting = null;
        Prescaler postDividerLoc = this.getPostDivider();
        if (postDividerLoc != null) {
            postDividerSetting = postDividerLoc.getFrequencyModifierSetting();
        }
        if ((compNode = this.getComputationNode(config)) != null) {
            compNode.clean();
            boolean frequencySaved = this.saveOutputFrequency(config, compNode, lockedOnly, false);
            if (!(frequencySaved || this.getDivider().isEnabledForModel(config) && this.getMultiplier().isEnabledForModel(config))) {
                compNode.disable();
            }
            compNode.setFraction(this.multiplier.getFraction(config));
            this.updateTiming(config, compNode);
            if (dividerSetting != null && multiplySetting != null && !frequencySaved) {
                SettingValue dividerSettingValue = settingsConfig.getSettingValue(dividerSetting);
                if (dividerSettingValue == SettingValue.N_A) {
                    dividerSettingValue = dividerSetting.getDefaultValue(config);
                    assert (dividerSettingValue != null);
                }
                String strDividerSettingVal = dividerSettingValue.getValue().toString();
                assert (strDividerSettingVal != null);
                BigRational currentDivider = new BigRational(strDividerSettingVal);
                SettingValue multiplySettingValue = settingsConfig.getSettingValue(multiplySetting);
                if (multiplySettingValue == SettingValue.N_A) {
                    multiplySettingValue = multiplySetting.getDefaultValue(config);
                    assert (multiplySettingValue != null);
                }
                String strMultiplySettingVal = multiplySettingValue.getValue().toString();
                assert (strMultiplySettingVal != null);
                BigRational currentMultiplier = BigRational.tryParse((String)strMultiplySettingVal);
                compNode.setDefaultMultiplierDivider(currentMultiplier, currentDivider);
                if (postDividerSetting != null) {
                    SettingValue postDividerSettingValue = settingsConfig.getSettingValue(postDividerSetting);
                    if (postDividerSettingValue == SettingValue.N_A) {
                        postDividerSettingValue = postDividerSetting.getDefaultValue(config);
                        assert (postDividerSettingValue != null);
                    }
                    String strPostDividerSettingVal = postDividerSettingValue.getValue().toString();
                    assert (strPostDividerSettingVal != null);
                    BigRational currentPostDivider = new BigRational(strPostDividerSettingVal);
                    BigRational postDividerToSet = null;
                    LockState postDividerLockState = settingsConfig.getLockState(postDividerSetting);
                    if (!lockedOnly || postDividerLockState != null) {
                        BigRational bigRational = postDividerToSet = postDividerLockState == null ? currentPostDivider : new BigRational(Integer.parseInt(postDividerLockState.getValue().getValue().toString()));
                        assert (postDividerToSet != null);
                        compNode.setPostDivider(postDividerToSet);
                    }
                }
                BigRational dividerToSet = null;
                LockState dividerLockState = settingsConfig.getLockState(dividerSetting);
                if (!lockedOnly || dividerLockState != null) {
                    dividerToSet = dividerLockState == null ? currentDivider : new BigRational(Integer.parseInt(dividerLockState.getValue().getValue().toString()));
                }
                BigRational multiplierToSet = null;
                LockState multiplierLockState = settingsConfig.getLockState(multiplySetting);
                if (!lockedOnly || multiplierLockState != null) {
                    BigRational bigRational = multiplierToSet = multiplierLockState == null ? currentMultiplier : BigRational.tryParse((String)multiplierLockState.getValue().getValue().toString());
                }
                if (postDividerSetting != null && lockedOnly) {
                    compNode.setJustMultiplier(multiplierToSet);
                } else {
                    compNode.setMultiplierDivider(multiplierToSet, dividerToSet);
                }
                if (multiplierToSet != null) {
                    multiplySetting.parseUiValue(multiplierToSet.toString(), config);
                }
            } else if (frequencySaved && lockedOnly) {
                compNode.setDefaultMultiplierDivider(null, null);
            }
        }
    }

    private void updateTiming(@NonNull IClocksConfig config, @NonNull Node compNode) {
        ModelCreationI.ScaleData multiplierData = this.multiplier.createScaleData(config);
        ModelCreationI.ScaleData dividerData = this.divider.createScaleData(config);
        TimingScale multiplierTiming = ClockModel.makeTimingScale((ModelCreationI.ScaleData)multiplierData);
        TimingScale dividerTiming = ClockModel.makeTimingScale((ModelCreationI.ScaleData)dividerData);
        TimingScale multiplicativeScale = compNode.getMultiplicativeScale();
        TimingScale divisionScale = compNode.getDivisionScale();
        assert (multiplicativeScale != null);
        assert (divisionScale != null);
        if (!multiplicativeScale.equals((Object)multiplierTiming) || !divisionScale.equals((Object)dividerTiming)) {
            compNode.setMulDivTimingScale(multiplierTiming, dividerTiming);
        }
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
        ISetting dividerSetting = this.getDivider().getFrequencyModifierSetting();
        ISetting multiplySetting = this.getMultiplier().getFrequencyModifierSetting();
        Prescaler postDiv = this.getPostDivider();
        ISetting postDividerSetting = null;
        if (postDiv != null) {
            postDividerSetting = postDiv.getFrequencyModifierSetting();
        }
        assert (dividerSetting != null && multiplySetting != null);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            BigRational multiplierScale = compNode.getMultiplier();
            BigRational dividerScale = compNode.getDivider();
            SettingValue value = null;
            if (multiplierScale != null) {
                value = multiplySetting.parseValue(multiplierScale.toExactDecimalString(4), config);
                if (value == null) {
                    value = SettingValue.N_A;
                }
                config.setSettingValue(multiplySetting, value, false, false);
            } else {
                LOGGER.warning("Not valid multiply loaded for element: " + this.id);
            }
            value = null;
            if (dividerScale != null) {
                value = dividerSetting.parseValue(dividerScale, config);
                if (value == null) {
                    value = SettingValue.N_A;
                }
                config.setSettingValue(dividerSetting, value, false, false);
            } else {
                LOGGER.warning("Not valid scale loaded for element: " + this.id);
            }
            SettingValue pllOutputValue = config.getSettingsConfig().getSettingValue(this.getOutputFrequencySetting());
            config.setSettingValue(this.multiplier.getOutputFrequencySetting(), pllOutputValue, false, false);
            SettingValue internalOutputValue = SettingValue.FREQ_N_A;
            BigRational plLdivClock = compNode.getPLLdivClock();
            if (plLdivClock != null) {
                Frequency internalFrequency = Converter.toFrequency(plLdivClock);
                internalOutputValue = this.divider.getOutputFrequencySetting().parseValue(internalFrequency, config);
                if (internalOutputValue != null) {
                    config.setSettingValue(this.divider.getOutputFrequencySetting(), internalOutputValue, false, false);
                }
            }
            if (postDividerSetting != null) {
                BigRational postDividerScale = compNode.getPostDivider();
                value = postDividerSetting.parseValue(postDividerScale, config);
                if (value == null) {
                    value = SettingValue.N_A;
                }
                config.setSettingValue(postDividerSetting, value, false, false);
                config.getSettingsConfig().addNonEditableSetting(dividerSetting);
                config.getSettingsConfig().addNonEditableSetting(postDividerSetting);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void addFrequencyError(boolean isOnInput, @NonNull Map<@NonNull String, @NonNull String> errors, @NonNull Node device, @NonNull IClocksConfig config) {
        boolean internalDivError = device.getInternalDivError();
        Frequency min = Pll.getFrequencyFromDevice(device, isOnInput, internalDivError, true);
        Frequency max = Pll.getFrequencyFromDevice(device, isOnInput, internalDivError, false);
        @NonNull List ranges = isOnInput ? device.getInputFrequencyRanges() : device.getOutputFrequencyRanges();
        String message = "";
        if (isOnInput || !internalDivError) {
            message = ErrorHelper.extractFrequencyErrorMessage(isOnInput, min, max, null);
        } else {
            String maxText;
            String minText = min == null ? null : FrequencyCalculator.normalize((Frequency)min, (long)1L).toString();
            String string = maxText = max == null ? null : FrequencyCalculator.normalize((Frequency)max, (long)1L).toString();
            if (minText != null && maxText != null) {
                message = minText.equals(maxText) ? MessageFormat.format(Messages.get().Pll_InternalFrequencyMustBeEqualTo, this.divider.getName(), this.multiplier.getName(), minText) : MessageFormat.format(Messages.get().Pll_InternalFrequencyMustBeInRange, this.divider.getName(), this.multiplier.getName(), minText, maxText);
            } else if (minText != null) {
                message = MessageFormat.format(Messages.get().Pll_InternalFrequencyMustBeGreqterThanOrEqualTo, this.divider.getName(), this.multiplier.getName(), minText);
            } else if (maxText != null) {
                message = MessageFormat.format(Messages.get().Pll_InternalFrequencyMustBeLessThanOrEqualTo, this.divider.getName(), this.multiplier.getName(), maxText);
            }
        }
        if (message != null) {
            Frequency minHz = FrequencyCalculator.toHertz((Frequency)(min != null ? min : Frequency.ZERO));
            Frequency maxHz = FrequencyCalculator.toHertz((Frequency)(max != null ? max : Frequency.ZERO));
            List<@NonNull Constraint> activeConstraints = this.getAllApplicableConstraints(config);
            int thisErrorIndex = Pll.getConstraintIndex(activeConstraints, minHz.getValue(), maxHz.getValue(), config, ranges);
            message = this.appendSeeConstraintsToMessage(message, thisErrorIndex, null);
            ErrorHelper.addErrorIfNotPresent(this.getID(), message, errors);
        } else {
            LOGGER.warning("Error on frequency constraint of PLL, but can not find out which");
        }
        this.addErrorToInteralElements(isOnInput, internalDivError, min, max, errors);
    }

    @Override
    public void addDivisionError(EDividerError errorType, @NonNull Map<@NonNull String, @NonNull String> errors, @NonNull IMcu mcu, @NonNull Node device, @NonNull IClocksConfig config) {
        Prescaler erroneousElement = device.getInternalDivError() ? this.divider : this.multiplier;
        String message = UtilsText.safeString((String)MessageFormat.format(Messages.get().Pll_ScaleValueOfNotAlloved, erroneousElement.getID()));
        ErrorHelper.addErrorIfNotPresent(this.getID(), message, errors);
        erroneousElement.addDivisionError(errorType, errors, mcu, device, config);
    }

    protected void addErrorToInteralElements(boolean input, boolean internalDiv, @Nullable Frequency min, @Nullable Frequency max, @NonNull Map<@NonNull String, @NonNull String> errors) {
        Prescaler internalElement = input || internalDiv ? (this.postDivider != null ? this.postDivider : this.divider) : this.multiplier;
        String message = ErrorHelper.extractFrequencyErrorMessage(input, min, max, null);
        if (message != null) {
            ErrorHelper.addErrorIfNotPresent(internalElement.getID(), message, errors);
        }
    }

    private static @Nullable Frequency getFrequencyFromDevice(@NonNull Node device, boolean input, boolean internalDiv, boolean min) {
        BigRational rational = input ? (min ? device.getMinInputFreq() : device.getMaxInputFreq()) : (!internalDiv ? (min ? device.getMinOutputFreq() : device.getMaxOutputFreq()) : (min ? device.getPLLMinDividerOutput() : device.getPLLMaxDividerOutput()));
        return rational == null ? null : Converter.toFrequency(rational);
    }

    @Override
    public void configureModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        super.configureModel(config, lockedOnly);
        Node computationNodeLoc = this.getComputationNode(config);
        Node multiplierCompNodeLoc = this.getMultiplier().getComputationNode(config);
        Node dividerCompNodeLoc = this.getDivider().getComputationNode(config);
        if (computationNodeLoc != null) {
            this.setPllFrequencyConstraints(config, computationNodeLoc);
            if (multiplierCompNodeLoc != null && dividerCompNodeLoc != null) {
                if (this.isEnabledForModel(config)) {
                    multiplierCompNodeLoc.enable();
                    dividerCompNodeLoc.enable();
                } else {
                    multiplierCompNodeLoc.disable();
                    dividerCompNodeLoc.disable();
                }
            }
        }
    }

    private void setPllFrequencyConstraints(@NonNull IClocksConfig config, @NonNull Node compNode) {
        Prescaler postDividerLoc = this.postDivider;
        BigRational multiply = new BigRational(compNode.getMultiplier());
        BigRational divide = new BigRational(compNode.getDivider());
        List<@NonNull Constraint> dividerConstraints = this.getDivider().getValidApplicableConstraints(config, divide);
        List<@NonNull Constraint> multiplierConstraints = this.getMultiplier().getValidApplicableConstraints(config, multiply);
        ArrayList<@NonNull Constraint> middleConstraints = new ArrayList<Constraint>();
        if (postDividerLoc != null) {
            BigRational postDivide = new BigRational(compNode.getPostDivider());
            List<@NonNull Constraint> postDivConstraints = postDividerLoc.getValidApplicableConstraints(config, postDivide);
            middleConstraints.addAll(postDivConstraints);
        } else {
            multiplierConstraints.stream().filter(Constraint::isOnInput).forEach(x -> {
                boolean bl = middleConstraints.add((Constraint)x);
            });
            dividerConstraints.stream().filter(x -> !x.isOnInput()).forEach(x -> {
                boolean bl = middleConstraints.add((Constraint)x);
            });
        }
        compNode.setMinDividerFreq(Pll.calculateMinFrequency(middleConstraints));
        compNode.setMaxDividerFreq(Pll.calculateMaxFrequency(middleConstraints));
        compNode.setMinInputFreq(Pll.calculateMinFrequency((List)dividerConstraints.stream().filter(Constraint::isOnInput).collect(CollectorsUtils.toList())));
        compNode.setMaxInputFreq(Pll.calculateMaxFrequency((List)dividerConstraints.stream().filter(Constraint::isOnInput).collect(CollectorsUtils.toList())));
        compNode.setMinOutputFreq(Pll.calculateMinFrequency((List)multiplierConstraints.stream().filter(x -> !x.isOnInput()).collect(CollectorsUtils.toList())));
        compNode.setMaxOutputFreq(Pll.calculateMaxFrequency((List)multiplierConstraints.stream().filter(x -> !x.isOnInput()).collect(CollectorsUtils.toList())));
    }

    @Override
    public void configureConfig(@NonNull IClocksConfig config) {
        super.configureConfig(config);
        if (this.isEnabledForModel(config)) {
            config.setEnabledByDefault(this.multiplier);
            config.setEnabledByDefault(this.divider);
        } else {
            config.setDisabledByDefault(this.multiplier);
            config.setDisabledByDefault(this.divider);
        }
    }

    @Override
    protected @NonNull PowerModeSpecificElement createPowerModeSpecific() {
        return new PowerModeSpecificElement(() -> null, () -> {
            ArrayList<@NonNull IClockElement> allConfigElements = new ArrayList<IClockElement>(this.configElements);
            allConfigElements.addAll(this.internalElements);
            return allConfigElements;
        });
    }

    private class PllModel
    extends AClockModelCreationElement {
        public PllModel(@NonNull String id, ENodeType type) {
            super(id, type);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ModelCreationI.ScaleData getPostDivider() {
            Prescaler postDiv = Pll.this.getPostDivider();
            if (postDiv != null) {
                return postDiv.getDevice().getScaleData();
            }
            throw UNSUPPORTED;
        }

        @Override
        public ModelCreationI.ScaleData getXLLDivider() {
            return Pll.this.getDivider().getDevice().getScaleData();
        }

        @Override
        public ModelCreationI.ScaleData getXLLMultiplier() {
            return Pll.this.getMultiplier().getDevice().getScaleData();
        }

        @Override
        public BigRational getDefaultDiv() {
            return new BigRational(Pll.this.getDivider().getDevice().getDefaultScale());
        }

        @Override
        public BigRational getDefaultMul() {
            return new BigRational(Pll.this.getMultiplier().getDevice().getDefaultScale());
        }

        @Override
        public BigRational getDivMinOutput() {
            return Pll.this.getDivider().getDevice().getMinOutput();
        }

        @Override
        public BigRational getDivMaxOutput() {
            return Pll.this.getDivider().getDevice().getMaxOutput();
        }

        @Override
        public @Nullable BigRational getMinOutput() {
            return Pll.this.getMultiplier().getDevice().getMinOutput();
        }

        @Override
        public @Nullable BigRational getMaxOutput() {
            return Pll.this.getMultiplier().getDevice().getMaxOutput();
        }

        @Override
        public @NonNull BigRational getDefaultPostDivider() {
            Prescaler locPostDivider = Pll.this.getPostDivider();
            if (locPostDivider == null) {
                throw UNSUPPORTED;
            }
            BigRational defaultValue = locPostDivider.getDevice().getDefaultScale();
            return defaultValue == null ? BigRational.ZERO : defaultValue;
        }
    }
}

