/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.controller;

import com.nxp.s32ds.tad.common.ReadingException;
import com.nxp.s32ds.tad.common.controller.TadFactoryData;
import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.model.readers.MemoryReader;
import com.nxp.s32ds.tad.common.model.readers.VariableReader;
import com.nxp.s32ds.tad.common.model.view.generic.TadValue;
import java.util.List;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.debug.core.DebugException;

public abstract class TadFactory {
    public static final int VARIABLE_NOT_EXISTS = -1;
    protected TadModel tadModel;
    protected MemoryReader memoryReader;
    protected VariableReader variableReader;

    public TadFactory(TadModel tadModel, MemoryReader memoryReader, VariableReader variableReader) {
        this.tadModel = tadModel;
        this.memoryReader = memoryReader;
        this.variableReader = variableReader;
    }

    public abstract TadFactoryData getData();

    public synchronized void setContext(IRunControl.IExecutionDMContext context) {
        this.variableReader.setContext(context);
        this.memoryReader.setContext(context);
    }

    public void setReadTimeout(int readTimeout) {
        this.variableReader.setReadTimeout(readTimeout);
        this.memoryReader.setReadTimeout(readTimeout);
    }

    public synchronized long getStructSize(String structName) throws ReadingException {
        String text = this.variableReader.getStructSize(structName);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", structName));
    }

    public synchronized long getSize(String name) throws ReadingException {
        String text = this.variableReader.getSize(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    public synchronized long readAddressAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getAddressAtAddress(address, structName, memberName);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized long readLongAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getValueAtAddress(address, structName, memberName, false);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized TadValue readLongAndContextAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getValueAtAddress(address, structName, memberName, true);
        if (TadFactory.isTextValid(text)) {
            return new TadValue(text);
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized String readTextAtAddress(long address) throws ReadingException {
        StringBuilder builder = new StringBuilder();
        for (int c : this.readMemoryUntilZero(address)) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    public synchronized int readIntAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getValueAtAddress(address, structName, memberName, false);
        if (TadFactory.isTextValid(text)) {
            try {
                return Integer.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized long readAddressOfVariable(String name) throws ReadingException {
        String text = this.variableReader.getAddressOfVariable(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    public synchronized long readLongVariable(String name) throws ReadingException {
        String text = this.variableReader.getVariable(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    public synchronized int readIntVariable(String name) throws ReadingException {
        String text = this.variableReader.getVariable(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Integer.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    protected synchronized long getOffset(String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getOffset(structName, memberName);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s, %s", structName, memberName));
    }

    public abstract String readTaskName(long var1) throws ReadingException;

    public synchronized List<Integer> readMemoryBlock(long address, long length) throws ReadingException {
        try {
            return this.memoryReader.getMemoryBlock(address, length);
        }
        catch (DebugException debugException) {
            throw new ReadingException(String.format("0x%08x, %d", address, length));
        }
    }

    public synchronized List<Long> readMemoryBlock(long address, long length, int bytes) throws ReadingException {
        try {
            return this.memoryReader.getMemoryBlock(address, length, bytes);
        }
        catch (DebugException debugException) {
            throw new ReadingException(String.format("0x%08x, %d, 0x%x", address, length, bytes));
        }
    }

    private synchronized List<Integer> readMemoryUntilZero(long address) throws ReadingException {
        try {
            return this.memoryReader.readMemoryUntilZero(address);
        }
        catch (DebugException debugException) {
            throw new ReadingException(String.format("0x%08x", address));
        }
    }

    public static boolean isTextValid(String text) {
        return text != null && text.trim().length() != 0;
    }

    public synchronized int readIntVariableSafely(String name) {
        try {
            return this.readIntVariable(name);
        }
        catch (ReadingException readingException) {
            this.tadModel.getLogger().error(String.format(Messages.Error_ReadSafely, "readIntVariableSafely", name));
            return -1;
        }
    }

    public synchronized long readLongVariableSafely(String name) {
        try {
            return this.readLongVariable(name);
        }
        catch (ReadingException readingException) {
            this.tadModel.getLogger().error(String.format(Messages.Error_ReadSafely, "readLongVariableSafely", name));
            return -1L;
        }
    }

    public synchronized long readAddressOfVariableSafely(String name) {
        try {
            return this.readAddressOfVariable(name);
        }
        catch (ReadingException readingException) {
            this.tadModel.getLogger().error(String.format(Messages.Error_ReadSafely, "readAddressOfVariableSafely", name));
            return -1L;
        }
    }

    public synchronized int readIntAtAddressSafely(long address, String structName, String memberName) throws ReadingException {
        try {
            return this.readIntAtAddress(address, structName, memberName);
        }
        catch (ReadingException readingException) {
            this.tadModel.getLogger().error(String.format(Messages.Error_ReadSafely, "readIntAtAddressSafely", String.format("0x%08x, %s.%s", address, structName, memberName)));
            return -1;
        }
    }

    public synchronized long readLongAtAddressSafely(long address, String structName, String memberName) {
        try {
            return this.readLongAtAddress(address, structName, memberName);
        }
        catch (ReadingException readingException) {
            this.tadModel.getLogger().error(String.format(Messages.Error_ReadSafely, "readLongAtAddressSafely", String.format("0x%08x, %s.%s", address, structName, memberName)));
            return -1L;
        }
    }
}

