/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.providers;

import com.nxp.s32ds.cle.uct.exceptions.SDKException;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerType;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreType;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.manifest.xml.PackageType;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainEnum;
import com.nxp.s32ds.cle.uct.providers.OptionValueHolder;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SDKManifestFilter {
    public static final String PATTERN_START = "$|";
    private static final String DEVICE_NAME_KEY = "$|device|";
    private static final String DEVICE_FULL_NAME_KEY = "$|device_full_name|";
    private static final String DEVICE_CATEGORY_KEY = "$|device_category|";
    private static final String DEVICE_BRIEF_KEY = "$|device_brief|";
    private static final String PACKAGE_KEY = "$|package|";
    private static final String CORE_KEY = "$|core|";
    private static final String CORE_NAME_KEY = "$|core_name|";
    private static final String CORE_TYPE_KEY = "$|core_type|";
    private static final String TOOLCHAIN_KEY = "$|toolchain|";
    private static final String COMPILER_KEY = "$|compiler|";
    private String[] PATTERNS = new String[]{"$|compiler|", "$|core|", "$|core_name|", "$|core_type|", "$|device|", "$|device_full_name|", "$|device_category|", "$|device_brief|", "$|package|", "$|toolchain|"};
    private static final String QUOTE = "\"";
    private DeviceType device;
    private CompilerEnum compiler = CompilerEnum.GCC;
    private String pkg;
    private String core;
    private String coreName;
    private ToolchainEnum toolchain = ToolchainEnum.ARMGCC;
    public static SDKManifestFilter EMPTY;
    private static final Logger LOGGER;

    static {
        LOGGER = LogManager.getLogger(SDKManifestFilter.class);
        try {
            EMPTY = new SDKManifestFilter(null, null, null, null);
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public SDKManifestFilter(DeviceType device, String pkg, CoreType core, CompilerType compiler) throws SDKException {
        this.device = device;
        this.pkg = pkg;
        if (core != null) {
            this.core = core.getType().value().toString();
            this.coreName = core.getName();
        } else if (core == null && device != null) {
            CoreEnum coreType = device.getCore().get(0).getType();
            if (coreType != null) {
                this.core = coreType.value().toString();
            } else {
                LOGGER.log(Level.SEVERE, String.format("The core type is missing in the manifest file for %s device.", device.getId()));
                this.core = "";
            }
            this.coreName = device.getCore().get(0).getName();
        }
        boolean supported = false;
        if (device != null) {
            for (PackageType p : device.getPackage()) {
                if (!p.getName().equals(pkg)) continue;
                supported = true;
            }
        }
        if (!supported && pkg != null && device != null) {
            throw new SDKException("Unsupported package " + pkg + " for device " + device.getFullName());
        }
        if (compiler != null) {
            this.compiler = compiler.getType();
        }
    }

    public String adapt(String path, String mask) {
        String adapt = String.valueOf(path) + (path.length() != 0 && mask.length() != 0 ? File.separator : "") + mask;
        if (this.compiler != null) {
            adapt = SDKManifestFilter.replaceKeyword(adapt, COMPILER_KEY, this.compiler.toString());
        }
        if (this.toolchain != null) {
            adapt = SDKManifestFilter.replaceKeyword(adapt, TOOLCHAIN_KEY, this.toolchain.toString());
        }
        adapt = SDKManifestFilter.replaceKeyword(adapt, CORE_KEY, this.core);
        adapt = SDKManifestFilter.replaceKeyword(adapt, CORE_TYPE_KEY, this.core);
        adapt = SDKManifestFilter.replaceKeyword(adapt, CORE_NAME_KEY, this.coreName);
        adapt = SDKManifestFilter.replaceKeyword(adapt, PACKAGE_KEY, this.pkg);
        if (this.device != null) {
            adapt = SDKManifestFilter.replaceKeyword(adapt, DEVICE_NAME_KEY, this.device.getName());
            adapt = SDKManifestFilter.replaceKeyword(adapt, DEVICE_FULL_NAME_KEY, this.device.getFullName());
            adapt = SDKManifestFilter.replaceKeyword(adapt, DEVICE_CATEGORY_KEY, this.device.getCategory());
            adapt = SDKManifestFilter.replaceKeyword(adapt, DEVICE_BRIEF_KEY, this.device.getBrief());
        }
        String string = adapt.replace("\\", File.separator);
        return string.replace("//", File.separator).replace("/", File.separator);
    }

    public String basePath(String path) {
        String basePath = this.adapt(path, "");
        if (basePath.equals(".")) {
            basePath = "";
        } else if (basePath.contains(".zip") || basePath.contains(".xml")) {
            int index = basePath.lastIndexOf(File.separator);
            basePath = basePath.substring(0, index);
        }
        return basePath;
    }

    private static String replaceKeyword(String target, String keyword, String replacement) {
        if (replacement != null) {
            return target.replace(keyword, replacement);
        }
        return target;
    }

    public static boolean match(String name, String pattern) {
        if (pattern.contains("*") || pattern.contains("?")) {
            pattern = pattern.replaceAll("\\\\", "\\\\\\\\");
            pattern = pattern.replace(".", "\\.").replace("?", ".?").replace("*", ".*?").replace(":", "\\:").replace("|", "\\|");
            pattern = pattern.toLowerCase();
            name = name.toLowerCase();
            Pattern p = Pattern.compile(String.valueOf(pattern) + "$");
            Matcher matcher = p.matcher(name);
            return matcher.find();
        }
        int index = name.lastIndexOf("/");
        if (index == -1) {
            index = name.lastIndexOf("\\");
        }
        if (index != -1 && index != name.length() - 1 && !pattern.contains("\\") && !pattern.contains("/")) {
            return name.substring(index + 1).equals(pattern);
        }
        return name.endsWith(pattern);
    }

    public void adaptOptions(Map<String, OptionValueHolder> options) {
        Set<String> keys = options.keySet();
        Iterator<String> it = keys.iterator();
        LinkedHashSet<String> adapted = new LinkedHashSet<String>();
        while (it.hasNext()) {
            String key = it.next();
            OptionValueHolder holder = options.get(key);
            Set<String> configs = holder.getConfigs();
            for (String config : configs) {
                String entry;
                Set<String> optionSet = holder.getValues(config);
                adapted.clear();
                ArrayList<String> toRemove = new ArrayList<String>();
                ArrayList<String> regexList = new ArrayList<String>();
                Iterator<String> entries = optionSet.iterator();
                while (entries.hasNext()) {
                    entry = entries.next().toString();
                    if (!entry.contains(PATTERN_START)) continue;
                    String regex = this.buildRegex(entry);
                    regexList.add(regex);
                }
                entries = optionSet.iterator();
                while (entries.hasNext()) {
                    boolean doRegex = true;
                    doRegex = true;
                    String entry2 = entries.next().toString();
                    for (PackageType pkg : this.device.getPackage()) {
                        if (!entry2.equals("CPU_" + pkg.getId()) || pkg.getId().equals(this.pkg)) continue;
                        toRemove.add(entry2);
                        doRegex = false;
                    }
                    if (!doRegex) continue;
                    for (String regex : regexList) {
                        if (entry2.contains(PATTERN_START) || !Pattern.matches(regex, entry2)) continue;
                        toRemove.add(entry2);
                    }
                }
                optionSet.removeAll(toRemove);
                entries = optionSet.iterator();
                while (entries.hasNext()) {
                    entry = entries.next().toString();
                    if (entry.startsWith(QUOTE) && entry.endsWith(QUOTE)) {
                        entry = entry.replace(QUOTE, "");
                    }
                    String adaptedValue = this.adapt(entry, "");
                    adapted.add(adaptedValue);
                }
                optionSet.clear();
                optionSet.addAll(adapted);
            }
        }
    }

    private String buildRegex(String entry) {
        String regex = entry;
        String[] stringArray = this.PATTERNS;
        int n = this.PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            regex = regex.replace(pattern, "[0-9a-zA-Z]+");
            ++n2;
        }
        return regex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.compiler != null) {
            buffer.append("compiler=" + this.compiler.value());
        }
        if (this.toolchain != null) {
            buffer.append(" toolchain=" + this.toolchain.value());
        }
        if (this.pkg != null) {
            buffer.append(" pkg=" + this.pkg);
        }
        if (this.device != null) {
            buffer.append(" device=" + this.device.getName());
        }
        if (this.core != null) {
            buffer.append(" core=" + this.core);
        }
        if (this.coreName != null) {
            buffer.append(" coreName=" + this.coreName);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

