/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.core;

import com.nxp.s32ds.cle.uct.core.UctDescriptor;
import java.util.ArrayList;
import java.util.List;

public class UctDescriptors {
    private static List<UctDescriptor> descriptors = new ArrayList<UctDescriptor>();

    public static void addUctDescriptor(UctDescriptor descriptor) {
        if (!descriptors.contains(descriptor)) {
            descriptors.add(descriptor);
        }
    }

    public static void removeUctDescriptor(UctDescriptor descriptor) {
        if (descriptors.contains(descriptor)) {
            descriptors.remove(descriptor);
        }
    }

    public static boolean checkRestrictionByDeviceCore(String deviceId, String coreId) {
        for (UctDescriptor descriptor : descriptors) {
            if (!descriptor.getDeviceId().equals(deviceId) || !descriptor.getCoreId().equals(coreId)) continue;
            return descriptor.isRestrictBySdk();
        }
        return false;
    }

    public static String getTemplatePathByDeviceCore(String deviceId, String coreId) {
        for (UctDescriptor descriptor : descriptors) {
            if (!descriptor.getDeviceId().equals(deviceId) || !descriptor.getCoreId().equals(coreId)) continue;
            return descriptor.getTemplatePath();
        }
        return "";
    }

    public static String getTemplatePathByDeviceCoreSdkId(String deviceId, String coreId, String sdkId) {
        for (UctDescriptor descriptor : descriptors) {
            if (deviceId == null || coreId == null || sdkId == null || !deviceId.equals(descriptor.getDeviceId()) || !coreId.equals(descriptor.getCoreId()) || !sdkId.equals(descriptor.getSdkId())) continue;
            return descriptor.getTemplatePath();
        }
        return "";
    }
}

