/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.launch.ui;

import com.nxp.s32ds.ext.ide.internal.launch.ui.DebugUiInternals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.actions.OpenLaunchDialogAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class LaunchContributionItem
extends ContributionItem {
    private final String mode;
    private ILaunchGroup defaultGroup = null;
    private Map<String, ILaunchGroup> groupsByCategory = null;

    protected LaunchContributionItem(String mode) {
        this.mode = mode;
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        this.groupsByCategory = new HashMap<String, ILaunchGroup>(3);
        int i = 0;
        while (i < groups.length) {
            ILaunchGroup group = groups[i];
            if (group.getMode().equals(mode)) {
                if (group.getCategory() == null) {
                    this.defaultGroup = group;
                } else {
                    this.groupsByCategory.put(group.getCategory(), group);
                }
            }
            ++i;
        }
    }

    public void fill(Menu menu, int index) {
        ISelection current;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (current = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            ActionContributionItem item;
            IStructuredSelection structured = (IStructuredSelection)current;
            int accelerator = 1;
            List<ILaunchConfiguration> extracted = this.extractSharedConfigurations(structured.toArray());
            for (ILaunchConfiguration configuration : extracted) {
                IAction iAction = DebugUiInternals.createConfigurationAction(configuration, this.mode, accelerator);
                if (iAction == null) continue;
                ++accelerator;
                item = new ActionContributionItem(iAction);
                item.fill(menu, -1);
            }
            Map<IAction, String> shortcutActions = DebugUiInternals.createShortcutActions(structured, this.mode, accelerator);
            if (menu.getItemCount() > 0 && shortcutActions.size() > 0) {
                LaunchContributionItem.addSepparator(menu);
            }
            ArrayList<String> categories = new ArrayList<String>();
            for (Map.Entry entry : shortcutActions.entrySet()) {
                String category = (String)entry.getValue();
                if (category != null && !categories.contains(category)) {
                    categories.add(category);
                }
                ActionContributionItem item2 = new ActionContributionItem((IAction)entry.getKey());
                item2.fill(menu, -1);
            }
            if (categories.isEmpty()) {
                if (this.defaultGroup != null) {
                    if (accelerator > 1) {
                        LaunchContributionItem.addSepparator(menu);
                    }
                    OpenLaunchDialogAction openLaunchDialogAction = new OpenLaunchDialogAction(this.defaultGroup.getIdentifier());
                    item = new ActionContributionItem((IAction)openLaunchDialogAction);
                    item.fill(menu, -1);
                }
            } else {
                boolean bl = false;
                for (String category : categories) {
                    boolean bl2;
                    ILaunchGroup group = this.defaultGroup;
                    if (category != null) {
                        group = this.groupsByCategory.get(category);
                    }
                    if (group == null) continue;
                    if (accelerator > 1 && !bl2) {
                        LaunchContributionItem.addSepparator(menu);
                        bl2 = true;
                    }
                    OpenLaunchDialogAction action3 = new OpenLaunchDialogAction(group.getIdentifier());
                    ActionContributionItem item3 = new ActionContributionItem((IAction)action3);
                    item3.fill(menu, -1);
                }
            }
        }
    }

    private static MenuItem addSepparator(Menu menu) {
        return new MenuItem(menu, 2);
    }

    public void fill(CoolBar parent, int index) {
        super.fill(parent, index);
    }

    public void fill(ToolBar parent, int index) {
        super.fill(parent, index);
    }

    protected List<ILaunchConfiguration> extractSharedConfigurations(Object[] selection) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ILaunchConfiguration config = DebugUiInternals.isSharedConfig(object);
            if (config != null) {
                configurations.add(config);
            }
            ++n2;
        }
        return configurations;
    }
}

