/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.errorParsers;

import com.freescale.s32ds.cdt.core.errorParsers.CommonErrorParser;
import java.io.File;
import java.util.Stack;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ToolErrorParser
extends CommonErrorParser {
    String m_tool = null;
    Stack<CommonErrorParser.Message> record = new Stack();

    public ToolErrorParser(String tool) {
        this.m_tool = tool;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        block7: {
            CommonErrorParser.Message msg;
            block8: {
                block6: {
                    try {
                        if (!this.processRecordedMsg(eoParser, line)) break block6;
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (!line.startsWith("[" + this.m_tool + ",")) break block7;
                msg = new CommonErrorParser.Message();
                if (this.parseStandardErrorOutput(line, msg)) break block8;
                return false;
            }
            if (msg.isComplete()) {
                this.reportError(eoParser, msg);
            } else {
                this.recordError(msg);
            }
            return true;
        }
        return false;
    }

    private void recordError(CommonErrorParser.Message msg) {
        this.record.push(msg);
    }

    private boolean processRecordedMsg(ErrorParserManager eoParser, String line) {
        if (!this.record.isEmpty()) {
            CommonErrorParser.Message msg = this.record.pop();
            this.merge(line, msg);
            if (this.shouldReport(line, msg)) {
                this.reportError(eoParser, msg);
                return true;
            }
        }
        return false;
    }

    private void merge(String line, CommonErrorParser.Message msg) {
        int index;
        String name;
        if (msg.pendingAdditionalInput > 0) {
            msg.appendDescription(" " + line.trim());
            --msg.pendingAdditionalInput;
        }
        if (msg.filePath != null && line.contains(name = new File(msg.filePath).getName()) && (index = line.indexOf(58)) != -1) {
            msg.setDescription(line.substring(index + 1).trim());
        }
    }

    private boolean shouldReport(String line, CommonErrorParser.Message msg) {
        return msg.isComplete();
    }

    private void reportError(ErrorParserManager eoParser, CommonErrorParser.Message msg) {
        IFile resource = msg.getFile(eoParser);
        if (resource == null) {
            eoParser.generateExternalMarker(null, msg.lineNumber, msg.getDescription(), msg.getMarkerSeverity(), null, msg.getExternalFile());
        } else {
            eoParser.generateMarker((IResource)resource, msg.lineNumber, msg.getDescription(), msg.getMarkerSeverity(), null);
        }
    }
}

