/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.registry;

import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataRegistry {
    private final String tag;
    private final Map<String, ConfigurationData> dataMap = new LinkedHashMap<String, ConfigurationData>();

    public DataRegistry(String tag) {
        this.tag = tag;
    }

    public Map<String, ConfigurationData> getDataMap() {
        return this.dataMap;
    }

    public void register(ConfigurationData data) {
        if (this.tag.equals(data.getTag())) {
            this.dataMap.put(data.getId(), data);
        }
    }

    public ConfigurationData getDefaultData() {
        return this.dataMap.values().iterator().next();
    }

    public Collection<ConfigurationData> getDatas() {
        return this.dataMap.values();
    }

    public String toString() {
        return "{" + this.tag + "=" + this.dataMap.toString() + "}";
    }
}

