/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.data.TemplateData;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

public class CoreNatureConfiguration {
    private final CoreNatureData coreNature;
    private final TemplateData template;
    private final IToolChain toolChain;

    public CoreNatureConfiguration(CoreNatureData coreNature, TemplateData template) {
        this.template = template;
        this.coreNature = coreNature;
        CdtTemplateInfo templateInfo = template.getTemplateInfo(coreNature instanceof CoreData);
        String toolChainId = templateInfo != null ? templateInfo.getToolChainId() : null;
        this.toolChain = coreNature.getRegistry().getToolChain(toolChainId);
    }

    public CoreNatureConfiguration(CoreNatureData coreNature, TemplateData template, IToolChain toolChain) {
        this.template = template;
        this.coreNature = coreNature;
        this.toolChain = toolChain;
    }

    public String getKey() {
        return String.valueOf(this.template.getId()) + "_" + this.coreNature.getId();
    }

    public CoreNatureData getCoreNature() {
        return this.coreNature;
    }

    public TemplateData getTemplate() {
        return this.template;
    }

    public IToolChain getToolChain() {
        return this.toolChain;
    }

    public List<ContextPart> getContextParts(boolean executable) {
        return executable ? this.getExecutableContextParts() : this.getLibraryContextParts();
    }

    public List<ContextPart> getExecutableContextParts() {
        return Arrays.asList(this.template.getExecutableContextPart());
    }

    public List<ContextPart> getLibraryContextParts() {
        return Arrays.asList(this.template.getLibraryContextPart());
    }

    public static List<ContextPart> getContextParts(CoreNatureConfiguration configuration, ProcessorData processor, boolean executable) {
        ArrayList<ContextPart> result = new ArrayList<ContextPart>();
        result.addAll(configuration.getContextParts(executable));
        result.add(processor.getProcessorPart());
        return result;
    }

    public static List<ContextPart> getContextParts(List<CoreNatureConfiguration> configurations, ProcessorData processor, boolean executable) {
        ArrayList<ContextPart> result = new ArrayList<ContextPart>();
        for (CoreNatureConfiguration c : configurations) {
            result.addAll(c.getContextParts(executable));
        }
        result.add(processor.getProcessorPart());
        return result;
    }

    public static List<CoreNatureConfiguration> getAll(CoreNatureData coreNature) {
        ArrayList<CoreNatureConfiguration> rs = new ArrayList<CoreNatureConfiguration>();
        for (TemplateData t : coreNature.getTemplates()) {
            rs.add(new CoreNatureConfiguration(coreNature, t));
        }
        return rs.stream().filter(x -> x.getToolChain() != null).collect(Collectors.toList());
    }

    public static List<CoreNatureConfiguration> getDefaults(ProcessorData processor, boolean executable) {
        return CoreNatureConfiguration.getDefaults(processor, executable, null);
    }

    public static List<CoreNatureConfiguration> getDefaults(ProcessorData processor, boolean executable, String toolchainId) {
        ArrayList<CoreNatureConfiguration> result = new ArrayList<CoreNatureConfiguration>();
        List<CoreNatureData> cs = processor.getCoreNatures(executable);
        for (CoreNatureData c : cs) {
            List<CoreNatureConfiguration> rs = CoreNatureConfiguration.getAll(c);
            if (toolchainId == null && !rs.isEmpty()) {
                result.add(rs.get(0));
                continue;
            }
            rs.stream().filter(cCore -> cCore.getToolChain().getId().equalsIgnoreCase(toolchainId)).findFirst().ifPresent(result::add);
        }
        return result;
    }

    public static CoreNatureConfiguration createDefault(CoreNatureData coreNature) {
        List<TemplateData> templates = coreNature.getTemplates();
        return templates.isEmpty() ? null : new CoreNatureConfiguration(coreNature, templates.get(0));
    }
}

