/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.AffectType;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.context.ContextParameterManager;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.data.SimpleData;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import com.freescale.s32ds.cross.core.model.registry.DataRegistry;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractContext {
    private final ConfigurationData rootData;
    private final ModelRegistry registry;
    private final Map<String, Object> valueMap = new LinkedHashMap<String, Object>();
    private final Map<String, Object> defaultValueMap = new LinkedHashMap<String, Object>();
    private final Map<String, String> contextValueMap = new HashMap<String, String>();
    private final AbstractContext parent;
    private final ContextParameterManager parameterManager;
    private final ContextDefinition contextDefinition;
    private final Map<String, DataSet> dataSetMap = new HashMap<String, DataSet>();
    private final Map<String, DataSet> defaultDataSetMap = new HashMap<String, DataSet>();

    public AbstractContext(ObjectData rootData, ContextDefinition contextDefinition, List<ContextPart> insertionParts, ModelRegistry registry) {
        this(rootData, contextDefinition, insertionParts, registry, null);
    }

    public AbstractContext(ObjectData rootData, ContextDefinition contextDefinition, List<ContextPart> insertionParts, ModelRegistry registry, AbstractContext parent) {
        this.registry = registry;
        this.rootData = rootData;
        this.parent = parent;
        this.contextDefinition = contextDefinition;
        this.parameterManager = new ContextParameterManager(this, contextDefinition, insertionParts, rootData);
    }

    public void initData() {
        this.initData(this.rootData);
    }

    public abstract List<AbstractContext> getChildren();

    public abstract AbstractContext getMainChildContext();

    public ModelRegistry getRegistry() {
        return this.registry;
    }

    public String getContextId() {
        return this.rootData != null ? this.rootData.getId() : this.registry.getId();
    }

    public List<ParameterType> getParameterTypes() {
        return this.parameterManager.getParameterTypes();
    }

    public ContextType getContextType() {
        return this.contextDefinition.getType();
    }

    public ConfigurationData getRootData() {
        return this.rootData;
    }

    public AbstractContext getParent() {
        return this.parent;
    }

    public ContextDefinition getContextDefinition() {
        return this.contextDefinition;
    }

    public boolean isParameterSingle(String tag) {
        return this.parameterManager.isParameterSingle(tag);
    }

    public boolean isParameterApplyAll(String tag) {
        return this.parameterManager.isParameterApplyAll(tag);
    }

    public AffectType getAffectType(String tag) {
        return this.parameterManager.getAffectType(tag);
    }

    public boolean isAffected(String tag) {
        return true;
    }

    public ContextParameterManager getParameterManager() {
        return this.parameterManager;
    }

    public Collection<Parameter> getParameters() {
        return this.parameterManager.getParameters();
    }

    public Parameter getParameter(String tag) {
        return this.parameterManager.getParameter(tag);
    }

    public Parameter getParameter(ParameterType parameterType) {
        return this.parameterManager.getParameter(parameterType);
    }

    public List<ConfigurationData> getDataRange(String tag) {
        List<ConfigurationData> datas = ConfigurationData.getDataRange(tag, this.dataSetMap);
        if (!datas.isEmpty()) {
            return datas;
        }
        Object value = this.valueMap.get(tag);
        ConfigurationData data = ConfigurationData.getData(tag, value, this.rootData);
        return Arrays.asList(data);
    }

    public DataSet getDataSet(String tag) {
        String setTag = ParameterType.findSetTag(tag);
        return this.dataSetMap.get(setTag);
    }

    public Map<String, Object> getValueMap() {
        return Collections.unmodifiableMap(this.valueMap);
    }

    public ChangeResult setValue(String tag, Object value) {
        return this.setValue(tag, value, false);
    }

    public void setContextValue(String tag, String value) {
        this.contextValueMap.put(tag, value);
    }

    public String getContextValue(String tag) {
        return this.contextValueMap.get(tag);
    }

    public void reset() {
        this.valueMap.clear();
        this.valueMap.putAll(this.defaultValueMap);
        this.dataSetMap.clear();
        this.dataSetMap.putAll(this.defaultDataSetMap);
        this.initData(this.rootData);
    }

    public Object getValue(String tag) {
        AbstractContext context = this;
        while (context != null) {
            Object v = context.getValueMap().get(tag);
            if (v != null) {
                return v;
            }
            context = context.getParent();
        }
        return this.rootData != null ? this.rootData.getValue(tag) : null;
    }

    public String getStringValue(String tag) {
        return ModelUtil.convertToString(this.getValue(tag));
    }

    public long getLongValue(String tag) {
        Object v = this.getValue(tag);
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            return ModelUtil.parseLong(v.toString(), 16);
        }
        return 0L;
    }

    public int getIntValue(String tag) {
        Object v = this.getValue(tag);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return ModelUtil.parseInteger(v.toString());
        }
        return 0;
    }

    public boolean getBooleanValue(String tag) {
        Object v = this.getValue(tag);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return ModelUtil.parseBoolean(v.toString());
        }
        return false;
    }

    public boolean isParameterEnabled(String tag) {
        return this.parameterManager.isParameterEnabled(tag);
    }

    public boolean containsParameter(String tag) {
        return this.parameterManager.containsParameter(tag);
    }

    protected void addChange(ContextChange contextChange) {
        if (contextChange == null || !this.equals(contextChange.getContext())) {
            return;
        }
        this.dataSetMap.putAll(contextChange.getDataSetMap());
        this.valueMap.putAll(contextChange.getValueMap());
        for (String tag : this.valueMap.keySet()) {
            List<Object> vs;
            String setTag = String.valueOf(tag) + "Set";
            Object value = this.valueMap.get(tag);
            DataSet dataSet = contextChange.getDataSet(setTag);
            if (dataSet == null || (vs = dataSet.getValueRange()).size() <= 0 || vs.contains(value)) continue;
            this.putValue(setTag, value);
        }
    }

    private ChangeResult setValue(String tag, Object value, boolean onInit) {
        ParameterType parameterType = this.getRegistry().getParameterType(tag);
        if (parameterType == null) {
            Activator.log(new IllegalArgumentException("Parameter by tag: " + tag + " not found in project context: " + (Object)((Object)this.getContextType())));
            return ChangeResult.createDeclined();
        }
        if (parameterType.hasNamedIds()) {
            value = this.getValueByName(tag, value);
        }
        if (value == null) {
            Activator.logWarning("Value == null for tag " + tag);
            return ChangeResult.createDeclined();
        }
        ChangeResult result = this.parameterManager.getChangeResult(tag, value, onInit);
        if (result.isApproved()) {
            if (!onInit || !this.valueMap.containsKey(tag)) {
                this.putValue(tag, value);
            }
            for (ContextChange c : result.getContextChanges()) {
                c.applyChanges();
            }
        } else {
            ContextChange c = new ContextChange(this, tag);
            c.addValue(tag, this.getValue(tag));
            result = new ChangeResult(false, Arrays.asList(c), result.getWarningMessage());
        }
        return result;
    }

    private void initData(ConfigurationData rootData) {
        ArrayList<ConfigurationData> datas = new ArrayList<ConfigurationData>();
        if (rootData != null) {
            for (ParameterType p : this.parameterManager.getParameterTypes()) {
                String setTag = ParameterType.findSetTag(p.getTag());
                ConfigurationData data = rootData.getElement(setTag);
                if (data == null && rootData != null) {
                    data = rootData.getElement(p.getTag());
                }
                if (data == null && rootData != null) {
                    data = ConfigurationData.getData(p.getTag(), rootData);
                }
                if (data == null) continue;
                datas.add(data);
            }
            List<ConfigurationData> rcs = rootData.getElements();
            for (ConfigurationData rc : rcs) {
                if (rc == null) continue;
                datas.add(rc);
            }
        }
        ArrayList<String> changedTags = new ArrayList<String>();
        for (ConfigurationData d : datas) {
            String v = null;
            String tag = d.getTag();
            ParameterType parameterType = this.registry.getParameterType(tag);
            if (parameterType == null && !tag.endsWith("Set") || parameterType != null && parameterType.isCalculate()) continue;
            if (d instanceof DataSet) {
                v = ((DataSet)d).getDefaultValue();
                this.dataSetMap.put(tag, (DataSet)d);
                tag = ((DataSet)d).getElementTag();
            } else {
                v = d instanceof SimpleData ? ((SimpleData)d).getValue() : d.getId();
            }
            if (v == null) continue;
            changedTags.add(tag);
            this.setValue(tag, v, true);
        }
        this.defaultValueMap.putAll(this.valueMap);
        this.defaultDataSetMap.putAll(this.dataSetMap);
    }

    private void putValue(String tag, Object value) {
        this.putToMap(tag, value);
        Parameter parameter = this.getParameter(tag);
        if (parameter != null && parameter.isSingle() && parameter.isApplyAll() && this.getParent() != null) {
            List<AbstractContext> cs = this.getParent().getChildren();
            AbstractContext main = this.getParent().getMainChildContext();
            if (this.equals(main)) {
                for (AbstractContext c : cs) {
                    if (this.equals(c)) continue;
                    c.putToMap(tag, value);
                }
            }
        }
    }

    private void putToMap(String tag, Object value) {
        this.valueMap.put(tag, value);
    }

    private String getValueByName(String tag, Object valueName) {
        if (this.rootData == null || !(valueName instanceof String)) {
            return valueName.toString();
        }
        String searchDataSetTag = ParameterType.isElementTag(tag) ? String.valueOf(tag) + "Set" : tag;
        DataSet dataSet = this.dataSetMap.get(searchDataSetTag);
        if (dataSet != null) {
            for (ConfigurationData data : dataSet.getElements()) {
                if (data.getId().equals(valueName)) {
                    return data.getId();
                }
                if (!data.getName().equals(valueName)) continue;
                return data.getId();
            }
        }
        DataRegistry dataRegistry = this.registry.getDataRegistry(tag);
        for (ConfigurationData configData : dataRegistry.getDatas()) {
            if (!configData.getName().equals(valueName)) continue;
            return configData.getId();
        }
        return valueName.toString();
    }
}

