/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import java.util.List;

public enum AffectType {
    ALL,
    NONE,
    MULTIPLE_PROJECT,
    MULTIPLE_PROJECT_EXECUTABLE,
    MULTIPLE_PROJECT_LIBRARY,
    SINGLE_PROJECT,
    SINGLE_PROJECT_EXECUTABLE,
    SINGLE_PROJECT_LIBRARY,
    CONTENT_EXIST;


    public static boolean isAffected(Parameter parameter, List<CoreNatureData> cores, boolean executable) {
        boolean multiple;
        if (parameter == null) {
            return false;
        }
        AffectType v = parameter.getAffectType();
        String tag = parameter.getTag();
        ParameterType refParameterType = parameter.getType().getRefParameterType();
        String refTag = refParameterType != null ? refParameterType.getTag() : null;
        boolean bl = multiple = cores.size() > 1;
        if (cores.size() == 1) {
            ProcessorData proc = cores.get(0).getProcessor();
            boolean bl2 = proc != null ? proc.getCores().size() > 1 : (multiple = false);
        }
        if (v == ALL) {
            return true;
        }
        if (v == NONE) {
            return false;
        }
        if (v == MULTIPLE_PROJECT) {
            return multiple;
        }
        if (v == MULTIPLE_PROJECT_EXECUTABLE) {
            return multiple && executable;
        }
        if (v == MULTIPLE_PROJECT_LIBRARY) {
            return multiple && !executable;
        }
        if (v == SINGLE_PROJECT) {
            return !multiple;
        }
        if (v == SINGLE_PROJECT_EXECUTABLE) {
            return !multiple && executable;
        }
        if (v == SINGLE_PROJECT_LIBRARY) {
            return !multiple && !executable;
        }
        if (v == CONTENT_EXIST) {
            for (CoreNatureData core : cores) {
                if (core.getElement(tag) == null && (refTag == null || core.getElement(refTag) == null)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

