/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.model;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableImpl;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import com.nxp.s32ds.debug.ide.global.variables.model.IGlobalVariablesResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LegacyGlobalVariablesResult
extends IGlobalVariablesResult {
    private static final String LINE_SEPARATOR = ":";
    private static final String FILE_PATH_REGEX = ".*:\\\\n";
    private static final String NON_DEBUGGING_SYMBOLS = "\\nNon-debugging symbols:\\n";
    private static final String ALL_DEFINED_VARIABLES = "All defined variables:\\n";
    private static final String FILE = "\\nFile ";
    private static final String VAR_REGEX = ".* .*;\\\\n";
    private List<GlobalVariableModel> globalVariables;
    private Map<String, SortedSet<GlobalVariableModel>> path2globalVariables;

    public LegacyGlobalVariablesResult(MIOutput record, String elfDirectory) {
        super(record);
        this.parseOutput(record, elfDirectory);
    }

    private void parseOutput(MIOutput record, String elfDirectory) {
        this.globalVariables = new ArrayList<GlobalVariableModel>();
        this.path2globalVariables = new HashMap<String, SortedSet<GlobalVariableModel>>();
        boolean wasAllVaraiblesDefined = false;
        MIOOBRecord[] mioobRecords = record.getMIOOBRecords();
        Path lastPath = null;
        TreeSet<GlobalVariableImpl> lastList = null;
        MIOOBRecord[] mIOOBRecordArray = mioobRecords;
        int n = mioobRecords.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord mioobRecord = mIOOBRecordArray[n2];
            if (mioobRecord instanceof MIConsoleStreamOutput) {
                MIConsoleStreamOutput consoleStreamOutput = (MIConsoleStreamOutput)mioobRecord;
                if (!wasAllVaraiblesDefined && consoleStreamOutput.getCString().equals(ALL_DEFINED_VARIABLES)) {
                    wasAllVaraiblesDefined = true;
                } else if (wasAllVaraiblesDefined) {
                    if (consoleStreamOutput.getCString().equals(NON_DEBUGGING_SYMBOLS)) {
                        if (lastList != null && !lastList.isEmpty()) {
                            this.globalVariables.addAll((Collection<GlobalVariableModel>)lastList);
                            this.path2globalVariables.put(lastPath.toOSString(), (SortedSet<GlobalVariableModel>)lastList);
                        }
                    } else if (consoleStreamOutput.getCString().equals(FILE)) {
                        if (lastList != null && !lastList.isEmpty()) {
                            this.globalVariables.addAll((Collection<GlobalVariableModel>)lastList);
                            this.path2globalVariables.put(lastPath.toOSString(), (SortedSet<GlobalVariableModel>)lastList);
                        }
                    } else if (consoleStreamOutput.getCString().matches(FILE_PATH_REGEX)) {
                        Path pathToUse = lastPath = new Path(consoleStreamOutput.getCString().substring(0, consoleStreamOutput.getCString().lastIndexOf(58)));
                        if (!lastPath.isAbsolute()) {
                            lastPath = new Path(String.valueOf(elfDirectory) + '/' + lastPath.toOSString());
                        }
                        if (!new File(lastPath.toOSString()).exists()) {
                            lastPath = pathToUse;
                        }
                        lastList = new TreeSet<GlobalVariableImpl>();
                    } else if (consoleStreamOutput.getCString().matches(VAR_REGEX)) {
                        String description = consoleStreamOutput.getCString().substring(0, consoleStreamOutput.getCString().indexOf("\\n"));
                        String[] splitString = description.split(LINE_SEPARATOR);
                        int index = splitString.length - 1;
                        int line = -1;
                        try {
                            line = Integer.parseInt(splitString[0]);
                        }
                        catch (NumberFormatException e) {
                            Activator.getInstance().logWarning(e.getMessage(), e.getCause());
                        }
                        int tabIndex = splitString[index].indexOf("\\t");
                        splitString[index] = splitString[index].substring(tabIndex < 0 ? 0 : tabIndex + 2);
                        description = splitString[index];
                        int nameStartIndex = description.lastIndexOf(32) + 1;
                        if (description.lastIndexOf(42) + 1 > nameStartIndex) {
                            nameStartIndex = description.lastIndexOf(42) + 1;
                        }
                        String name = description.substring(nameStartIndex, description.indexOf(59));
                        String array = "";
                        Path path = lastPath;
                        try {
                            String type = description.substring(0, nameStartIndex - 1);
                            if (name.contains("[") && name.contains("]")) {
                                array = name.substring(name.indexOf(91), name.indexOf(93) + 1);
                                type = String.valueOf(type) + " " + array;
                                name = name.substring(0, name.indexOf(91));
                            }
                            if (path != null && !type.contains(S32GlobalVariablesMessages.GlobalVar_Exception)) {
                                GlobalVariableImpl globalVariableModel = new GlobalVariableImpl(name, (IPath)path, type, line, description);
                                lastList.add(globalVariableModel);
                            }
                        }
                        catch (Exception e) {
                            Activator.getInstance().logError(e.getMessage(), e);
                        }
                    }
                }
            }
            ++n2;
        }
        if (lastList != null && !this.path2globalVariables.containsKey(lastPath.toOSString())) {
            this.globalVariables.addAll(lastList);
            this.path2globalVariables.put(lastPath.toOSString(), lastList);
        }
    }

    @Override
    public List<GlobalVariableModel> getGlobalVariables() {
        return this.globalVariables;
    }

    @Override
    public Map<String, SortedSet<GlobalVariableModel>> getPath2GlobalVariables() {
        return this.path2globalVariables;
    }
}

