/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime;

import com.nxp.s32ds.ext.rcp.internal.runtime.CoreRuntimeMessages;
import com.nxp.s32ds.ext.rcp.runtime.ExtensionDiagnostic;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public class ExtensionDiagnostician {
    public static ExtensionDiagnostic validateRequiredAttributes(IConfigurationElement configurationElement, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            if (configurationElement.getAttribute(attributeName) == null) {
                return new ExtensionDiagnostic(configurationElement, NLS.bind((String)CoreRuntimeMessages.ExtensionDiagnostician_missed_required_0_attribute, (Object)attributeName));
            }
            ++n2;
        }
        return ExtensionDiagnostic.OK;
    }

    public static ExtensionDiagnostic validateAttributesChoice(IConfigurationElement configurationElement, String ... names) {
        List values = Arrays.stream(names).map(n -> configurationElement.getAttribute(n)).filter(Objects::nonNull).collect(Collectors.toList());
        if (values.isEmpty()) {
            return new ExtensionDiagnostic(configurationElement, NLS.bind((String)CoreRuntimeMessages.ExtensionDiagnostician_one_of_the_following_attributes_must_be_defined_0, (Object)String.join((CharSequence)",", names)));
        }
        if (values.size() > 1) {
            return new ExtensionDiagnostic(configurationElement, NLS.bind((String)CoreRuntimeMessages.ExtensionDiagnostician_only_one_of_the_following_attributes_must_be_defined_0, (Object)String.join((CharSequence)",", names)));
        }
        return ExtensionDiagnostic.OK;
    }

    public static void log(RcpBundle bundle, ExtensionDiagnostic diagnostic) {
        if (diagnostic.isOK()) {
            return;
        }
        if (diagnostic.getMessage() != null) {
            bundle.logError(NLS.bind((String)CoreRuntimeMessages.ExtensionDiagnostician_extension_declaration_error_0_1, (Object)diagnostic.getMessage(), (Object)Extensions.printHierarchy(diagnostic.getElement())));
        }
        diagnostic.getChildren().stream().forEach(c -> ExtensionDiagnostician.log(bundle, c));
    }
}

