/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface.listeners;

import com.nxp.s32ds.ext.rcp.jface.internal.RcpJFaceActivator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class AutoMouseWheelSupportForWin7 {
    private static final String HANDLE_FIELD = "handle";
    private static final String SEND_MESSAGE_METHOD_NAME = "SendMessage";
    private static final String SB_LINEDOWN_FIELD = "SB_LINEDOWN";
    private static final String SB_LINEUP_FIELD = "SB_LINEUP";
    private static final String WM_VSCROLL_FIELD = "WM_VSCROLL";
    private static final String WIN32_OS_CLASS_NAME = "org.eclipse.swt.internal.win32.OS";
    private int WM_VSCROLL;
    private int SB_LINEUP;
    private int SB_LINEDOWN;
    private Method methodSendEventMethod32;
    private Method methodSendEventMethod64;
    private Display display;
    private Control fixedControl;
    private final AutoMouseWheelListener autoMouseWheelListener = new AutoMouseWheelListener();

    public AutoMouseWheelSupportForWin7(Control control) {
        this.fixedControl = control;
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        try {
            Class<?> os = Class.forName(WIN32_OS_CLASS_NAME);
            this.WM_VSCROLL = os.getDeclaredField(WM_VSCROLL_FIELD).getInt(null);
            this.SB_LINEUP = os.getDeclaredField(SB_LINEUP_FIELD).getInt(null);
            this.SB_LINEDOWN = os.getDeclaredField(SB_LINEDOWN_FIELD).getInt(null);
            if (Platform.getOSArch().equals("x86")) {
                this.methodSendEventMethod32 = os.getDeclaredMethod(SEND_MESSAGE_METHOD_NAME, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            } else {
                this.methodSendEventMethod64 = os.getDeclaredMethod(SEND_MESSAGE_METHOD_NAME, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE);
            }
            Display.getCurrent().addFilter(37, (Listener)this.autoMouseWheelListener);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            RcpJFaceActivator.getInstance().logError(e.getMessage());
        }
    }

    public final void dispose() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.removeFilter(37, (Listener)this.autoMouseWheelListener);
        }
    }

    private class AutoMouseWheelListener
    implements Listener {
        private AutoMouseWheelListener() {
        }

        public void handleEvent(Event event) {
            Control cursorControl = event.display.getCursorControl();
            if (this.isCursorPositionOnScrollBarComposite(event)) {
                return;
            }
            Control wheelControl = cursorControl;
            int scrollStyle = 768;
            if ((wheelControl = this.findTopLevelControl(wheelControl, scrollStyle)) == null || !AutoMouseWheelSupportForWin7.this.fixedControl.equals(wheelControl)) {
                return;
            }
            int style = wheelControl.getStyle();
            if (this.isScrollable(wheelControl, scrollStyle, style)) {
                ScrollBar scrollVerticalBar;
                int message = 0;
                if ((style & 0x200) != 0 && this.isExistScrollVerticalBar(scrollVerticalBar = ((Scrollable)wheelControl).getVerticalBar())) {
                    message = AutoMouseWheelSupportForWin7.this.WM_VSCROLL;
                }
                int event\u0421ount = event.count;
                int param = AutoMouseWheelSupportForWin7.this.SB_LINEUP;
                if (event.count < 0) {
                    event\u0421ount = -event\u0421ount;
                    param = AutoMouseWheelSupportForWin7.this.SB_LINEDOWN;
                }
                try {
                    int i = 0;
                    while (i < event\u0421ount) {
                        if (Platform.getOSArch().equals("x86")) {
                            int handle = Control.class.getDeclaredField(AutoMouseWheelSupportForWin7.HANDLE_FIELD).getInt(wheelControl);
                            AutoMouseWheelSupportForWin7.this.methodSendEventMethod32.invoke(null, handle, message, param, 0);
                        } else {
                            long handle = Control.class.getDeclaredField(AutoMouseWheelSupportForWin7.HANDLE_FIELD).getLong(wheelControl);
                            AutoMouseWheelSupportForWin7.this.methodSendEventMethod64.invoke(null, handle, message, param, 0);
                        }
                        ++i;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvocationTargetException e) {
                    Display.getCurrent().removeFilter(37, (Listener)AutoMouseWheelSupportForWin7.this.autoMouseWheelListener);
                    RcpJFaceActivator.getInstance().logError(e.getMessage());
                }
            } else {
                this.rollBackNotificationEvent(event, wheelControl);
            }
            event.type = 0;
            event.doit = false;
        }

        private Control findTopLevelControl(Control wheelControl, int scrollStyle) {
            while (wheelControl != null && (wheelControl.getStyle() & scrollStyle) == 0 && wheelControl.getListeners(37).length == 0) {
                wheelControl = wheelControl.getParent();
            }
            return wheelControl;
        }

        private boolean isScrollable(Control wheelControl, int scrollStyle, int style) {
            return (style & scrollStyle) != 0 && wheelControl instanceof Scrollable;
        }

        private void rollBackNotificationEvent(Event event, Control wheelControl) {
            Point cursorPos = wheelControl.toControl(event.display.getCursorLocation());
            event.x = cursorPos.x;
            event.y = cursorPos.y;
            event.widget = wheelControl;
            wheelControl.notifyListeners(event.type, event);
        }

        private boolean isExistScrollVerticalBar(ScrollBar scrollVerticalBar) {
            return scrollVerticalBar != null && (scrollVerticalBar.getMinimum() != 0 || scrollVerticalBar.getMaximum() != 0 || scrollVerticalBar.getSelection() != 0) && scrollVerticalBar.isEnabled() && scrollVerticalBar.isVisible();
        }

        private boolean isCursorPositionOnScrollBarComposite(Event event) {
            if (event.widget instanceof Control) {
                Control control = (Control)event.widget;
                Rectangle bounds = control.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                Point cursorPos = control.toControl(event.display.getCursorLocation());
                if (bounds.contains(cursorPos)) {
                    return true;
                }
            }
            return false;
        }
    }
}

